/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.jackson.configuration.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mastfrog.jackson.configuration.DurationSerializationMode;
import com.mastfrog.jackson.configuration.JacksonConfigurer;
import com.mastfrog.jackson.configuration.TimeSerializationMode;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import com.mastfrog.util.time.TimeUtil;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTimeConfigurer
implements JacksonConfigurer {
    private final TimeSerializationMode timeMode;
    private final DurationSerializationMode durationMode;
    static final DateTimeFormatter ISO_INSTANT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant().toFormatter(Locale.US);
    private static final ZoneId GMT = ZoneId.of("GMT");
    private final String stringVal;
    public static final DateTimeFormatter ISO2822DateFormat = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT_STANDALONE).appendLiteral(", ").appendText((TemporalField)ChronoField.DAY_OF_MONTH, TextStyle.FULL).appendLiteral(" ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral(" ").appendText((TemporalField)ChronoField.YEAR, TextStyle.FULL).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(" ").appendOffsetId().toFormatter();
    static final DateTimeFormatter TWO_DIGIT_YEAR = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_MONTH, TextStyle.FULL).appendLiteral(" ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral(" ").appendValue(ChronoField.YEAR, 2, 4, SignStyle.NEVER).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(" ").appendZoneOrOffsetId().toFormatter();

    public JavaTimeConfigurer() {
        this(TimeSerializationMode.TIME_AS_ISO_STRING, DurationSerializationMode.DURATION_AS_ISO_STRING);
    }

    public JavaTimeConfigurer(TimeSerializationMode mode, DurationSerializationMode durationMode) {
        this.timeMode = mode;
        this.durationMode = durationMode;
        this.stringVal = "JavaTimeConfigurer(" + (Object)((Object)mode) + "," + (Object)((Object)durationMode) + ")";
    }

    public String toString() {
        return this.stringVal;
    }

    @Override
    public ObjectMapper configure(ObjectMapper mapper) {
        SimpleModule sm = new SimpleModule("java-time", new Version(1, 0, 1, null, "com.mastfrog", "java-time"));
        sm.addSerializer(ZoneOffset.class, (JsonSerializer)new ZoneOffsetSerializer());
        sm.addDeserializer(ZoneOffset.class, (JsonDeserializer)new ZoneOffsetDeserializer());
        sm.addSerializer(ZoneId.class, (JsonSerializer)new ZoneIdSerializer());
        sm.addDeserializer(ZoneId.class, (JsonDeserializer)new ZoneIdDeserializer());
        switch (this.durationMode) {
            case DURATION_AS_MILLIS: {
                sm.addSerializer((JsonSerializer)new DurationToLongSerializer());
                sm.addDeserializer(Duration.class, (JsonDeserializer)new DurationFromLongDeserializer());
                sm.addSerializer(Period.class, (JsonSerializer)new CompactPeriodSerializer());
                sm.addDeserializer(Period.class, (JsonDeserializer)new CompactPeriodDeserializer());
                break;
            }
            case DURATION_AS_STRING: {
                sm.addSerializer((JsonSerializer)new DurationToStringSerializer());
                sm.addDeserializer(Duration.class, (JsonDeserializer)new DurationFromStringDeserializer());
                sm.addSerializer(Period.class, (JsonSerializer)new PeriodSerializer());
                sm.addDeserializer(Period.class, (JsonDeserializer)new PeriodDeserializer());
                break;
            }
            case DURATION_AS_ISO_STRING: {
                sm.addSerializer((JsonSerializer)new DurationToIsoStringSerializer());
                sm.addDeserializer(Duration.class, (JsonDeserializer)new DurationFromIsoStringDeserializer());
                sm.addSerializer(Period.class, (JsonSerializer)new PeriodSerializer());
                sm.addDeserializer(Period.class, (JsonDeserializer)new PeriodDeserializer());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AssertionError((Object)this.durationMode);
            }
        }
        switch (this.timeMode) {
            case TIME_AS_EPOCH_MILLIS: {
                sm.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeToLongSerializer());
                sm.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeFromLongDeserializer());
                sm.addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeToLongSerializer());
                sm.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeToLongDeserializer());
                sm.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeToLongSerializer());
                sm.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeFromLongDeserializer());
                sm.addSerializer(Instant.class, (JsonSerializer)new InstantToLongSerializer());
                sm.addDeserializer(Instant.class, (JsonDeserializer)new InstantFromLongDeserializer());
                sm.addSerializer(Date.class, (JsonSerializer)new DateToLongSerializer());
                sm.addDeserializer(Date.class, (JsonDeserializer)new DateFromLongDeserializer());
                break;
            }
            case TIME_AS_ISO_STRING: {
                sm.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeToIsoStringSerializer());
                sm.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeToIsoStringDeserializer());
                sm.addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeToIsoStringSerializer());
                sm.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeToIsoStringDeserializer());
                sm.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeToIsoStringSerializer());
                sm.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeToIsoStringDeserializer());
                sm.addSerializer(Instant.class, (JsonSerializer)new InstantToIsoStringSerializer());
                sm.addDeserializer(Instant.class, (JsonDeserializer)new InstantToIsoStringDeserializer());
                sm.addSerializer(Date.class, (JsonSerializer)new DateToIsoStringSerializer());
                sm.addDeserializer(Date.class, (JsonDeserializer)new DateFromIsoStringDeserializer());
                break;
            }
            case HTTP_HEADER_FORMAT: {
                sm.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeToHttpHeaderStringSerializer());
                sm.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeToHttpHeaderStringDeserializer());
                sm.addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeToHttpHeaderStringSerializer());
                sm.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeToHttpHeaderStringDeserializer());
                sm.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeToHttpHeaderStringSerializer());
                sm.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeToHttpHeaderStringDeserializer());
                sm.addSerializer(Instant.class, (JsonSerializer)new InstantToHttpHeaderStringSerializer());
                sm.addDeserializer(Instant.class, (JsonDeserializer)new InstantToHttpHeaderStringDeserializer());
                sm.addSerializer(Date.class, (JsonSerializer)new DateToHttpHeaderStringSerializer());
                sm.addDeserializer(Date.class, (JsonDeserializer)new DateFromHttpHeaderStringDeserializer());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AssertionError((Object)this.timeMode);
            }
        }
        sm.addSerializer(MonthDay.class, (JsonSerializer)new MonthDayToIsoStringSerializer());
        sm.addDeserializer(MonthDay.class, (JsonDeserializer)new MonthDayFromIsoStringDeserializer());
        sm.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateToIsoStringSerializer());
        sm.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateFromIsoStringDeserializer());
        sm.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeToIsoStringSerializer());
        sm.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeFromIsoStringDeserializer());
        sm.addSerializer(YearMonth.class, (JsonSerializer)new YearMonthToIsoStringSerializer());
        sm.addDeserializer(YearMonth.class, (JsonDeserializer)new YearMonthFromIsoStringDeserializer());
        sm.addSerializer(Year.class, (JsonSerializer)new YearToIsoStringSerializer());
        sm.addDeserializer(Year.class, (JsonDeserializer)new YearFromIsoStringDeserializer());
        mapper.registerModule((Module)sm);
        return mapper;
    }

    private static ZonedDateTime parseZonedDateTime(CharSequence value) {
        ZonedDateTime result;
        Checks.notNull((String)"value", (Object)value);
        try {
            ZonedDateTime top = ZonedDateTime.parse(value, ISO2822DateFormat);
            result = JavaTimeConfigurer.mungeYear(top);
        }
        catch (DateTimeParseException e) {
            try {
                ZonedDateTime rfs = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                result = JavaTimeConfigurer.mungeYear(rfs);
            }
            catch (DateTimeParseException e1) {
                e.addSuppressed(e1);
                try {
                    CharSequence munged = value;
                    int space = Strings.indexOf((char)' ', (CharSequence)munged);
                    if (space != -1) {
                        munged = value.subSequence(space + 1, value.length());
                    }
                    ZonedDateTime dt = ZonedDateTime.parse(munged, TWO_DIGIT_YEAR);
                    result = JavaTimeConfigurer.mungeYear(dt);
                }
                catch (DateTimeParseException ex2) {
                    e.addSuppressed(ex2);
                    try {
                        long val = Date.parse(value.toString());
                        result = TimeUtil.fromUnixTimestamp((long)val);
                    }
                    catch (IllegalArgumentException e3) {
                        e.addSuppressed(e3);
                        new IllegalArgumentException(value.toString(), e).printStackTrace(System.err);
                        return null;
                    }
                }
            }
        }
        if (result.getZone().toString().equals("Z")) {
            result = result.withZoneSameInstant(GMT);
        }
        return result;
    }

    private static ZonedDateTime mungeYear(ZonedDateTime dt) {
        int yr = dt.get(ChronoField.YEAR);
        if (yr < 100 && yr >= 0) {
            yr = yr >= 50 ? (yr += 1900) : (yr += 2000);
            dt = dt.withYear(yr);
        }
        return dt;
    }

    private static final class ZoneOffsetSerializer
    extends JsonSerializer<ZoneOffset> {
        private ZoneOffsetSerializer() {
        }

        public Class<ZoneOffset> handledType() {
            return ZoneOffset.class;
        }

        public void serialize(ZoneOffset t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.getTotalSeconds(), jg);
        }
    }

    private static final class ZoneOffsetDeserializer
    extends JsonDeserializer<ZoneOffset> {
        private ZoneOffsetDeserializer() {
        }

        public Class<?> handledType() {
            return ZoneOffset.class;
        }

        public ZoneOffset deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            int offset = (Integer)jp.readValueAs(Integer.TYPE);
            return ZoneOffset.ofTotalSeconds(offset);
        }
    }

    private static final class ZoneIdSerializer
    extends JsonSerializer<ZoneId> {
        private ZoneIdSerializer() {
        }

        public Class<ZoneId> handledType() {
            return ZoneId.class;
        }

        public void serialize(ZoneId t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.getId(), jg);
        }
    }

    private static final class ZoneIdDeserializer
    extends JsonDeserializer<ZoneId> {
        private ZoneIdDeserializer() {
        }

        public Class<?> handledType() {
            return ZoneId.class;
        }

        public ZoneId deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String id = (String)jp.readValueAs(String.class);
            return ZoneId.of(id);
        }
    }

    private static final class DurationToLongSerializer
    extends JsonSerializer<Duration> {
        private DurationToLongSerializer() {
        }

        public Class<Duration> handledType() {
            return Duration.class;
        }

        public void serialize(Duration t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)(t == null ? 0L : t.toMillis()), jg);
        }
    }

    private static final class DurationFromLongDeserializer
    extends JsonDeserializer<Duration> {
        private DurationFromLongDeserializer() {
        }

        public Class<Duration> handledType() {
            return Duration.class;
        }

        public Duration deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            long epochMillis = (Long)jp.readValueAs(Long.TYPE);
            return Duration.ofMillis(epochMillis);
        }
    }

    private static final class CompactPeriodSerializer
    extends JsonSerializer<Period> {
        private CompactPeriodSerializer() {
        }

        public Class<Period> handledType() {
            return Period.class;
        }

        public void serialize(Period t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String val = new StringBuilder(20).append('P').append(t.getYears()).append('Y').append(t.getMonths()).append('M').append(t.getDays()).append('D').toString();
            sp.defaultSerializeValue((Object)val, jg);
        }
    }

    private static final class CompactPeriodDeserializer
    extends JsonDeserializer<Period> {
        private static final Pattern PAT = Pattern.compile("P(\\d+)Y(\\d+)M(\\d+)D");

        private CompactPeriodDeserializer() {
        }

        public Class<?> handledType() {
            return Period.class;
        }

        public Period deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String s = (String)jp.readValueAs(String.class);
            Matcher m = PAT.matcher(s);
            if (m.find()) {
                int years = Integer.parseInt(m.group(1));
                int months = Integer.parseInt(m.group(2));
                int days = Integer.parseInt(m.group(3));
                return Period.of(years, months, days);
            }
            throw new IOException("Period not in format PnYnMnD: '" + s + "'");
        }
    }

    private static final class DurationToStringSerializer
    extends JsonSerializer<Duration> {
        private DurationToStringSerializer() {
        }

        public Class<Duration> handledType() {
            return Duration.class;
        }

        public void serialize(Duration t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)TimeUtil.format((Duration)t), jg);
        }
    }

    private static final class DurationFromStringDeserializer
    extends JsonDeserializer<Duration> {
        private DurationFromStringDeserializer() {
        }

        public Class<Duration> handledType() {
            return Duration.class;
        }

        public Duration deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String s = (String)jp.readValueAs(String.class);
            return TimeUtil.parseDuration((String)s);
        }
    }

    private static final class PeriodSerializer
    extends JsonSerializer<Period> {
        private PeriodSerializer() {
        }

        public Class<Period> handledType() {
            return Period.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(Period t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            jg.writeStartObject();
            try {
                for (TemporalUnit unit : t.getUnits()) {
                    jg.writeObjectField(unit.toString().toLowerCase(), (Object)t.get(unit));
                }
            }
            finally {
                jg.writeEndObject();
            }
        }
    }

    private static final class PeriodDeserializer
    extends JsonDeserializer<Period> {
        private PeriodDeserializer() {
        }

        public Class<?> handledType() {
            return Period.class;
        }

        public Period deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            Map m = (Map)jp.readValueAs(Map.class);
            Period p = Period.ZERO;
            block5: for (Map.Entry e : m.entrySet()) {
                ChronoUnit unit = ChronoUnit.valueOf(((String)e.getKey()).toUpperCase());
                long val = ((Number)e.getValue()).longValue();
                switch (unit) {
                    case DAYS: {
                        p = p.plusDays(val);
                        continue block5;
                    }
                    case MONTHS: {
                        p = p.plusMonths(val);
                        continue block5;
                    }
                    case YEARS: {
                        p = p.plusYears(val);
                        continue block5;
                    }
                }
                throw new AssertionError(unit);
            }
            return p;
        }
    }

    private static final class DurationToIsoStringSerializer
    extends JsonSerializer<Duration> {
        private DurationToIsoStringSerializer() {
        }

        public Class<Duration> handledType() {
            return Duration.class;
        }

        public void serialize(Duration t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.toString(), jg);
        }
    }

    private static final class DurationFromIsoStringDeserializer
    extends JsonDeserializer<Duration> {
        private DurationFromIsoStringDeserializer() {
        }

        public Class<Duration> handledType() {
            return Duration.class;
        }

        public Duration deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String s = (String)jp.readValueAs(String.class);
            return Duration.parse(s);
        }
    }

    private static final class ZonedDateTimeToLongSerializer
    extends JsonSerializer<ZonedDateTime> {
        private ZonedDateTimeToLongSerializer() {
        }

        public Class<ZonedDateTime> handledType() {
            return ZonedDateTime.class;
        }

        public void serialize(ZonedDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)(t == null ? 0L : t.toInstant().toEpochMilli()), jg);
        }
    }

    private static final class ZonedDateTimeFromLongDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        private ZonedDateTimeFromLongDeserializer() {
        }

        public Class<?> handledType() {
            return ZonedDateTime.class;
        }

        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            if (!jp.currentToken().isNumeric()) {
                String timestamp = (String)jp.readValueAs(String.class);
                return ZonedDateTime.parse(timestamp, ISO_INSTANT);
            }
            long epochMillis = (Long)jp.readValueAs(Long.TYPE);
            return Instant.ofEpochMilli(epochMillis).atZone(GMT);
        }
    }

    private static final class OffsetDateTimeToLongSerializer
    extends JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeToLongSerializer() {
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }

        public void serialize(OffsetDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)(t == null ? 0L : t.toInstant().toEpochMilli()), jg);
        }
    }

    private static final class OffsetDateTimeToLongDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeToLongDeserializer() {
        }

        public Class<?> handledType() {
            return OffsetDateTime.class;
        }

        public OffsetDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            long epochMillis = (Long)jp.readValueAs(Long.TYPE);
            return Instant.ofEpochMilli(epochMillis).atOffset(ZoneOffset.systemDefault().getRules().getOffset(Instant.now()));
        }
    }

    private static final class LocalDateTimeToLongSerializer
    extends JsonSerializer<LocalDateTime> {
        private LocalDateTimeToLongSerializer() {
        }

        public Class<LocalDateTime> handledType() {
            return LocalDateTime.class;
        }

        public void serialize(LocalDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)(t == null ? 0L : t.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()), jg);
        }
    }

    private static final class LocalDateTimeFromLongDeserializer
    extends JsonDeserializer<LocalDateTime> {
        private LocalDateTimeFromLongDeserializer() {
        }

        public Class<?> handledType() {
            return LocalDateTime.class;
        }

        public LocalDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            long epochMillis = (Long)jp.readValueAs(Long.TYPE);
            return Instant.ofEpochMilli(epochMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
    }

    private static final class InstantToLongSerializer
    extends JsonSerializer<Instant> {
        private InstantToLongSerializer() {
        }

        public Class<Instant> handledType() {
            return Instant.class;
        }

        public void serialize(Instant t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)(t == null ? 0L : t.toEpochMilli()), jg);
        }
    }

    private static final class InstantFromLongDeserializer
    extends JsonDeserializer<Instant> {
        private InstantFromLongDeserializer() {
        }

        public Class<?> handledType() {
            return Instant.class;
        }

        public Instant deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            long epochMillis = (Long)jp.readValueAs(Long.TYPE);
            return Instant.ofEpochMilli(epochMillis);
        }
    }

    private static final class DateToLongSerializer
    extends JsonSerializer<Date> {
        private DateToLongSerializer() {
        }

        public Class<Date> handledType() {
            return Date.class;
        }

        public void serialize(Date t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.getTime(), jg);
        }
    }

    private static final class DateFromLongDeserializer
    extends JsonDeserializer<Date> {
        private DateFromLongDeserializer() {
        }

        public Class<?> handledType() {
            return Date.class;
        }

        public Date deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            long epochMillis = (Long)jp.readValueAs(Long.TYPE);
            return new Date(epochMillis);
        }
    }

    private static final class ZonedDateTimeToIsoStringSerializer
    extends JsonSerializer<ZonedDateTime> {
        private ZonedDateTimeToIsoStringSerializer() {
        }

        public Class<ZonedDateTime> handledType() {
            return ZonedDateTime.class;
        }

        public void serialize(ZonedDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String formatted = ISO_INSTANT.format(t);
            sp.defaultSerializeValue((Object)formatted, jg);
        }
    }

    private static final class ZonedDateTimeToIsoStringDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        private ZonedDateTimeToIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return ZonedDateTime.class;
        }

        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            if (jp.currentToken().isNumeric()) {
                long epochMillis = (Long)jp.readValueAs(Long.TYPE);
                return Instant.ofEpochMilli(epochMillis).atZone(GMT);
            }
            String timestamp = (String)jp.readValueAs(String.class);
            Instant inst = Instant.parse(timestamp);
            return ZonedDateTime.ofInstant(inst, GMT);
        }
    }

    private static final class OffsetDateTimeToIsoStringSerializer
    extends JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeToIsoStringSerializer() {
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }

        public void serialize(OffsetDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String formatted = ISO_INSTANT.format(t);
            sp.defaultSerializeValue((Object)formatted, jg);
        }
    }

    private static final class OffsetDateTimeToIsoStringDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeToIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return OffsetDateTime.class;
        }

        public OffsetDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return OffsetDateTime.parse(timestamp);
        }
    }

    private static final class LocalDateTimeToIsoStringSerializer
    extends JsonSerializer<LocalDateTime> {
        private LocalDateTimeToIsoStringSerializer() {
        }

        public Class<LocalDateTime> handledType() {
            return LocalDateTime.class;
        }

        public void serialize(LocalDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String fmt = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(t);
            sp.defaultSerializeValue((Object)fmt, jg);
        }
    }

    private static final class LocalDateTimeToIsoStringDeserializer
    extends JsonDeserializer<LocalDateTime> {
        private LocalDateTimeToIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return LocalDateTime.class;
        }

        public LocalDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return LocalDateTime.parse(timestamp, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
    }

    private static final class InstantToIsoStringSerializer
    extends JsonSerializer<Instant> {
        private InstantToIsoStringSerializer() {
        }

        public Class<Instant> handledType() {
            return Instant.class;
        }

        public void serialize(Instant t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.toString(), jg);
        }
    }

    private static final class InstantToIsoStringDeserializer
    extends JsonDeserializer<Instant> {
        private InstantToIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return Instant.class;
        }

        public Instant deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return Instant.parse(timestamp);
        }
    }

    private static final class DateToIsoStringSerializer
    extends JsonSerializer<Date> {
        private DateToIsoStringSerializer() {
        }

        public Class<Date> handledType() {
            return Date.class;
        }

        public void serialize(Date t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String formatted = ISO_INSTANT.format(Instant.ofEpochMilli(t.getTime()));
            sp.defaultSerializeValue((Object)formatted, jg);
        }
    }

    private static final class DateFromIsoStringDeserializer
    extends JsonDeserializer<Date> {
        private DateFromIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return Date.class;
        }

        public Date deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            if (jp.currentToken().isNumeric()) {
                long epochMillis = (Long)jp.readValueAs(Long.TYPE);
                return new Date(epochMillis);
            }
            String timestamp = (String)jp.readValueAs(String.class);
            Instant inst = Instant.parse(timestamp);
            return new Date(inst.toEpochMilli());
        }
    }

    private static final class ZonedDateTimeToHttpHeaderStringSerializer
    extends JsonSerializer<ZonedDateTime> {
        private ZonedDateTimeToHttpHeaderStringSerializer() {
        }

        public Class<ZonedDateTime> handledType() {
            return ZonedDateTime.class;
        }

        public void serialize(ZonedDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.format(ISO2822DateFormat), jg);
        }
    }

    private static final class ZonedDateTimeToHttpHeaderStringDeserializer
    extends JsonDeserializer<ZonedDateTime> {
        private ZonedDateTimeToHttpHeaderStringDeserializer() {
        }

        public Class<?> handledType() {
            return ZonedDateTime.class;
        }

        public ZonedDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return JavaTimeConfigurer.parseZonedDateTime(timestamp);
        }
    }

    private static final class OffsetDateTimeToHttpHeaderStringSerializer
    extends JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeToHttpHeaderStringSerializer() {
        }

        public Class<OffsetDateTime> handledType() {
            return OffsetDateTime.class;
        }

        public void serialize(OffsetDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            sp.defaultSerializeValue((Object)t.format(ISO2822DateFormat), jg);
        }
    }

    private static final class OffsetDateTimeToHttpHeaderStringDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeToHttpHeaderStringDeserializer() {
        }

        public Class<?> handledType() {
            return OffsetDateTime.class;
        }

        public OffsetDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return JavaTimeConfigurer.parseZonedDateTime(timestamp).toOffsetDateTime();
        }
    }

    private static final class LocalDateTimeToHttpHeaderStringSerializer
    extends JsonSerializer<LocalDateTime> {
        private LocalDateTimeToHttpHeaderStringSerializer() {
        }

        public Class<LocalDateTime> handledType() {
            return LocalDateTime.class;
        }

        public void serialize(LocalDateTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            ZonedDateTime zdt = t.atZone(ZoneId.systemDefault());
            sp.defaultSerializeValue((Object)zdt.format(ISO2822DateFormat), jg);
        }
    }

    private static final class LocalDateTimeToHttpHeaderStringDeserializer
    extends JsonDeserializer<LocalDateTime> {
        private LocalDateTimeToHttpHeaderStringDeserializer() {
        }

        public Class<?> handledType() {
            return LocalDateTime.class;
        }

        public LocalDateTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return JavaTimeConfigurer.parseZonedDateTime(timestamp).toLocalDateTime();
        }
    }

    private static final class InstantToHttpHeaderStringSerializer
    extends JsonSerializer<Instant> {
        private InstantToHttpHeaderStringSerializer() {
        }

        public Class<Instant> handledType() {
            return Instant.class;
        }

        public void serialize(Instant t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(t, GMT);
            sp.defaultSerializeValue((Object)zdt.format(ISO2822DateFormat), jg);
        }
    }

    private static final class InstantToHttpHeaderStringDeserializer
    extends JsonDeserializer<Instant> {
        private InstantToHttpHeaderStringDeserializer() {
        }

        public Class<?> handledType() {
            return Instant.class;
        }

        public Instant deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            ZonedDateTime zdt = JavaTimeConfigurer.parseZonedDateTime(timestamp);
            return zdt.toInstant();
        }
    }

    private static final class DateToHttpHeaderStringSerializer
    extends JsonSerializer<Date> {
        private DateToHttpHeaderStringSerializer() {
        }

        public Class<Date> handledType() {
            return Date.class;
        }

        public void serialize(Date t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(t.getTime()), GMT);
            sp.defaultSerializeValue((Object)zdt.format(ISO2822DateFormat), jg);
        }
    }

    private static final class DateFromHttpHeaderStringDeserializer
    extends JsonDeserializer<Date> {
        private DateFromHttpHeaderStringDeserializer() {
        }

        public Class<?> handledType() {
            return Date.class;
        }

        public Date deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            ZonedDateTime zdt = JavaTimeConfigurer.parseZonedDateTime(timestamp);
            return new Date(zdt.toInstant().toEpochMilli());
        }
    }

    private static final class MonthDayToIsoStringSerializer
    extends JsonSerializer<MonthDay> {
        private MonthDayToIsoStringSerializer() {
        }

        public Class<MonthDay> handledType() {
            return MonthDay.class;
        }

        public void serialize(MonthDay t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String fmt = t.toString();
            sp.defaultSerializeValue((Object)fmt, jg);
        }
    }

    private static final class MonthDayFromIsoStringDeserializer
    extends JsonDeserializer<MonthDay> {
        private MonthDayFromIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return MonthDay.class;
        }

        public MonthDay deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return MonthDay.parse(timestamp);
        }
    }

    private static final class LocalDateToIsoStringSerializer
    extends JsonSerializer<LocalDate> {
        private LocalDateToIsoStringSerializer() {
        }

        public Class<LocalDate> handledType() {
            return LocalDate.class;
        }

        public void serialize(LocalDate t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String fmt = t.format(DateTimeFormatter.ISO_LOCAL_DATE);
            sp.defaultSerializeValue((Object)fmt, jg);
        }
    }

    private static final class LocalDateFromIsoStringDeserializer
    extends JsonDeserializer<LocalDate> {
        private LocalDateFromIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return LocalDate.class;
        }

        public LocalDate deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return LocalDate.parse(timestamp, DateTimeFormatter.ISO_LOCAL_DATE);
        }
    }

    private static final class LocalTimeToIsoStringSerializer
    extends JsonSerializer<LocalTime> {
        private LocalTimeToIsoStringSerializer() {
        }

        public Class<LocalTime> handledType() {
            return LocalTime.class;
        }

        public void serialize(LocalTime t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String fmt = t.format(DateTimeFormatter.ISO_LOCAL_TIME);
            sp.defaultSerializeValue((Object)fmt, jg);
        }
    }

    private static final class LocalTimeFromIsoStringDeserializer
    extends JsonDeserializer<LocalTime> {
        private LocalTimeFromIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return LocalTime.class;
        }

        public LocalTime deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return LocalTime.parse(timestamp, DateTimeFormatter.ISO_LOCAL_TIME);
        }
    }

    private static final class YearMonthToIsoStringSerializer
    extends JsonSerializer<YearMonth> {
        private YearMonthToIsoStringSerializer() {
        }

        public Class<YearMonth> handledType() {
            return YearMonth.class;
        }

        public void serialize(YearMonth t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String fmt = t.toString();
            sp.defaultSerializeValue((Object)fmt, jg);
        }
    }

    private static final class YearMonthFromIsoStringDeserializer
    extends JsonDeserializer<YearMonth> {
        private YearMonthFromIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return YearMonth.class;
        }

        public YearMonth deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return YearMonth.parse(timestamp);
        }
    }

    private static final class YearToIsoStringSerializer
    extends JsonSerializer<Year> {
        private YearToIsoStringSerializer() {
        }

        public Class<Year> handledType() {
            return Year.class;
        }

        public void serialize(Year t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            String fmt = t.toString();
            sp.defaultSerializeValue((Object)fmt, jg);
        }
    }

    private static final class YearFromIsoStringDeserializer
    extends JsonDeserializer<Year> {
        private YearFromIsoStringDeserializer() {
        }

        public Class<?> handledType() {
            return Year.class;
        }

        public Year deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String timestamp = (String)jp.readValueAs(String.class);
            return Year.parse(timestamp);
        }
    }
}

