/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.jackson.configuration.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mastfrog.jackson.configuration.JacksonConfigurer;
import java.io.IOException;
import java.util.Locale;

public final class LocaleJacksonConfigurer
implements JacksonConfigurer {
    private static final LocaleSerializer LOCALE_SERIALIZER = new LocaleSerializer();
    private static final LocaleKeySerializer LOCALE_KEY_SERIALIZER = new LocaleKeySerializer();
    private static final LocaleDeserializer LOCALE_DESERIALIZER = new LocaleDeserializer();
    private static final LocaleKeyDeserializer LOCALE_KEY_DESERIALIZER = new LocaleKeyDeserializer();

    @Override
    public ObjectMapper configure(ObjectMapper om) {
        SimpleModule sm = new SimpleModule("optional1", new Version(1, 0, 0, null, "com.mastfrog", "java-locale-serializer"));
        sm.addKeyDeserializer(Locale.class, (KeyDeserializer)LOCALE_KEY_DESERIALIZER);
        sm.addKeySerializer(Locale.class, (JsonSerializer)LOCALE_KEY_SERIALIZER);
        sm.addDeserializer(Locale.class, (JsonDeserializer)LOCALE_DESERIALIZER);
        sm.addSerializer(Locale.class, (JsonSerializer)LOCALE_SERIALIZER);
        om.registerModule((Module)sm);
        return om;
    }

    public String toString() {
        return "LocaleJacksonConfigurer";
    }

    static String replaceUnderscore(String string) {
        if (string.length() > 3 && string.charAt(2) == '_') {
            char[] chars = string.toCharArray();
            chars[2] = 45;
            string = new String(chars);
        }
        return string;
    }

    private static final class LocaleKeyDeserializer
    extends KeyDeserializer {
        private LocaleKeyDeserializer() {
        }

        public Object deserializeKey(String string, DeserializationContext dc) throws IOException, JsonProcessingException {
            if (string.isEmpty()) {
                return Locale.ROOT;
            }
            return Locale.forLanguageTag(LocaleJacksonConfigurer.replaceUnderscore(string));
        }
    }

    private static final class LocaleKeySerializer
    extends JsonSerializer<Locale> {
        private LocaleKeySerializer() {
        }

        public Class<Locale> handledType() {
            return Locale.class;
        }

        public void serialize(Locale t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            jg.writeFieldName(t.toLanguageTag());
        }
    }

    private static final class LocaleDeserializer
    extends JsonDeserializer<Locale> {
        private LocaleDeserializer() {
        }

        public boolean isCachable() {
            return true;
        }

        public Class<?> handledType() {
            return Locale.class;
        }

        public Locale deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            String string = (String)jp.readValueAs(String.class);
            return string.isEmpty() ? Locale.ROOT : Locale.forLanguageTag(LocaleJacksonConfigurer.replaceUnderscore(string));
        }
    }

    private static final class LocaleSerializer
    extends JsonSerializer<Locale> {
        private LocaleSerializer() {
        }

        public Class<Locale> handledType() {
            return Locale.class;
        }

        public void serialize(Locale t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            jg.writeString(t.toLanguageTag());
        }
    }
}

