/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.mastfrog.jackson.JavaTimeConfigurer;
import com.mastfrog.jackson.TimeSerializationMode;
import com.mastfrog.jackson.WrapperJacksonConfigurer;
import com.mastfrog.jackson.configuration.DurationSerializationMode;
import com.mastfrog.jackson.configuration.JacksonConfigurer;
import com.mastfrog.util.preconditions.Checks;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public final class JacksonModule
extends AbstractModule {
    private final List<com.mastfrog.jackson.JacksonConfigurer> configurers;
    private final List<Class<? extends com.mastfrog.jackson.JacksonConfigurer>> declarativeConfigurers = new LinkedList<Class<? extends com.mastfrog.jackson.JacksonConfigurer>>();
    private final List<Class<? extends JacksonConfigurer>> declarativeConfigurers2 = new LinkedList<Class<? extends JacksonConfigurer>>();
    private final String bindingName;

    public JacksonModule(String bindingName, com.mastfrog.jackson.JacksonConfigurer ... configurers) {
        this.bindingName = bindingName;
        for (com.mastfrog.jackson.JacksonConfigurer c : configurers) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null configurer");
        }
        this.configurers = new LinkedList<com.mastfrog.jackson.JacksonConfigurer>(Arrays.asList(configurers));
    }

    public JacksonModule(com.mastfrog.jackson.JacksonConfigurer ... configurers) {
        for (com.mastfrog.jackson.JacksonConfigurer c : configurers) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null configurer");
        }
        this.configurers = new LinkedList<com.mastfrog.jackson.JacksonConfigurer>(Arrays.asList(configurers));
        this.bindingName = null;
    }

    public JacksonModule() {
        this((String)null);
    }

    public JacksonModule(String bindingName) {
        this(bindingName, true);
    }

    public JacksonModule(boolean loadFromMetaInfServices) {
        this(null, loadFromMetaInfServices);
    }

    public JacksonModule(String bindingName, boolean loadFromMetaInfServices) {
        this.bindingName = bindingName;
        this.configurers = !loadFromMetaInfServices ? new LinkedList<com.mastfrog.jackson.JacksonConfigurer>() : new LinkedList<com.mastfrog.jackson.JacksonConfigurer>(JacksonModule.metaInfServices());
    }

    public JacksonModule loadFromMetaInfServices() {
        HashSet classes = new HashSet();
        classes.addAll(this.declarativeConfigurers);
        classes.addAll(this.declarativeConfigurers2);
        for (com.mastfrog.jackson.JacksonConfigurer jacksonConfigurer : this.configurers) {
            if (jacksonConfigurer instanceof WrapperJacksonConfigurer) {
                classes.add(((WrapperJacksonConfigurer)jacksonConfigurer).origType());
            } else {
                classes.add(jacksonConfigurer.getClass());
            }
            if (!(jacksonConfigurer instanceof JavaTimeConfigurer)) continue;
            classes.add(com.mastfrog.jackson.configuration.impl.JavaTimeConfigurer.class);
        }
        for (JacksonConfigurer jacksonConfigurer : JacksonConfigurer.metaInfServices()) {
            if (classes.contains(jacksonConfigurer.getClass())) continue;
            this.configurers.add(WrapperJacksonConfigurer.wrap(jacksonConfigurer));
            classes.add(jacksonConfigurer.getClass());
        }
        for (com.mastfrog.jackson.JacksonConfigurer jacksonConfigurer : JacksonModule.metaInfServices()) {
            Class<Object> type = jacksonConfigurer instanceof WrapperJacksonConfigurer ? ((WrapperJacksonConfigurer)jacksonConfigurer).origType() : jacksonConfigurer.getClass();
            if (classes.contains(type)) continue;
            this.configurers.add(jacksonConfigurer);
        }
        return this;
    }

    public JacksonModule withJavaTimeSerializationMode(com.mastfrog.jackson.configuration.TimeSerializationMode timeMode, DurationSerializationMode durationMode) {
        if (timeMode == null) {
            throw new IllegalArgumentException("Null time mode");
        }
        if (durationMode == null) {
            throw new IllegalArgumentException("Null duration mode");
        }
        Iterator<com.mastfrog.jackson.JacksonConfigurer> iter = this.configurers.iterator();
        while (iter.hasNext()) {
            com.mastfrog.jackson.JacksonConfigurer cf = iter.next();
            if (!"JavaTimeConfigurer".equals(cf.name())) continue;
            iter.remove();
        }
        this.configurers.add(new JavaTimeConfigurer(TimeSerializationMode.forAlternate(timeMode), com.mastfrog.jackson.DurationSerializationMode.forAlternate(durationMode)));
        return this;
    }

    public JacksonModule withJavaTimeSerializationMode(TimeSerializationMode timeMode, com.mastfrog.jackson.DurationSerializationMode durationMode) {
        if (timeMode == null) {
            throw new IllegalArgumentException("Null time mode");
        }
        if (durationMode == null) {
            throw new IllegalArgumentException("Null duration mode");
        }
        Iterator<com.mastfrog.jackson.JacksonConfigurer> iter = this.configurers.iterator();
        while (iter.hasNext()) {
            com.mastfrog.jackson.JacksonConfigurer cf = iter.next();
            if (!"JavaTimeConfigurer".equals(cf.name())) continue;
            iter.remove();
        }
        this.configurers.add(new JavaTimeConfigurer(timeMode, durationMode));
        return this;
    }

    private static Collection<? extends com.mastfrog.jackson.JacksonConfigurer> metaInfServices() {
        ArrayList<com.mastfrog.jackson.JacksonConfigurer> all = new ArrayList<com.mastfrog.jackson.JacksonConfigurer>(10);
        for (com.mastfrog.jackson.JacksonConfigurer c : ServiceLoader.load(com.mastfrog.jackson.JacksonConfigurer.class)) {
            all.add(c);
        }
        for (com.mastfrog.jackson.JacksonConfigurer c : JacksonConfigurer.metaInfServices()) {
            all.add(WrapperJacksonConfigurer.wrap((JacksonConfigurer)c));
        }
        return all;
    }

    public JacksonModule withConfigurer(com.mastfrog.jackson.JacksonConfigurer configurer) {
        this.prune(((com.mastfrog.jackson.JacksonConfigurer)Checks.notNull((String)"configurer", (Object)configurer)).name());
        this.configurers.add(configurer);
        return this;
    }

    public JacksonModule withConfigurer(JacksonConfigurer configurer) {
        this.prune(((JacksonConfigurer)Checks.notNull((String)"configurer", (Object)configurer)).name());
        this.configurers.add(WrapperJacksonConfigurer.wrap(configurer));
        return this;
    }

    public JacksonModule withConfigurer(Class<? extends com.mastfrog.jackson.JacksonConfigurer> type) {
        if (!com.mastfrog.jackson.JacksonConfigurer.class.isAssignableFrom((Class)Checks.notNull((String)"type", type))) {
            throw new ClassCastException(type.getName() + " is not a subtype of " + com.mastfrog.jackson.JacksonConfigurer.class.getName());
        }
        this.prune(type.getSimpleName());
        this.declarativeConfigurers.add(type);
        return this;
    }

    private void prune(String sn) {
        Class<? extends com.mastfrog.jackson.JacksonConfigurer> c;
        Iterator<Object> it = this.declarativeConfigurers.iterator();
        while (it.hasNext()) {
            c = it.next();
            if (!sn.equals(c.getSimpleName())) continue;
            it.remove();
        }
        it = this.declarativeConfigurers2.iterator();
        while (it.hasNext()) {
            c = it.next();
            if (!sn.equals(c.getSimpleName())) continue;
            it.remove();
        }
        it = this.configurers.iterator();
        while (it.hasNext()) {
            com.mastfrog.jackson.JacksonConfigurer cf = (com.mastfrog.jackson.JacksonConfigurer)it.next();
            if (!sn.equals(cf.name())) continue;
            it.remove();
        }
    }

    public JacksonModule withConfigurer2(Class<? extends JacksonConfigurer> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!JacksonConfigurer.class.isAssignableFrom(type)) {
            throw new ClassCastException(type.getName() + " is not a subtype of " + JacksonConfigurer.class.getName());
        }
        this.prune(type.getSimpleName());
        this.declarativeConfigurers2.add(type);
        return this;
    }

    protected void configure() {
        WrapperProvider p;
        LinkedList<Provider<? extends com.mastfrog.jackson.JacksonConfigurer>> configurers = new LinkedList<Provider<? extends com.mastfrog.jackson.JacksonConfigurer>>();
        for (Class<? extends com.mastfrog.jackson.JacksonConfigurer> clazz : this.declarativeConfigurers) {
            p = this.binder().getProvider(clazz);
            configurers.add(p);
        }
        for (Class<? extends com.mastfrog.jackson.JacksonConfigurer> clazz : this.declarativeConfigurers2) {
            p = WrapperProvider.wrapperProvider(this.binder().getProvider(clazz));
            configurers.add(p);
        }
        JacksonProvider prov = new JacksonProvider(configurers);
        if (this.bindingName != null) {
            this.bind(ObjectMapper.class).annotatedWith((Annotation)Names.named((String)this.bindingName)).toProvider((Provider)prov);
            this.bind(JC.class).annotatedWith((Annotation)Names.named((String)this.bindingName)).toInstance((Object)prov);
        } else {
            this.bind(ObjectMapper.class).toProvider((Provider)prov);
            this.bind(JC.class).toInstance((Object)prov);
        }
    }

    private static class WrapperProvider<T extends JacksonConfigurer>
    implements Provider<com.mastfrog.jackson.JacksonConfigurer> {
        private final Provider<T> provider;

        WrapperProvider(Provider<T> type) {
            this.provider = type;
        }

        static <T extends JacksonConfigurer> WrapperProvider<T> wrapperProvider(Provider<T> provider) {
            return new WrapperProvider<T>(provider);
        }

        public com.mastfrog.jackson.JacksonConfigurer get() {
            return WrapperJacksonConfigurer.wrap((JacksonConfigurer)this.provider.get());
        }
    }

    @Singleton
    class JacksonProvider
    implements Provider<ObjectMapper>,
    JC {
        private ObjectMapper mapper = new ObjectMapper();
        private final AtomicBoolean configured = new AtomicBoolean();
        private final List<Provider<? extends com.mastfrog.jackson.JacksonConfigurer>> providers;

        JacksonProvider(List<Provider<? extends com.mastfrog.jackson.JacksonConfigurer>> providers) {
            this.providers = providers;
        }

        @Override
        public List<com.mastfrog.jackson.JacksonConfigurer> configurers() {
            ArrayList<com.mastfrog.jackson.JacksonConfigurer> result = new ArrayList<com.mastfrog.jackson.JacksonConfigurer>(JacksonModule.this.configurers);
            for (Provider<? extends com.mastfrog.jackson.JacksonConfigurer> provider : this.providers) {
                com.mastfrog.jackson.JacksonConfigurer p = (com.mastfrog.jackson.JacksonConfigurer)provider.get();
                result.add(p);
            }
            Collections.sort(result);
            return result;
        }

        @Override
        public ObjectMapper get() {
            if (this.configured.compareAndSet(false, true)) {
                for (com.mastfrog.jackson.JacksonConfigurer config : this.configurers()) {
                    this.mapper = config.configure(this.mapper);
                }
            }
            return this.mapper.copy();
        }
    }

    static interface JC {
        public List<com.mastfrog.jackson.JacksonConfigurer> configurers();

        public ObjectMapper get();
    }
}

