/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Optional;
import com.mastfrog.jackson.JacksonConfigurer;
import java.io.IOException;

public class OptionalSerializer
implements JacksonConfigurer {
    @Override
    public ObjectMapper configure(ObjectMapper mapper) {
        SimpleModule sm = new SimpleModule("optional1", new Version(1, 0, 0, null, "com.mastfrog", "com-google-common-base-optional"));
        sm.addSerializer((JsonSerializer)new OptionalSer());
        mapper.registerModule((Module)sm);
        return mapper;
    }

    public String toString() {
        return "GuavaOptionalSerializer";
    }

    private static final class OptionalSer
    extends JsonSerializer<Optional> {
        private OptionalSer() {
        }

        public Class<Optional> handledType() {
            return Optional.class;
        }

        public void serialize(Optional t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            if (t.isPresent()) {
                sp.defaultSerializeValue(t.get(), jg);
            } else {
                jg.writeNull();
            }
        }
    }
}

