/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.url.URL;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.thread.Receiver;
import com.mastfrog.util.time.TimeUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CookieStore
implements Iterable<Cookie> {
    final Set<DateCookie> cookies = new HashSet<DateCookie>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final boolean checkDomain;
    private final boolean checkPath;
    private Receiver<Throwable> errorHandler;

    public CookieStore(boolean checkDomain, boolean checkPath) {
        this.checkDomain = checkDomain;
        this.checkPath = checkPath;
    }

    public CookieStore() {
        this(true, true);
    }

    CookieStore(Set<DateCookie> cookies, boolean checkDomain, boolean checkPath) {
        Checks.notNull((String)"cookies", cookies);
        this.cookies.addAll(cookies);
        this.checkDomain = checkDomain;
        this.checkPath = checkPath;
    }

    public CookieStore checkDomain() {
        return new CookieStore(this.cookies, true, this.checkPath);
    }

    public CookieStore dontCheckDomain() {
        return new CookieStore(this.cookies, false, this.checkPath);
    }

    public int size() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            int n = this.cookies.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean isEmpty() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            boolean bl = this.cookies.isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public CookieStore checkPath() {
        return new CookieStore(this.cookies, this.checkDomain, true);
    }

    public CookieStore dontCheckPath() {
        return new CookieStore(this.cookies, this.checkDomain, false);
    }

    public CookieStore errorHandler(Receiver<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decorate(HttpRequest req) {
        URL url;
        if (!req.uri().contains("://")) {
            String host = req.headers().get(Headers.HOST.name());
            url = URL.builder().setPath(req.uri()).setHost(host).create();
        } else {
            url = URL.parse((String)req.uri());
        }
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            ArrayList<Cookie> toSend = new ArrayList<Cookie>();
            for (Cookie cookie : this.cookies) {
                String pth;
                if (this.checkDomain && cookie.domain() != null && !cookie.domain().equals(url.getHost().toString())) continue;
                if (this.checkPath && (pth = cookie.path()) != null) {
                    String compare = url.getPath().toStringWithLeadingSlash();
                    if (!"/".equals(pth) && !"".equals(pth) && !compare.equals(pth) && !compare.startsWith(pth)) continue;
                }
                toSend.add(cookie);
            }
            if (!toSend.isEmpty()) {
                for (Cookie cookie : toSend) {
                    CharSequence headerValue = Headers.COOKIE_B.toCharSequence((Object)new Cookie[]{cookie});
                    req.headers().add(Headers.COOKIE_B.name(), (Object)headerValue);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String name) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            for (Cookie cookie : this.cookies) {
                if (!name.equals(cookie.name())) continue;
                String string = cookie.value();
                return string;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Cookie cookie) {
        String name = cookie.name();
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            Iterator<DateCookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                DateCookie ck = it.next();
                if (name.equals(ck.name())) {
                    it.remove();
                    continue;
                }
                if (!ck.isExpired()) continue;
                it.remove();
            }
            if (cookie.maxAge() > 0L) {
                this.cookies.add(new DateCookie(cookie));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            Iterator<DateCookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                DateCookie ck = it.next();
                if (!name.equals(ck.name())) continue;
                it.remove();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extract(HttpHeaders headers) {
        List hdrs = headers.getAll(Headers.SET_COOKIE_B.name());
        if (!hdrs.isEmpty()) {
            Lock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                for (String header : hdrs) {
                    try {
                        Cookie cookie = (Cookie)Headers.SET_COOKIE_B.toValue((CharSequence)header);
                        this.add(cookie);
                    }
                    catch (Exception e) {
                        if (this.errorHandler != null) {
                            this.errorHandler.receive((Object)e);
                            continue;
                        }
                        Exceptions.chuck((Throwable)e);
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock readLock = this.lock.readLock();
        ArrayList<DateCookie> cks = new ArrayList<DateCookie>();
        readLock.lock();
        try {
            if (this.cookies.isEmpty()) {
                String string = "[no cookies]";
                return string;
            }
            cks.addAll(this.cookies);
        }
        finally {
            readLock.unlock();
        }
        Collections.sort(cks);
        return Headers.COOKIE_B.toCharSequence((Object)cks.toArray(new Cookie[cks.size()])).toString();
    }

    @Override
    public Iterator<Cookie> iterator() {
        Lock readLock = this.lock.readLock();
        ArrayList<DateCookie> cks = new ArrayList<DateCookie>();
        readLock.lock();
        try {
            cks.addAll(this.cookies);
        }
        finally {
            readLock.unlock();
        }
        Collections.sort(cks);
        return cks.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream out) throws IOException {
        ObjectMapper om = new ObjectMapper();
        Lock readLock = this.lock.readLock();
        ArrayList<DateCookie> cks = new ArrayList<DateCookie>();
        readLock.lock();
        try {
            cks.addAll(this.cookies);
        }
        finally {
            readLock.unlock();
        }
        LinkedList list = new LinkedList();
        for (DateCookie ck : cks) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("domain", ck.domain());
            m.put("maxAge", ck.maxAge());
            m.put("timestamp", TimeUtil.toUnixTimestamp((ZonedDateTime)ck.getTimestamp()));
            m.put("path", ck.path());
            m.put("name", ck.name());
            m.put("value", ck.value());
            m.put("httpOnly", ck.isHttpOnly());
            m.put("secure", ck.isSecure());
            list.add(m);
        }
        om.writeValue(out, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream in) throws IOException {
        ObjectMapper om = new ObjectMapper();
        List l = (List)om.readValue(in, List.class);
        ArrayList<DateCookie> cks = new ArrayList<DateCookie>();
        for (Map m : l) {
            String domain = (String)m.get("domain");
            Number maxAge = (Number)m.get("maxAge");
            Number timestamp = (Number)m.get("timestamp");
            String path = (String)m.get("path");
            String name = (String)m.get("name");
            String value = (String)m.get("value");
            Boolean httpOnly = (Boolean)m.get("httpOnly");
            Boolean secure = (Boolean)m.get("secure");
            String comment = (String)m.get("comment");
            String commentUrl = (String)m.get("commentUrl");
            List ports = (List)m.get("ports");
            ZonedDateTime ts = timestamp == null ? ZonedDateTime.now() : TimeUtil.fromUnixTimestamp((long)timestamp.longValue());
            DateCookie cookie = new DateCookie((Cookie)new DefaultCookie(name, value), ts);
            if (cookie.isExpired()) continue;
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if (maxAge != null) {
                cookie.setMaxAge(maxAge.longValue());
            }
            if (path != null) {
                cookie.setPath(path);
            }
            if (httpOnly != null) {
                cookie.setHttpOnly(httpOnly);
            }
            if (secure != null) {
                cookie.setSecure(secure);
            }
            cks.add(cookie);
        }
        if (!cks.isEmpty()) {
            Lock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                this.cookies.addAll(cks);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    public int hashCode() {
        return this.cookies.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CookieStore) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    static final class DateCookie
    implements Cookie {
        private final Cookie delegate;
        private final ZonedDateTime timestamp;

        DateCookie(Cookie delegate) {
            this.delegate = delegate;
            this.timestamp = ZonedDateTime.now();
        }

        DateCookie(Cookie delegate, ZonedDateTime timestamp) {
            this.delegate = delegate;
            this.timestamp = timestamp;
        }

        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        public boolean isExpired() {
            Duration dur;
            if (this.maxAge() == Long.MAX_VALUE) {
                return false;
            }
            try {
                dur = Duration.ofSeconds(this.maxAge());
            }
            catch (ArithmeticException ex) {
                dur = Duration.ofDays(7300L);
            }
            try {
                return this.timestamp.plus(dur).isBefore(ZonedDateTime.now());
            }
            catch (DateTimeException e) {
                return false;
            }
        }

        public String name() {
            return this.delegate.name();
        }

        public String value() {
            return this.delegate.value();
        }

        public void setValue(String string) {
            this.delegate.setValue(string);
        }

        public boolean wrap() {
            return this.delegate.wrap();
        }

        public void setWrap(boolean bln) {
            this.delegate.setWrap(bln);
        }

        public String domain() {
            return this.delegate.domain();
        }

        public void setDomain(String string) {
            this.delegate.setDomain(string);
        }

        public String path() {
            return this.delegate.path();
        }

        public void setPath(String string) {
            this.delegate.setPath(string);
        }

        public long maxAge() {
            return this.delegate.maxAge();
        }

        public void setMaxAge(long l) {
            this.delegate.setMaxAge(l);
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public void setSecure(boolean bln) {
            this.delegate.setSecure(bln);
        }

        public boolean isHttpOnly() {
            return this.delegate.isHttpOnly();
        }

        public void setHttpOnly(boolean bln) {
            this.delegate.setHttpOnly(bln);
        }

        public int compareTo(Cookie o) {
            return this.delegate.compareTo((Object)o);
        }
    }
}

