/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.marshallers.netty.NettyContentMarshallers;
import com.mastfrog.netty.http.client.ActivityMonitor;
import com.mastfrog.netty.http.client.ChunkedContent;
import com.mastfrog.netty.http.client.CookieStore;
import com.mastfrog.netty.http.client.HandlerEntry;
import com.mastfrog.netty.http.client.HttpClientBuilder;
import com.mastfrog.netty.http.client.HttpRequestBuilder;
import com.mastfrog.netty.http.client.Initializer;
import com.mastfrog.netty.http.client.MessageHandlerImpl;
import com.mastfrog.netty.http.client.NioChannelFactory;
import com.mastfrog.netty.http.client.RequestBuilder;
import com.mastfrog.netty.http.client.RequestInfo;
import com.mastfrog.netty.http.client.RequestInterceptor;
import com.mastfrog.netty.http.client.ResponseFuture;
import com.mastfrog.netty.http.client.ResponseHandler;
import com.mastfrog.netty.http.client.SslBootstrapCache;
import com.mastfrog.netty.http.client.State;
import com.mastfrog.netty.http.client.StateType;
import com.mastfrog.url.HostAndPort;
import com.mastfrog.url.URL;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.thread.Receiver;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class HttpClient {
    private final NioEventLoopGroup group;
    final boolean compress;
    private final int maxInitialLineLength;
    private final int maxChunkSize;
    private final int maxHeadersSize;
    private final boolean followRedirects;
    private final CharSequence userAgent;
    private final List<RequestInterceptor> interceptors;
    private final Iterable<HttpClientBuilder.ChannelOptionSetting<?>> settings;
    private final boolean send100continue;
    private final CookieStore cookies;
    private final Duration timeout;
    private final Timer timer = new Timer("HttpClient timeout for HttpClient@" + System.identityHashCode(this));
    private final SslBootstrapCache sslBootstraps;
    private final MessageHandlerImpl handler;
    private final AddressResolverGroup<?> resolver;
    private final NioChannelFactory channelFactory = new NioChannelFactory(Boolean.getBoolean("httpclient.debug"));
    private final NettyContentMarshallers marshallers;
    private final ObjectMapper mapper;
    private Bootstrap bootstrap;
    static final AttributeKey<RequestInfo> KEY = AttributeKey.valueOf((String)"info");
    private final Set<ActivityMonitor> monitors = Sets.newConcurrentHashSet();
    private static final Set<HttpResponseStatus> REDIRECTS = new HashSet<HttpResponseStatus>(Arrays.asList(HttpResponseStatus.FOUND, HttpResponseStatus.SEE_OTHER, HttpResponseStatus.TEMPORARY_REDIRECT, HttpResponseStatus.PERMANENT_REDIRECT));

    public HttpClient() {
        this(false, 131072, 12, 8192, 16383, true, null, Collections.emptyList(), Collections.emptyList(), true, null, null, null, null, null, -1, null, null);
    }

    public HttpClient(boolean compress, int maxChunkSize, int threads, int maxInitialLineLength, int maxHeadersSize, boolean followRedirects, CharSequence userAgent, List<RequestInterceptor> interceptors, Iterable<HttpClientBuilder.ChannelOptionSetting<?>> settings, boolean send100continue, CookieStore cookies, Duration timeout, SslContext sslContext, AddressResolverGroup<?> resolver, NioEventLoopGroup threadPool, int maxRedirects, NettyContentMarshallers marshallers, ObjectMapper mapper) {
        this.mapper = mapper == null ? new ObjectMapper() : mapper;
        this.marshallers = marshallers == null ? NettyContentMarshallers.getDefault((ObjectMapper)this.mapper) : marshallers;
        this.group = threadPool == null ? new NioEventLoopGroup(threads, (ThreadFactory)new TF()) : threadPool;
        this.compress = compress;
        this.resolver = resolver;
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxChunkSize = maxChunkSize;
        this.maxHeadersSize = maxHeadersSize;
        this.followRedirects = followRedirects;
        this.userAgent = userAgent;
        this.interceptors = interceptors == null ? Collections.emptyList() : new ImmutableList.Builder().addAll(interceptors).build();
        this.settings = settings == null ? Collections.emptySet() : settings;
        this.send100continue = send100continue;
        this.cookies = cookies;
        this.timeout = timeout;
        this.handler = new MessageHandlerImpl(followRedirects, this, maxRedirects);
        this.sslBootstraps = new SslBootstrapCache((EventLoopGroup)this.group, this.timeout, sslContext, this.handler, this.maxChunkSize, this.maxInitialLineLength, this.maxHeadersSize, this.compress, this.settings, resolver, this.channelFactory);
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    public HttpRequestBuilder request(Method method) {
        Checks.notNull((String)"method", (Object)method);
        return new RB(method);
    }

    public HttpRequestBuilder get() {
        return new RB(Method.GET);
    }

    public HttpRequestBuilder head() {
        return new RB(Method.HEAD);
    }

    public HttpRequestBuilder put() {
        return new RB(Method.PUT);
    }

    public HttpRequestBuilder post() {
        return new RB(Method.POST);
    }

    public HttpRequestBuilder delete() {
        return new RB(Method.DELETE);
    }

    public HttpRequestBuilder options() {
        return new RB(Method.OPTIONS);
    }

    private synchronized Bootstrap start(HostAndPort hostAndPort) {
        if (this.bootstrap == null) {
            this.bootstrap = new Bootstrap();
            if (this.resolver != null) {
                this.bootstrap.resolver(this.resolver);
            }
            this.bootstrap.group((EventLoopGroup)this.group);
            this.bootstrap.handler((ChannelHandler)new Initializer(hostAndPort, this.handler, null, false, this.maxChunkSize, this.maxInitialLineLength, this.maxHeadersSize, this.compress));
            this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)false);
            if (this.timeout != null) {
                this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.timeout.toMillis()));
            }
            for (HttpClientBuilder.ChannelOptionSetting<?> setting : this.settings) {
                setting.apply(this.bootstrap);
            }
            this.bootstrap.channelFactory((ChannelFactory)this.channelFactory);
        }
        return this.bootstrap;
    }

    private synchronized Bootstrap startSsl(HostAndPort hostAndPort) {
        return this.sslBootstraps.sslBootstrap(hostAndPort);
    }

    public void shutdown() {
        if (this.group != null) {
            this.group.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
            if (!this.group.isTerminated()) {
                this.group.shutdownNow();
            }
        }
        this.timer.cancel();
    }

    void copyHeaders(HttpRequest from, HttpRequest to, HeaderValueType<?> ... exclude) {
        Iterator it = from.headers().iteratorCharSequence();
        block0: while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            CharSequence header = (CharSequence)e.getKey();
            for (HeaderValueType<?> ex : exclude) {
                if (ex.is(header)) continue block0;
            }
            to.headers().add(header, e.getValue());
        }
    }

    void redirect(Method method, URL url, RequestInfo info) {
        DefaultHttpRequest nue;
        if (method.toString().equals(info.req.method().toString())) {
            if (info.req instanceof DefaultFullHttpRequest) {
                FullHttpRequest rq;
                DefaultFullHttpRequest dfrq = (DefaultFullHttpRequest)info.req;
                try {
                    rq = dfrq.copy();
                }
                catch (IllegalReferenceCountException e) {
                    rq = dfrq;
                }
                rq.setUri(url.getPathAndQuery());
                nue = rq;
            } else {
                nue = new DefaultHttpRequest(info.req.protocolVersion(), info.req.method(), url.getPathAndQuery());
            }
        } else {
            nue = new DefaultHttpRequest(info.req.protocolVersion(), HttpMethod.valueOf((String)method.name()), url.getPathAndQuery());
        }
        this.copyHeaders(info.req, (HttpRequest)nue, Headers.HOST);
        nue.headers().set(Headers.HOST.name(), (Object)url.getHost().toString());
        this.submit(url, (HttpRequest)nue, info.cancelled, info.handle, info.r, info, info.remaining(), info.dontAggregate, info.chunkedBody);
    }

    public void addActivityMonitor(ActivityMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void removeActivityMonitor(ActivityMonitor monitor) {
        this.monitors.remove(monitor);
    }

    private void submit(final URL url, HttpRequest rq, final AtomicBoolean cancelled, final ResponseFuture handle, final ResponseHandler<?> r, RequestInfo info, Duration timeout, boolean noAggregate, final ChunkedContent chunked) {
        if (info != null && info.isExpired()) {
            handle.event(new State.Timeout(info.age()));
            cancelled.set(true);
        }
        if (cancelled.get()) {
            handle.event(new State.Cancelled());
            return;
        }
        AtomicReference<Channel> theChannel = new AtomicReference<Channel>();
        if (!url.isValid() && url.getProblems() != null) {
            url.getProblems().throwIfFatalPresent("Invalid URL");
        }
        for (RequestInterceptor i : this.interceptors) {
            rq = i.intercept(rq);
        }
        final HttpRequest req = rq;
        try {
            boolean newRequest;
            Bootstrap bootstrap = url.getProtocol().isSecure() ? this.startSsl(url.getHostAndPort()) : this.start(url.getHostAndPort());
            TimeoutTimerTask timerTask = null;
            boolean bl = newRequest = info == null;
            if (info == null) {
                info = new RequestInfo(url, req, cancelled, handle, r, timeout, timerTask, noAggregate, chunked);
                if (timeout != null) {
                    timerTask = new TimeoutTimerTask(cancelled, handle, r, info);
                    this.timer.schedule((TimerTask)timerTask, timeout.toMillis());
                }
                info.timer = timerTask;
            }
            if (info.isExpired()) {
                handle.event(new State.Timeout(info.age()));
                return;
            }
            handle.event(new State.Connecting());
            req.setUri(req.uri().replaceAll("%5f", "_"));
            ChannelFuture fut = bootstrap.connect(url.getHost().toString(), url.getPort().intValue());
            theChannel.set(fut.channel());
            if (timerTask != null) {
                fut.channel().closeFuture().addListener((GenericFutureListener)timerTask);
            }
            fut.channel().attr(KEY).set((Object)info);
            handle.setFuture(fut);
            if (!this.monitors.isEmpty()) {
                for (ActivityMonitor m : this.monitors) {
                    m.onStartRequest(url);
                }
                fut.channel().closeFuture().addListener((GenericFutureListener)new AdapterCloseNotifier(url));
            }
            if (newRequest && r != null) {
                handle.on(State.Error.class, new Receiver<Throwable>(){

                    public void receive(Throwable object) {
                        r.onError(object);
                    }
                });
                handle.on(StateType.Cancelled, new Receiver<Void>(){

                    public void receive(Void object) {
                        r.onError(new CancellationException("Cancelled"));
                    }
                });
            }
            fut.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        Throwable cause = future.cause();
                        if (cause == null) {
                            cause = new ConnectException("Unknown problem connecting to " + url);
                        }
                        handle.event(new State.Error(cause));
                        cancelled.set(true);
                    }
                    if (cancelled.get()) {
                        future.cancel(true);
                        if (future.channel().isOpen()) {
                            future.channel().close();
                        }
                        for (ActivityMonitor m : HttpClient.this.monitors) {
                            m.onEndRequest(url);
                        }
                        return;
                    }
                    handle.event(new State.Connected(future.channel()));
                    handle.event(new State.SendRequest(req));
                    future = future.channel().writeAndFlush((Object)req);
                    future.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(final ChannelFuture future) throws Exception {
                            if (cancelled.get()) {
                                future.cancel(true);
                                future.channel().close();
                            }
                            if (chunked != null) {
                                handle.on(State.HeadersReceived.class, new Receiver<HttpResponse>(){
                                    boolean first = true;

                                    public void receive(HttpResponse object) {
                                        if (this.first && (HttpResponseStatus.CONTINUE.equals((Object)object.status()) || !HttpClient.this.send100continue)) {
                                            this.first = false;
                                            ChannelFutureListener flusher = new ChannelFutureListener(){
                                                int count = 0;

                                                public void operationComplete(ChannelFuture f) throws Exception {
                                                    Object chunk;
                                                    if (cancelled.get()) {
                                                        if (f != null) {
                                                            f.cancel(true);
                                                            f.channel().close();
                                                            return;
                                                        }
                                                        future.cancel(true);
                                                        future.channel().close();
                                                    }
                                                    if (f != null && f.cause() != null) {
                                                        handle.event(new State.Error(f.cause()));
                                                        f.channel().close();
                                                    }
                                                    Channel ch = f == null ? future.channel() : f.channel();
                                                    if ((chunk = chunked.nextChunk(this.count++)) != null) {
                                                        if (chunk instanceof ByteBuf) {
                                                            chunk = new DefaultHttpContent((ByteBuf)chunk);
                                                        }
                                                        ch.writeAndFlush(chunk).addListener((GenericFutureListener)this);
                                                    } else {
                                                        ch.writeAndFlush((Object)new DefaultLastHttpContent());
                                                        handle.event(new State.AwaitingResponse());
                                                    }
                                                }
                                            };
                                            try {
                                                flusher.operationComplete(null);
                                            }
                                            catch (Exception ex) {
                                                Exceptions.chuck((Throwable)ex);
                                            }
                                        } else if (this.first && HttpClient.isRedirect(object.status())) {
                                            handle.event(new State.AwaitingResponse());
                                        }
                                    }
                                });
                            }
                            handle.event(new State.AwaitingResponse());
                        }
                    });
                }
            });
        }
        catch (Exception ex) {
            Channel ch = (Channel)theChannel.get();
            cancelled.set(true);
            if (ch != null && ch.isRegistered() && ch.isOpen()) {
                ch.close();
            }
            Exceptions.chuck((Throwable)ex);
        }
    }

    private static boolean isRedirect(HttpResponseStatus status) {
        return REDIRECTS.contains(status);
    }

    private ByteBufAllocator alloc() {
        for (HttpClientBuilder.ChannelOptionSetting<?> setting : this.settings) {
            if (!setting.option().equals((Object)ChannelOption.ALLOCATOR)) continue;
            return (ByteBufAllocator)setting.value();
        }
        return PooledByteBufAllocator.DEFAULT;
    }

    private static class TF
    implements ThreadFactory {
        private int threadsCreated = 0;

        private TF() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "HttpClient event loop " + ++this.threadsCreated);
            t.setDaemon(true);
            return t;
        }
    }

    private final class RB
    extends RequestBuilder {
        RB(Method method) {
            super(method, HttpClient.this.alloc());
            this.send100Continue = HttpClient.this.send100continue;
        }

        @Override
        NettyContentMarshallers marshallers() {
            return HttpClient.this.marshallers;
        }

        @Override
        public ResponseFuture execute(ResponseHandler<?> r) {
            if (r != null && r.marshallers == null) {
                r.marshallers = HttpClient.this.marshallers;
            }
            URL u = this.getURL();
            HttpRequest req = this.build();
            if (req instanceof ReferenceCounted) {
                ((ReferenceCounted)req).touch((Object)"execute-client-request");
            }
            if (HttpClient.this.userAgent != null) {
                req.headers().add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpClient.this.userAgent);
            }
            if (HttpClient.this.compress) {
                req.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP_DEFLATE);
            }
            AtomicBoolean cancelled = new AtomicBoolean();
            ResponseFuture handle = new ResponseFuture(cancelled);
            handle.handlers.addAll(this.handlers);
            handle.any.addAll(this.any);
            CookieStore theStore = this.store;
            if (theStore == null) {
                theStore = HttpClient.this.cookies;
            }
            if (theStore != null) {
                HandlerEntry<HttpResponse> entry = this.createHandler(State.HeadersReceived.class, new StoreHandler(theStore));
                handle.handlers.add(entry);
            }
            HttpClient.this.submit(u, req, cancelled, handle, r, null, this.timeout, this.noAggregate, this.chunkedContent());
            return handle;
        }

        private <T> HandlerEntry<T> createHandler(Class<? extends State<T>> event, Receiver<T> r) {
            HandlerEntry<T> result = new HandlerEntry<T>(event);
            result.add(r);
            return result;
        }

        @Override
        public ResponseFuture execute() {
            return this.execute(null);
        }

        @Override
        public <T> HttpRequestBuilder on(StateType event, Receiver<T> r) {
            super.on(event.type(), event.wrapperReceiver(r));
            return this;
        }
    }

    static final class TimeoutTimerTask
    extends TimerTask
    implements ChannelFutureListener {
        private final AtomicBoolean cancelled;
        private final ResponseFuture handle;
        private final ResponseHandler<?> r;
        private final RequestInfo in;

        TimeoutTimerTask(AtomicBoolean cancelled, ResponseFuture handle, ResponseHandler<?> r, RequestInfo in) {
            Checks.notNull((String)"in", (Object)in);
            Checks.notNull((String)"cancelled", (Object)cancelled);
            this.cancelled = cancelled;
            this.handle = handle;
            this.r = r;
            this.in = in;
        }

        @Override
        public void run() {
            if (!this.cancelled.get()) {
                if (this.r != null) {
                    this.r.onError(new NoStackTimeoutException(this.in.timeout.toString()));
                }
                if (this.handle != null) {
                    this.handle.onTimeout(this.in.age());
                }
            }
            super.cancel();
        }

        public void operationComplete(ChannelFuture f) throws Exception {
            this.cancelled.set(true);
            super.cancel();
        }
    }

    private class AdapterCloseNotifier
    implements ChannelFutureListener {
        private final URL url;

        AdapterCloseNotifier(URL url) {
            this.url = url;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            for (ActivityMonitor m : HttpClient.this.monitors) {
                m.onEndRequest(this.url);
            }
        }
    }

    private static final class StoreHandler
    extends Receiver<HttpResponse> {
        private final CookieStore store;

        StoreHandler(CookieStore store) {
            this.store = store;
        }

        public void receive(HttpResponse headerContainer) {
            this.store.extract(headerContainer.headers());
        }
    }

    private static class NoStackTimeoutException
    extends TimeoutException {
        NoStackTimeoutException(String msg) {
            super(msg);
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return new StackTraceElement[0];
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

