/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mastfrog.marshallers.ContentMarshallers;
import com.mastfrog.marshallers.Marshaller;
import com.mastfrog.marshallers.netty.NettyContentMarshallers;
import com.mastfrog.netty.http.client.CookieStore;
import com.mastfrog.netty.http.client.HttpClient;
import com.mastfrog.netty.http.client.LocalhostOnlyAddressResolverGroup;
import com.mastfrog.netty.http.client.RequestInterceptor;
import com.mastfrog.util.preconditions.Checks;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class HttpClientBuilder {
    private static final int DEFAULT_THREAD_COUNT = 4;
    private int threadCount = -1;
    private int maxChunkSize = 65536;
    private boolean compression = true;
    private int maxInitialLineLength = 2048;
    private int maxHeadersSize = 16384;
    private boolean followRedirects = true;
    private CharSequence userAgent;
    private final List<RequestInterceptor> interceptors = new LinkedList<RequestInterceptor>();
    private boolean send100continue = true;
    private CookieStore cookies;
    private Duration timeout;
    private SslContext sslContext;
    private AddressResolverGroup<? extends SocketAddress> resolver;
    private NioEventLoopGroup group;
    private int maxRedirects = -1;
    private ObjectMapper mapper = new ObjectMapper();
    private final Set<MarshallerEntry<?>> marshallers = new HashSet();
    private boolean supportWebsockets;
    private final List<ChannelOptionSetting<?>> settings = new LinkedList();

    public HttpClientBuilder withWebsocketSupport() {
        this.supportWebsockets = true;
        return this;
    }

    public HttpClientBuilder setObjectMapper(ObjectMapper mapper) {
        Checks.notNull((String)"mapper", (Object)mapper);
        this.mapper = mapper;
        return this;
    }

    public <T> HttpClientBuilder addMarshaller(Class<T> forType, Marshaller<T, ByteBuf> marshaller) {
        Checks.notNull((String)"marshaller", marshaller);
        this.marshallers.add(new MarshallerEntry<T>(forType, marshaller));
        return this;
    }

    public HttpClientBuilder setSslContext(SslContext ctx) {
        this.sslContext = ctx;
        return this;
    }

    public HttpClientBuilder setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpClientBuilder followRedirects() {
        this.followRedirects = true;
        return this;
    }

    public HttpClientBuilder send100Continue() {
        this.send100continue = true;
        return this;
    }

    public HttpClientBuilder dontSend100Continue() {
        this.send100continue = false;
        return this;
    }

    public HttpClientBuilder dontFollowRedirects() {
        this.followRedirects = false;
        return this;
    }

    public HttpClientBuilder threadCount(int count) {
        Checks.nonNegative((String)"threadCount", (int)count);
        Checks.nonZero((String)"threadCount", (int)count);
        if (this.group != null) {
            throw new IllegalStateException("Cannot set threadCount if you are providing the NioEventLoopGroup");
        }
        this.threadCount = count;
        return this;
    }

    public HttpClientBuilder maxChunkSize(int bytes) {
        Checks.nonNegative((String)"bytes", (int)bytes);
        Checks.nonZero((String)"bytes", (int)bytes);
        this.maxChunkSize = bytes;
        return this;
    }

    public HttpClientBuilder maxInitialLineLength(int max) {
        Checks.nonZero((String)"max", (int)max);
        Checks.nonNegative((String)"max", (int)max);
        this.maxInitialLineLength = max;
        return this;
    }

    public HttpClientBuilder maxHeadersSize(int max) {
        Checks.nonZero((String)"max", (int)max);
        Checks.nonNegative((String)"max", (int)max);
        this.maxHeadersSize = max;
        return this;
    }

    public HttpClientBuilder useCompression() {
        this.compression = true;
        return this;
    }

    public HttpClientBuilder noCompression() {
        this.compression = false;
        return this;
    }

    public HttpClientBuilder resolveAllHostsToLocalhost() {
        return this.resolver(new LocalhostOnlyAddressResolverGroup());
    }

    public HttpClientBuilder resolver(AddressResolverGroup<? extends SocketAddress> resolver) {
        this.resolver = resolver;
        return this;
    }

    public <T extends SocketAddress> HttpClientBuilder resolver(AddressResolver<T> resolver) {
        return this.resolver(new OneResolverGroup<T>(resolver));
    }

    public HttpClientBuilder setMaxRedirects(int maxRedirects) {
        Checks.nonNegative((String)"maxRedirects", (int)maxRedirects);
        this.maxRedirects = maxRedirects;
        return this;
    }

    public HttpClientBuilder setEventLoopGroup(NioEventLoopGroup group) {
        Checks.notNull((String)"group", (Object)group);
        if (this.threadCount != -1) {
            throw new IllegalStateException("Thread count already set. If you want to provide your own NioEventLoopGroup, don't also set that - these options are mutually exclusive.");
        }
        this.group = group;
        return this;
    }

    public HttpClient build() {
        NettyContentMarshallers marshallers = NettyContentMarshallers.getDefault((ObjectMapper)this.mapper);
        for (MarshallerEntry<?> m : this.marshallers) {
            m.apply(marshallers);
        }
        return new HttpClient(this.compression, this.maxChunkSize, this.threadCount == -1 ? 4 : this.threadCount, this.maxInitialLineLength, this.maxHeadersSize, this.followRedirects, this.userAgent, this.interceptors, Collections.unmodifiableList(new ArrayList(this.settings)), this.send100continue, this.cookies, this.timeout, this.sslContext, this.resolver, this.group, this.maxRedirects, marshallers, this.mapper);
    }

    public HttpClientBuilder setUserAgent(String userAgent) {
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(userAgent)) {
            throw new IllegalArgumentException("User agent string contains non-ascii characters which cannot be encoded in HTTP headers");
        }
        this.userAgent = AsciiString.of((CharSequence)userAgent);
        return this;
    }

    public HttpClientBuilder addRequestInterceptor(RequestInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public <T> HttpClientBuilder setChannelOption(ChannelOption<T> option, T value) {
        Iterator<ChannelOptionSetting<?>> it = this.settings.iterator();
        while (it.hasNext()) {
            ChannelOptionSetting<?> setting = it.next();
            if (!setting.equals(option)) continue;
            it.remove();
        }
        this.settings.add(new ChannelOptionSetting<T>(option, value));
        return this;
    }

    public HttpClientBuilder setCookieStore(CookieStore store) {
        this.cookies = store;
        return this;
    }

    private static final class MarshallerEntry<T> {
        private final Class<T> type;
        private final Marshaller<T, ByteBuf> marshaller;

        MarshallerEntry(Class<T> type, Marshaller<T, ByteBuf> marshaller) {
            this.type = type;
            this.marshaller = marshaller;
        }

        <R extends ContentMarshallers<ByteBuf, R>> void apply(ContentMarshallers<ByteBuf, R> marshallers) {
            marshallers.add(this.type, this.marshaller);
        }

        public boolean equals(Object o) {
            return o == null ? false : (o == this ? true : o instanceof MarshallerEntry && ((MarshallerEntry)o).type == this.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }

    private static final class OneResolverGroup<T extends SocketAddress>
    extends AddressResolverGroup<T> {
        private final AddressResolver<T> singleResolver;

        OneResolverGroup(AddressResolver<T> singleResolver) {
            this.singleResolver = singleResolver;
        }

        protected AddressResolver<T> newResolver(EventExecutor ee) throws Exception {
            return this.singleResolver;
        }
    }

    protected static final class ChannelOptionSetting<T> {
        private final ChannelOption<T> option;
        private final T value;

        ChannelOptionSetting(ChannelOption<T> option, T value) {
            this.option = option;
            this.value = value;
        }

        public ChannelOption<T> option() {
            return this.option;
        }

        public T value() {
            return this.value;
        }

        void apply(Bootstrap bootstrap) {
            bootstrap.option(this.option, this.value);
        }
    }
}

