/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.mime.MimeType;
import com.mastfrog.netty.http.client.CookieStore;
import com.mastfrog.netty.http.client.ResponseFuture;
import com.mastfrog.netty.http.client.ResponseHandler;
import com.mastfrog.netty.http.client.State;
import com.mastfrog.netty.http.client.StateType;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.URL;
import com.mastfrog.util.thread.Receiver;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;

public interface HttpRequestBuilder {
    public <T> HttpRequestBuilder addHeader(HeaderValueType<T> var1, T var2);

    public HttpRequestBuilder addPathElement(String var1);

    public HttpRequestBuilder addQueryPair(String var1, String var2);

    default public HttpRequestBuilder addQueryPairs(Map<String, Object> pairs, Function<Object, String> toString) {
        for (Map.Entry<String, Object> e : pairs.entrySet()) {
            if (e.getValue() == null) continue;
            this.addQueryPair(e.getKey(), toString.apply(e.getValue()));
        }
        return this;
    }

    default public HttpRequestBuilder addQueryPairs(Map<String, String> pairs) {
        for (Map.Entry<String, String> e : pairs.entrySet()) {
            if (e.getValue() == null) continue;
            this.addQueryPair(e.getKey(), e.getValue());
        }
        return this;
    }

    public HttpRequestBuilder setAnchor(String var1);

    public HttpRequestBuilder setHost(String var1);

    public HttpRequestBuilder setPath(String var1);

    public HttpRequestBuilder setPort(int var1);

    public HttpRequestBuilder setProtocol(Protocol var1);

    public HttpRequestBuilder setURL(URL var1);

    public HttpRequestBuilder setURL(String var1);

    public HttpRequestBuilder setUserName(String var1);

    public HttpRequestBuilder setPassword(String var1);

    public HttpRequestBuilder basicAuthentication(String var1, String var2);

    public ResponseFuture execute(ResponseHandler<?> var1);

    public ResponseFuture execute();

    public HttpRequestBuilder setBody(Object var1, MimeType var2) throws IOException;

    public <T> HttpRequestBuilder on(Class<? extends State<T>> var1, Receiver<T> var2);

    public <T> HttpRequestBuilder on(StateType var1, Receiver<T> var2);

    public HttpRequestBuilder onEvent(Receiver<State<?>> var1);

    public URL toURL();

    public HttpRequestBuilder noHostHeader();

    public HttpRequestBuilder noConnectionHeader();

    public HttpRequestBuilder noDateHeader();

    public HttpRequestBuilder setCookieStore(CookieStore var1);

    public HttpRequestBuilder setTimeout(Duration var1);

    public HttpRequestBuilder dontAggregateResponse();
}

