/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.netty.http.client.HttpClient;
import com.mastfrog.netty.http.client.RequestInfo;
import com.mastfrog.netty.http.client.State;
import com.mastfrog.url.HostAndPort;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLEngine;

final class Initializer
extends ChannelInitializer<Channel> {
    private final HostAndPort hostPort;
    private final ChannelInboundHandlerAdapter handler;
    private final SslContext context;
    private final boolean ssl;
    private final int maxChunkSize;
    private final int maxInitialLineLength;
    private final boolean compress;

    Initializer(HostAndPort hostPort, ChannelInboundHandlerAdapter handler, SslContext context, boolean ssl, int maxChunkSize, int maxInitialLineLength, int maxHeadersSize, boolean compress) {
        this.hostPort = hostPort;
        this.handler = handler;
        this.context = context;
        this.ssl = ssl;
        this.maxChunkSize = maxChunkSize;
        this.maxInitialLineLength = maxInitialLineLength;
        this.compress = compress;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.ssl) {
            SslContext clientContext = this.context == null ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : this.context;
            pipeline.addLast("ssl", (ChannelHandler)new ExceptionForwardingSslHandler(clientContext.newEngine(ByteBufAllocator.DEFAULT, this.hostPort.host(), this.hostPort.port())));
        }
        pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec(this.maxInitialLineLength, this.maxChunkSize, this.maxChunkSize));
        if (this.compress) {
            pipeline.addLast("decompressor", (ChannelHandler)new HttpContentDecompressor());
        }
        pipeline.addLast("handler", (ChannelHandler)this.handler);
    }

    private static class ExceptionForwardingSslHandler
    extends SslHandler {
        ExceptionForwardingSslHandler(SSLEngine engine) {
            super(engine);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            RequestInfo info = (RequestInfo)ctx.channel().attr(HttpClient.KEY).get();
            if (info != null) {
                info.handle.event(new State.Error(cause));
            }
        }
    }
}

