/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

class LocalhostOnlyAddressResolverGroup
extends AddressResolverGroup<InetSocketAddress> {
    private final Map<EventExecutor, Res> cache = new WeakHashMap<EventExecutor, Res>();

    LocalhostOnlyAddressResolverGroup() {
    }

    protected AddressResolver<InetSocketAddress> newResolver(EventExecutor ee) throws Exception {
        Res result = this.cache.get(ee);
        if (result == null) {
            result = new Res(ee);
            this.cache.put(ee, result);
        }
        return result;
    }

    static class Res
    extends AbstractAddressResolver<InetSocketAddress> {
        Res(EventExecutor executor) {
            super(executor, InetSocketAddress.class);
        }

        private InetAddress localhost() {
            return InetAddress.getLoopbackAddress();
        }

        protected boolean doIsResolved(InetSocketAddress t) {
            return this.localhost().equals(t.getAddress());
        }

        protected void doResolve(final InetSocketAddress addr, final Promise<InetSocketAddress> prms) throws Exception {
            super.executor().submit(new Runnable(){

                @Override
                public void run() {
                    InetAddress loc = this.localhost();
                    InetSocketAddress sock = new InetSocketAddress(loc, addr.getPort());
                    prms.setSuccess((Object)sock);
                }
            });
        }

        protected void doResolveAll(final InetSocketAddress addr, final Promise<List<InetSocketAddress>> prms) throws Exception {
            this.executor().submit(new Runnable(){

                @Override
                public void run() {
                    InetSocketAddress sock = new InetSocketAddress(this.localhost(), addr.getPort());
                    prms.setSuccess(Collections.singletonList(sock));
                }
            });
        }
    }
}

