/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.netty.http.client.HttpClient;
import com.mastfrog.netty.http.client.RedirectException;
import com.mastfrog.netty.http.client.RequestInfo;
import com.mastfrog.netty.http.client.ResponseFuture;
import com.mastfrog.netty.http.client.State;
import com.mastfrog.url.URL;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@ChannelHandler.Sharable
final class MessageHandlerImpl
extends ChannelInboundHandlerAdapter {
    private static final int DEFAULT_MAX_REDIRECTS = 15;
    private final boolean followRedirects;
    private final HttpClient client;
    private final int maxRedirects;
    public static final AttributeKey<ResponseState> RS = AttributeKey.valueOf((String)"state");

    MessageHandlerImpl(boolean followRedirects, HttpClient client, int maxRedirects) {
        this.followRedirects = followRedirects;
        this.client = client;
        this.maxRedirects = maxRedirects == -1 ? 15 : maxRedirects;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        RequestInfo info = (RequestInfo)ctx.channel().attr(HttpClient.KEY).get();
        if (!info.cancelled.get()) {
            try {
                this.sendFullResponse(ctx);
            }
            finally {
                info.handle.event(new State.Closed());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RequestInfo info = (RequestInfo)ctx.channel().attr(HttpClient.KEY).get();
        info.handle.event(new State.Error(cause));
    }

    private boolean checkCancelled(ChannelHandlerContext ctx) {
        boolean result;
        RequestInfo info = (RequestInfo)ctx.channel().attr(HttpClient.KEY).get();
        boolean bl = result = info != null && info.cancelled.get();
        if (result) {
            Channel ch = ctx.channel();
            if (ch.isOpen()) {
                ch.close();
            }
            this.discardResponseState(ctx);
        }
        return result;
    }

    private void discardResponseState(ChannelHandlerContext ctx) {
        Attribute st = ctx.channel().attr(RS);
        ResponseState rs = (ResponseState)st.get();
        if (rs != null) {
            rs.release();
        }
    }

    private ResponseState state(ChannelHandlerContext ctx, RequestInfo info) {
        Attribute st = ctx.channel().attr(RS);
        ResponseState rs = (ResponseState)st.get();
        if (rs == null) {
            rs = new ResponseState(ctx, info.dontAggregate);
            st.set((Object)rs);
        }
        return rs;
    }

    private String isRedirect(RequestInfo info, HttpResponse msg) throws UnsupportedEncodingException {
        HttpResponseStatus status = msg.status();
        if (msg instanceof ReferenceCounted) {
            ((ReferenceCounted)msg).touch((Object)"msg-handler-is-redirect");
        }
        switch (status.code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: {
                String pth;
                String hdr = URLDecoder.decode(msg.headers().get((CharSequence)HttpHeaderNames.LOCATION), "UTF-8");
                if (hdr == null) break;
                if (hdr.toLowerCase().startsWith("http://") || hdr.toLowerCase().startsWith("https://")) {
                    return hdr;
                }
                URL orig = info.url;
                String string = pth = orig.getPath() == null ? "/" : URLDecoder.decode(orig.getPath().toString(), "UTF-8");
                pth = hdr.startsWith("/") ? hdr : (pth.endsWith("/") ? pth + hdr : pth + "/" + hdr);
                StringBuilder sb = new StringBuilder(orig.getProtocol().toString());
                sb.append("://").append(orig.getHost());
                if (!orig.getProtocol().getDefaultPort().equals((Object)orig.getPort())) {
                    sb.append(":").append(orig.getPort());
                }
                if (pth.charAt(0) != '/') {
                    sb.append('/');
                }
                sb.append(pth);
                return sb.toString();
            }
        }
        return null;
    }

    static boolean devLogging() {
        return Boolean.getBoolean("http.client.dev.logging");
    }

    static final void logHandlers(ChannelHandlerContext ctx, String msg) {
        if (MessageHandlerImpl.devLogging()) {
            System.out.println("  CLIENT " + msg + " PIPELINE NOW: ");
            ctx.pipeline().forEach(e -> System.out.println("    - " + (String)e.getKey() + "\t" + e.getValue()));
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        MessageHandlerImpl.logHandlers(ctx, "handlerAdded");
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        MessageHandlerImpl.logHandlers(ctx, "handlerRemoved");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (MessageHandlerImpl.devLogging()) {
            System.out.println("RECEIVED " + msg);
            ctx.pipeline().forEach(e -> System.out.println("    - " + (String)e.getKey() + "\t" + e.getValue()));
        }
        if (msg instanceof ReferenceCounted) {
            ((ReferenceCounted)msg).touch((Object)"msg-handler-impl-channel-read");
        }
        RequestInfo info = (RequestInfo)ctx.channel().attr(HttpClient.KEY).get();
        if (this.checkCancelled(ctx)) {
            return;
        }
        ResponseState state = this.state(ctx, info);
        if (msg instanceof HttpResponse) {
            state.resp = (HttpResponse)msg;
            boolean redirectLoop = false;
            String redirUrl = null;
            if (msg instanceof FullHttpResponse) {
                ((FullHttpResponse)msg).touch((Object)"MessageHandlerImpl.channelRead-HttpResponse");
            }
            if (this.followRedirects && (redirUrl = this.isRedirect(info, state.resp)) != null) {
                Method meth = state.resp.status().code() == 303 ? Method.GET : Method.valueOf((String)info.req.method().name());
                AtomicBoolean ab = new AtomicBoolean(true);
                RequestInfo b = new RequestInfo(info.url, info.req, ab, new ResponseFuture(ab), null, info.timeout, info.timer, info.dontAggregate, info.chunkedBody);
                ctx.channel().attr(HttpClient.KEY).set((Object)b);
                if (info.redirectCount.getAndIncrement() < this.maxRedirects) {
                    URL url = redirUrl.contains("://") ? URL.parse((String)redirUrl) : (redirUrl.length() > 0 && redirUrl.charAt(0) == '/' ? URL.parse((String)(info.url.getBaseURL(true) + redirUrl)) : (redirUrl.length() > 0 && redirUrl.charAt(0) != '/' ? URL.parse((String)(info.url.toString() + redirUrl)) : URL.parse((String)redirUrl)));
                    if (!url.isValid()) {
                        info.handle.event(new State.Error(new RedirectException(RedirectException.Kind.INVALID_REDIRECT_URL, redirUrl)));
                        return;
                    }
                    info.handle.event(new State.Redirect(url));
                    info.handle.cancelled = new AtomicBoolean();
                    this.client.redirect(meth, url, info);
                    return;
                }
                redirectLoop = true;
            }
            info.handle.event(new State.HeadersReceived(state.resp));
            if (redirectLoop) {
                RedirectException redirException = new RedirectException(RedirectException.Kind.REDIRECT_LOOP, redirUrl);
                info.handle.event(new State.Error(redirException));
                info.handle.cancelled.lazySet(true);
            }
        } else if (msg instanceof HttpContent) {
            ((HttpContent)msg).touch((Object)"MessageHandlerImpl.channelRead-HttpContent");
            if (msg instanceof LastHttpContent && state.resp != null && HttpResponseStatus.CONTINUE.equals((Object)state.resp.status())) {
                info.handle.event(new State.AwaitingResponse());
                return;
            }
            HttpContent c = (HttpContent)msg;
            info.handle.event(new State.ContentReceived(c));
            c.content().resetReaderIndex();
            if (c.content().readableBytes() > 0) {
                state.append(c.content());
            }
            state.aggregateContent.resetReaderIndex();
            boolean last = c instanceof LastHttpContent;
            if (!last && state.resp.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH) != null) {
                long len = ((Number)Headers.CONTENT_LENGTH.toValue((CharSequence)state.resp.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH))).longValue();
                boolean bl = last = (long)state.readableBytes() >= len;
            }
            if (last) {
                c.content().resetReaderIndex();
                this.sendFullResponse(ctx);
            }
        } else {
            info.handle.event(new State.Error(new IllegalStateException("Unknown object decoded: " + msg)));
        }
    }

    void sendFullResponse(ChannelHandlerContext ctx) {
        RequestInfo info = (RequestInfo)ctx.channel().attr(HttpClient.KEY).get();
        if (info != null && info.dontAggregate) {
            return;
        }
        ResponseState state = this.state(ctx, info);
        Class<State.Finished> type = State.Finished.class;
        state.aggregateContent.resetReaderIndex();
        if (info != null) {
            info.cancelTimer();
        }
        if ((info.r != null || info.handle.has(type)) && !state.fullResponseSent && state.aggregateContent.readableBytes() > 0) {
            state.fullResponseSent = true;
            state.aggregateContent.touch((Object)"client-send-full-response");
            info.handle.event(new State.FullContentReceived((ByteBuf)state.aggregateContent));
            DefaultFullHttpResponse full = new DefaultFullHttpResponse(state.resp.protocolVersion(), state.resp.status(), (ByteBuf)state.aggregateContent);
            full.touch((Object)"sendFullResponse");
            for (Map.Entry e : state.resp.headers().entries()) {
                full.headers().add((String)e.getKey(), e.getValue());
            }
            state.aggregateContent.resetReaderIndex();
            if (info.r != null) {
                info.r.internalReceive(state.resp.status(), state.resp.headers(), (ByteBuf)state.aggregateContent);
            }
            state.aggregateContent.resetReaderIndex();
            info.handle.event(new State.Finished((FullHttpResponse)full));
            state.aggregateContent.resetReaderIndex();
            info.handle.trigger();
        }
    }

    static class ResponseState {
        private final CompositeByteBuf aggregateContent;
        volatile HttpResponse resp;
        volatile boolean fullResponseSent;
        private int readableBytes;
        private final boolean dontAggregate;
        private boolean released;

        ResponseState(ChannelHandlerContext ctx, boolean dontAggregate) {
            this.aggregateContent = ctx.alloc().compositeBuffer();
            this.aggregateContent.touch((Object)"response-state-aggregate");
            this.dontAggregate = dontAggregate;
        }

        int readableBytes() {
            return this.readableBytes;
        }

        synchronized void release() {
            if (!this.released) {
                this.released = true;
                this.aggregateContent.release();
            }
        }

        void append(ByteBuf buf) {
            buf.touch((Object)"ResponseState.append");
            this.readableBytes += buf.readableBytes();
            if (!this.dontAggregate) {
                int ix = this.aggregateContent.writerIndex();
                int added = buf.readableBytes();
                this.aggregateContent.addComponent(buf);
                this.aggregateContent.writerIndex(ix + added);
            } else if (buf.refCnt() > 0) {
                buf.release();
            }
        }

        boolean hasResponse() {
            return this.resp != null;
        }
    }
}

