/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.util.preconditions.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

final class NioChannelFactory
implements ChannelFactory<NioSocketChannel> {
    private final boolean debug;

    NioChannelFactory(boolean debug) {
        this.debug = debug;
    }

    public NioSocketChannel newChannel() {
        try {
            return this.debug ? new DebugNioSocketChannel(SocketChannel.open()) : new NioSocketChannel(SocketChannel.open());
        }
        catch (IOException ioe) {
            return (NioSocketChannel)Exceptions.chuck((Throwable)ioe);
        }
    }

    public Channel newChannel(EventLoop eventLoop) {
        return this.newChannel();
    }

    private static final class DebugNioSocketChannel
    extends NioSocketChannel {
        public DebugNioSocketChannel() {
        }

        public DebugNioSocketChannel(SelectorProvider provider) {
            super(provider);
        }

        public DebugNioSocketChannel(SocketChannel socket) {
            super(socket);
        }

        public DebugNioSocketChannel(Channel parent, SocketChannel socket) {
            super(parent, socket);
        }

        protected void doClose() throws Exception {
            new Exception("client doClose").printStackTrace();
            super.doClose();
        }

        protected void doDeregister() throws Exception {
            new Exception("client doDeregister").printStackTrace();
            super.doDeregister();
        }

        public ChannelFuture close(ChannelPromise promise) {
            new Exception("client Explicit close w/ promise").printStackTrace();
            return super.close(promise);
        }

        public ChannelFuture close() {
            new Exception("client Explicit close").printStackTrace();
            return super.close();
        }

        public ChannelFuture disconnect() {
            new Exception("client Explicit disconnect").printStackTrace();
            return super.disconnect();
        }

        protected void doDisconnect() throws Exception {
            new Exception("client doDisconnect").printStackTrace();
            super.doDisconnect();
        }
    }
}

