/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.acteur.header.entities.BasicCredentials;
import com.mastfrog.acteur.headers.HeaderValueType;
import com.mastfrog.acteur.headers.Headers;
import com.mastfrog.acteur.headers.Method;
import com.mastfrog.marshallers.netty.NettyContentMarshallers;
import com.mastfrog.mime.MimeType;
import com.mastfrog.netty.http.client.ChunkedContent;
import com.mastfrog.netty.http.client.CookieStore;
import com.mastfrog.netty.http.client.HandlerEntry;
import com.mastfrog.netty.http.client.HttpRequestBuilder;
import com.mastfrog.netty.http.client.State;
import com.mastfrog.url.PathElement;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.URL;
import com.mastfrog.url.URLBuilder;
import com.mastfrog.util.multivariate.OneOf;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.thread.Receiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;

abstract class RequestBuilder
implements HttpRequestBuilder {
    private URLBuilder url = URL.builder();
    final List<Entry<?>> entries = new LinkedList();
    private final Method method;
    private HttpVersion version = HttpVersion.HTTP_1_1;
    protected CookieStore store;
    Duration timeout;
    private final ByteBufAllocator alloc;
    protected boolean noAggregate;
    private boolean noDateHeader;
    private boolean noConnectionHeader;
    private boolean noHostHeader;
    private final OneOf<ByteBuf, ChunkedContent> body = new OneOf();
    boolean send100Continue = true;
    protected final List<Receiver<State<?>>> any = new LinkedList();
    protected final List<HandlerEntry<?>> handlers = new LinkedList();

    RequestBuilder(Method method, ByteBufAllocator alloc) {
        this.method = method;
        this.alloc = alloc;
    }

    abstract NettyContentMarshallers marshallers();

    @Override
    public RequestBuilder setTimeout(Duration timeout) {
        if (timeout != null && timeout.toMillis() <= 0L) {
            throw new IllegalArgumentException("Cannot set timeout to <= 0");
        }
        this.timeout = timeout;
        return this;
    }

    @Override
    public RequestBuilder setURL(URL url) {
        this.url = URL.builder((URL)url);
        return this;
    }

    @Override
    public RequestBuilder addPathElement(String element) {
        this.url.addPathElement(new PathElement(element, false, true));
        return this;
    }

    @Override
    public RequestBuilder addQueryPair(String key, String value) {
        this.url.addQueryPair(key, value);
        return this;
    }

    @Override
    public RequestBuilder setProtocol(Protocol protocol) {
        this.url.setProtocol(protocol);
        return this;
    }

    @Override
    public RequestBuilder setAnchor(String anchor) {
        this.url.setAnchor(anchor);
        return this;
    }

    @Override
    public RequestBuilder setPassword(String password) {
        this.url.setPassword(password);
        return this;
    }

    @Override
    public RequestBuilder setPath(String path) {
        this.url.setPath(path);
        return this;
    }

    @Override
    public RequestBuilder setPort(int port) {
        this.url.setPort(port);
        return this;
    }

    @Override
    public RequestBuilder setUserName(String userName) {
        this.url.setUserName(userName);
        return this;
    }

    @Override
    public RequestBuilder setHost(String host) {
        this.url.setHost(host);
        return this;
    }

    @Override
    public RequestBuilder basicAuthentication(String username, String password) {
        this.addHeader(Headers.AUTHORIZATION, new BasicCredentials(username, password));
        return this;
    }

    @Override
    public <T> RequestBuilder addHeader(HeaderValueType<T> type, T value) {
        this.entries.add(new Entry<T>(type, value));
        return this;
    }

    URL getURL() {
        return this.url.create();
    }

    @Override
    public RequestBuilder noDateHeader() {
        this.noDateHeader = true;
        return this;
    }

    @Override
    public RequestBuilder noConnectionHeader() {
        this.noConnectionHeader = true;
        return this;
    }

    @Override
    public RequestBuilder noHostHeader() {
        this.noHostHeader = true;
        return this;
    }

    @Override
    public RequestBuilder setCookieStore(CookieStore store) {
        this.store = store;
        return this;
    }

    ChunkedContent chunkedContent() {
        return (ChunkedContent)this.body.getB();
    }

    public HttpRequest build() {
        if (this.url == null) {
            throw new IllegalStateException("URL not set");
        }
        URL u = this.getURL();
        if (!u.isValid()) {
            if (u.getProblems() != null) {
                u.getProblems().throwIfFatalPresent();
            } else {
                throw new IllegalArgumentException("Invalid url " + u);
            }
        }
        if (u.getHost() == null) {
            throw new IllegalStateException("URL host not set: " + u);
        }
        String uri = u.getPathAndQuery();
        if (uri.isEmpty()) {
            uri = "/";
        }
        HttpMethod mth = HttpMethod.valueOf((String)this.method.name());
        DefaultHttpRequest h = !this.body.isA() ? new DefaultHttpRequest(this.version, mth, uri) : new DefaultFullHttpRequest(this.version, mth, uri, (ByteBuf)this.body.getA());
        for (Entry<?> e : this.entries) {
            e.addTo(h.headers());
        }
        if (!this.noHostHeader) {
            h.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)u.getHost().toString());
        }
        if (!h.headers().contains((CharSequence)HttpHeaderNames.CONNECTION) && !this.noConnectionHeader) {
            h.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        }
        if (!this.noDateHeader) {
            h.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)Headers.DATE.toCharSequence((Object)ZonedDateTime.now()));
        }
        if (this.store != null) {
            this.store.decorate((HttpRequest)h);
        }
        return h;
    }

    @Override
    public URL toURL() {
        return this.url.create();
    }

    @Override
    public HttpRequestBuilder setBody(Object bodyObject, MimeType contentType) throws IOException {
        ByteBuf buf;
        Checks.notNull((String)"body", (Object)bodyObject);
        if (bodyObject instanceof ChunkedContent) {
            this.body.setB((Object)((ChunkedContent)bodyObject));
            if (this.send100Continue) {
                this.addHeader(Headers.EXPECT, HttpHeaderValues.CONTINUE);
            }
            this.addHeader(Headers.CONTENT_TYPE, contentType);
            this.addHeader(Headers.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
            return this;
        }
        if (bodyObject instanceof ByteBuf) {
            buf = (ByteBuf)bodyObject;
        } else {
            buf = this.newByteBuf();
            try {
                this.marshallers().write(bodyObject, (Object)buf, new Object[]{contentType});
            }
            catch (Exception ex) {
                Exceptions.chuck((Throwable)ex);
            }
        }
        this.body.setA((Object)buf);
        if (this.send100Continue) {
            this.addHeader(Headers.EXPECT, HttpHeaderValues.CONTINUE);
        }
        this.addHeader(Headers.CONTENT_LENGTH, (Object)buf.readableBytes());
        this.addHeader(Headers.CONTENT_TYPE, contentType);
        return this;
    }

    protected ByteBuf newByteBuf() {
        ByteBuf result = this.alloc.ioBuffer();
        result.touch((Object)"request-builder-new-byte-buf");
        return result;
    }

    @Override
    public HttpRequestBuilder onEvent(Receiver<State<?>> r) {
        this.any.add(r);
        return this;
    }

    @Override
    public <T> HttpRequestBuilder on(Class<? extends State<T>> event, Receiver<T> r) {
        HandlerEntry<Object> h = null;
        for (HandlerEntry<?> e : this.handlers) {
            if (!e.state.equals(event)) continue;
            h = e;
            break;
        }
        if (h == null) {
            h = new HandlerEntry<T>(event);
            this.handlers.add(h);
        }
        h.add(r);
        return this;
    }

    @Override
    public HttpRequestBuilder setURL(String url) {
        this.setURL(URL.parse((String)url));
        return this;
    }

    @Override
    public HttpRequestBuilder dontAggregateResponse() {
        this.noAggregate = true;
        return this;
    }

    private static final class Entry<T> {
        private final HeaderValueType<T> type;
        private final T value;

        Entry(HeaderValueType<T> type, T value) {
            this.type = type;
            this.value = value;
        }

        void addTo(HttpHeaders h) {
            h.add(this.type.name(), (Object)this.type.toCharSequence(this.value));
        }
    }
}

