/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.netty.http.client.ChunkedContent;
import com.mastfrog.netty.http.client.ResponseFuture;
import com.mastfrog.netty.http.client.ResponseHandler;
import com.mastfrog.url.URL;
import io.netty.handler.codec.http.HttpRequest;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class RequestInfo {
    final URL url;
    final HttpRequest req;
    final AtomicBoolean cancelled;
    final ResponseFuture handle;
    final ResponseHandler<?> r;
    final AtomicInteger redirectCount = new AtomicInteger();
    final Duration timeout;
    final ZonedDateTime startTime;
    volatile boolean listenerAdded;
    TimerTask timer;
    final boolean dontAggregate;
    final ChunkedContent chunkedBody;

    RequestInfo(URL url, HttpRequest req, AtomicBoolean cancelled, ResponseFuture handle, ResponseHandler<?> r, Duration timeout, ZonedDateTime startTime, TimerTask timer, boolean noAggregate, ChunkedContent chunkedBody) {
        this.url = url;
        this.req = req;
        this.cancelled = cancelled;
        this.handle = handle;
        this.r = r;
        this.timeout = timeout;
        this.startTime = startTime;
        this.timer = timer;
        this.dontAggregate = noAggregate;
        this.chunkedBody = chunkedBody;
    }

    RequestInfo(URL url, HttpRequest req, AtomicBoolean cancelled, ResponseFuture handle, ResponseHandler<?> r, Duration timeout, TimerTask timer, boolean noAggregate, ChunkedContent chunkedBody) {
        this(url, req, cancelled, handle, r, timeout, ZonedDateTime.now(), timer, noAggregate, chunkedBody);
    }

    Duration age() {
        return Duration.between(this.startTime, ZonedDateTime.now());
    }

    Duration remaining() {
        return this.timeout == null ? null : this.timeout.minus(this.age());
    }

    boolean isExpired() {
        if (this.timeout != null) {
            return ZonedDateTime.now().isAfter(this.startTime.plus(this.timeout));
        }
        return false;
    }

    void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public String toString() {
        return "RequestInfo{url=" + this.url + ", req=" + this.req + ", cancelled=" + this.cancelled + ", handle=" + this.handle + ", r=" + this.r + ", timeout=" + this.timeout + '}';
    }
}

