/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.netty.http.client.HandlerEntry;
import com.mastfrog.netty.http.client.RedirectException;
import com.mastfrog.netty.http.client.State;
import com.mastfrog.netty.http.client.StateType;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.thread.Receiver;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ResponseFuture
implements Comparable<ResponseFuture> {
    AtomicBoolean cancelled;
    final List<HandlerEntry<?>> handlers = new CopyOnWriteArrayList();
    final List<Receiver<State<?>>> any = new CopyOnWriteArrayList();
    private volatile ChannelFuture future;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ZonedDateTime start = ZonedDateTime.now();
    private Map<StateType, List<Object>> queuedToSend;
    private final EnumSet<StateType> seenStates = EnumSet.noneOf(StateType.class);
    private volatile Throwable error;
    private final AtomicReference<StateType> lastState = new AtomicReference();

    ResponseFuture(AtomicBoolean cancelled) {
        this.cancelled = cancelled;
    }

    void setFuture(ChannelFuture fut) {
        this.future = fut;
    }

    void trigger() {
        this.latch.countDown();
    }

    public ResponseFuture sendOn(StateType stateType, Object o) {
        if (this.queuedToSend == null) {
            this.queuedToSend = new HashMap<StateType, List<Object>>();
        }
        if (stateType.isFailure() || stateType == StateType.Closed || stateType == StateType.Connecting) {
            throw new IllegalArgumentException("Cannot send messages after a failure or close state is reached.  Pick a different state.");
        }
        List<Object> queue = this.queuedToSend.get((Object)stateType);
        if (queue == null) {
            queue = new ArrayList<Object>(2);
            this.queuedToSend.put(stateType, queue);
        }
        queue.add(o);
        this.sendQueued();
        return this;
    }

    private void sendQueued() {
        if (this.queuedToSend != null && this.future != null && this.future.channel().isWritable()) {
            LinkedList<Object> toSend = new LinkedList<Object>();
            EnumSet<StateType> toRemove = EnumSet.noneOf(StateType.class);
            for (Map.Entry<StateType, List<Object>> e : this.queuedToSend.entrySet()) {
                if (!this.seenStates.contains((Object)e.getKey()) || e.getValue().isEmpty()) continue;
                toSend.addAll((Collection<Object>)e.getValue());
                e.getValue().clear();
                toRemove.add(e.getKey());
            }
            for (StateType st : toRemove) {
                this.queuedToSend.remove((Object)st);
            }
            if (!toSend.isEmpty()) {
                new SendObjs(toSend).operationComplete(this.future.channel().newSucceededFuture());
            }
        }
    }

    public ResponseFuture await() throws InterruptedException {
        this.latch.await();
        return this;
    }

    public ResponseFuture await(long l, TimeUnit tu) throws InterruptedException {
        Checks.notNull((String)"tu", (Object)((Object)tu));
        Checks.nonNegative((String)"l", (long)l);
        this.latch.await(l, tu);
        return this;
    }

    void onTimeout(Duration dur) {
        this.cancel(dur);
    }

    public boolean cancel() {
        return this.cancel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(Duration forTimeout) {
        boolean result;
        if (forTimeout != null && !this.cancelled.get()) {
            this.event(new State.Timeout(forTimeout));
        }
        if (result = this.cancelled.compareAndSet(false, true)) {
            try {
                ChannelFuture fut = this.future;
                if (fut != null) {
                    fut.cancel(true);
                }
                if (fut != null && fut.channel() != null && fut.channel().isOpen()) {
                    fut.channel().close();
                }
            }
            finally {
                if (forTimeout == null) {
                    this.event(new State.Cancelled());
                }
            }
            this.latch.countDown();
        }
        return result;
    }

    public ResponseFuture throwIfError() throws Throwable {
        if (this.error != null) {
            throw this.error;
        }
        return this;
    }

    public final StateType lastState() {
        return this.lastState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void event(State<T> state) {
        if (state.stateType().isFailure()) {
            this.queuedToSend = null;
        }
        Checks.notNull((String)"state", state);
        this.seenStates.add(state.stateType());
        this.lastState.set(state.stateType());
        if (state.get() instanceof ReferenceCounted) {
            ((ReferenceCounted)state.get()).touch((Object)("response-future-state-" + state.name()));
        }
        try {
            if (state instanceof State.Error && this.cancelled.get() || state instanceof State.Timeout && this.cancelled.get()) {
                if (!(state.get() instanceof RedirectException)) {
                    return;
                }
                if (state.get() instanceof RedirectException && ((RedirectException)state.get()).kind() == RedirectException.Kind.INVALID_REDIRECT_URL) {
                    return;
                }
            }
            if (state instanceof State.Error) {
                this.error = (Throwable)((State.Error)state).get();
            }
            for (HandlerEntry<?> handlerEntry : this.handlers) {
                if (!handlerEntry.state.isInstance(state)) continue;
                HandlerEntry<?> hh = handlerEntry;
                hh.onEvent(state);
            }
            for (Receiver receiver : this.any) {
                receiver.receive(state);
            }
        }
        finally {
            if (state instanceof State.Closed) {
                this.latch.countDown();
            }
            this.sendQueued();
        }
    }

    public ResponseFuture onAnyEvent(Receiver<State<?>> r) {
        this.any.add(r);
        return this;
    }

    boolean has(Class<? extends State<?>> state) {
        if (!this.any.isEmpty()) {
            return true;
        }
        for (HandlerEntry<?> h : this.handlers) {
            if (state != h.state) continue;
            return true;
        }
        return false;
    }

    public <T> ResponseFuture on(StateType state, Receiver<T> receiver) {
        StateType s = this.lastState.get();
        if (s == StateType.Closed && state == StateType.Closed) {
            receiver.receive(null);
        }
        Class<? extends State<?>> type = state.type();
        return this.on(type, state.wrapperReceiver(receiver));
    }

    public <T> ResponseFuture on(Class<? extends State<T>> state, Receiver<T> receiver) {
        HandlerEntry<Object> handler = null;
        for (HandlerEntry<?> h : this.handlers) {
            if (!state.equals(h.state)) continue;
            handler = h;
            break;
        }
        if (handler == null) {
            handler = new HandlerEntry<T>(state);
            this.handlers.add(handler);
        }
        handler.add(receiver);
        return this;
    }

    @Override
    public int compareTo(ResponseFuture t) {
        ZonedDateTime mine = this.start;
        ZonedDateTime other = t.start;
        return mine.compareTo(other);
    }

    final class SendObjs
    implements ChannelFutureListener {
        private final Iterator<Object> objs;

        SendObjs(List<Object> objs) {
            this.objs = objs.iterator();
        }

        public void operationComplete(ChannelFuture future) {
            if (future.isSuccess()) {
                if (this.objs.hasNext()) {
                    Object o = this.objs.next();
                    future = future.channel().writeAndFlush(o);
                    if (this.objs.hasNext()) {
                        future.addListener((GenericFutureListener)this);
                    }
                }
            } else {
                ResponseFuture.this.event(new State.Error(future.cause()));
            }
        }
    }
}

