/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mastfrog.marshallers.netty.NettyContentMarshallers;
import com.mastfrog.mime.MimeType;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.Streams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class ResponseHandler<T> {
    private final Class<T> type;
    private final CountDownLatch latch = new CountDownLatch(1);
    NettyContentMarshallers marshallers;

    public ResponseHandler(Class<T> type, NettyContentMarshallers marshallers) {
        this.marshallers = marshallers;
        this.type = type;
    }

    public ResponseHandler(Class<T> type, ObjectMapper mapper) {
        this(type, NettyContentMarshallers.getDefault((ObjectMapper)mapper));
    }

    public ResponseHandler(Class<T> type) {
        this(type, NettyContentMarshallers.getDefault((ObjectMapper)new ObjectMapper()));
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long l, TimeUnit tu) throws InterruptedException {
        return this.latch.await(l, tu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalReceive(HttpResponseStatus status, HttpHeaders headers, ByteBuf content) {
        try {
            content.touch((Object)"ResponseHandler.internalReceive");
            if (status.code() > 399) {
                this.onErrorResponse(status, headers, content.readCharSequence(content.readableBytes(), CharsetUtil.UTF_8).toString());
                content.release();
                return;
            }
            MimeType mediaType = null;
            if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                try {
                    mediaType = MimeType.parse((CharSequence)headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Object o = mediaType == null ? this.marshallers.read(this.type, (Object)content, new Object[0]) : this.marshallers.read(this.type, (Object)content, new Object[]{mediaType});
            this._doReceive(status, headers, this.type.cast(o));
        }
        catch (Exception ex) {
            content.resetReaderIndex();
            try {
                String s = Streams.readString((InputStream)new ByteBufInputStream(content), (String)"UTF-8");
                this.onErrorResponse(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE, headers, s);
            }
            catch (IOException ex1) {
                ex.addSuppressed(ex1);
            }
            Exceptions.chuck((Throwable)ex);
        }
        finally {
            this.latch.countDown();
        }
    }

    void _doReceive(HttpResponseStatus status, HttpHeaders headers, T obj) {
        this.receive(status, headers, obj);
        this.receive(status, obj);
        this.receive(obj);
    }

    protected void receive(HttpResponseStatus status, T obj) {
    }

    protected void receive(HttpResponseStatus status, HttpHeaders headers, T obj) {
    }

    protected void receive(T obj) {
    }

    protected void onErrorResponse(String content) {
    }

    protected void onErrorResponse(HttpResponseStatus status, String content) {
        this.onErrorResponse(content);
    }

    protected void onErrorResponse(HttpResponseStatus status, HttpHeaders headers, String content) {
        this.onErrorResponse(status, content);
    }

    protected void onError(Throwable err) {
    }

    public Class<T> type() {
        return this.type;
    }
}

