/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.mastfrog.netty.http.client.HttpClientBuilder;
import com.mastfrog.netty.http.client.Initializer;
import com.mastfrog.netty.http.client.MessageHandlerImpl;
import com.mastfrog.netty.http.client.NioChannelFactory;
import com.mastfrog.url.HostAndPort;
import com.mastfrog.util.preconditions.Exceptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.AddressResolverGroup;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

final class SslBootstrapCache {
    private final Ldr ldr = new Ldr();
    private final LoadingCache<HostAndPort, Bootstrap> bootstrapForHostPort = CacheBuilder.newBuilder().concurrencyLevel(2).removalListener((RemovalListener)this.ldr).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)this.ldr);
    private final EventLoopGroup group;
    private final Duration timeout;
    private final SslContext sslContext;
    private final MessageHandlerImpl handler;
    private final int maxChunkSize;
    private final int maxInitialLineLength;
    private final int maxHeadersSize;
    private final boolean compress;
    private final Iterable<HttpClientBuilder.ChannelOptionSetting<?>> settings;
    private final AddressResolverGroup<?> resolver;
    private final NioChannelFactory channelFactory;

    SslBootstrapCache(EventLoopGroup group, Duration timeout, SslContext sslContext, MessageHandlerImpl handler, int maxChunkSize, int maxInitialLineLength, int maxHeadersSize, boolean compress, Iterable<HttpClientBuilder.ChannelOptionSetting<?>> settings, AddressResolverGroup<?> resolver, NioChannelFactory channelFactory) {
        this.group = group;
        this.timeout = timeout;
        this.sslContext = sslContext;
        this.handler = handler;
        this.maxChunkSize = maxChunkSize;
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeadersSize = maxHeadersSize;
        this.compress = compress;
        this.settings = settings;
        this.resolver = resolver;
        this.channelFactory = channelFactory;
    }

    Bootstrap sslBootstrap(HostAndPort hostAndPort) {
        try {
            return (Bootstrap)this.bootstrapForHostPort.get((Object)hostAndPort);
        }
        catch (ExecutionException e) {
            return (Bootstrap)Exceptions.chuck((Throwable)e);
        }
    }

    void clear() {
        this.bootstrapForHostPort.cleanUp();
        this.bootstrapForHostPort.invalidateAll();
    }

    private class Ldr
    extends CacheLoader<HostAndPort, Bootstrap>
    implements RemovalListener<HostAndPort, Bootstrap> {
        private Ldr() {
        }

        public Bootstrap load(HostAndPort k) throws Exception {
            Bootstrap bootstrapSsl = new Bootstrap();
            bootstrapSsl.group(SslBootstrapCache.this.group);
            bootstrapSsl.handler((ChannelHandler)new Initializer(k, SslBootstrapCache.this.handler, SslBootstrapCache.this.sslContext, true, SslBootstrapCache.this.maxChunkSize, SslBootstrapCache.this.maxInitialLineLength, SslBootstrapCache.this.maxHeadersSize, SslBootstrapCache.this.compress));
            bootstrapSsl.option(ChannelOption.SO_REUSEADDR, (Object)false);
            if (SslBootstrapCache.this.resolver != null) {
                bootstrapSsl.resolver(SslBootstrapCache.this.resolver);
            }
            bootstrapSsl.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            if (SslBootstrapCache.this.timeout != null) {
                bootstrapSsl.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)SslBootstrapCache.this.timeout.toMillis()));
            }
            for (HttpClientBuilder.ChannelOptionSetting setting : SslBootstrapCache.this.settings) {
                setting.apply(bootstrapSsl);
            }
            bootstrapSsl.channelFactory((ChannelFactory)SslBootstrapCache.this.channelFactory);
            return bootstrapSsl;
        }

        public void onRemoval(RemovalNotification<HostAndPort, Bootstrap> rn) {
        }
    }
}

