/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.netty.http.client.StateType;
import com.mastfrog.url.URL;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.time.Duration;

public abstract class State<T> {
    private final Class<T> type;
    private final StateType name;
    private final T state;

    State(Class<T> type, StateType name, T state) {
        this.type = type;
        this.name = name;
        this.state = state;
    }

    public Class<T> type() {
        return this.type;
    }

    public String name() {
        return this.name.name();
    }

    public StateType stateType() {
        return this.name;
    }

    public T get() {
        return this.state;
    }

    public String toString() {
        return this.name();
    }

    static final class Cancelled
    extends State<Void> {
        Cancelled() {
            super(Void.class, StateType.Cancelled, null);
        }
    }

    public static final class Timeout
    extends State<Duration> {
        Timeout(Duration d) {
            super(Duration.class, StateType.Timeout, d);
        }
    }

    public static final class Error
    extends State<Throwable> {
        Error(Throwable t) {
            super(Throwable.class, StateType.Error, t);
        }
    }

    public static final class Finished
    extends State<FullHttpResponse> {
        Finished(FullHttpResponse buf) {
            super(FullHttpResponse.class, StateType.Finished, buf);
        }
    }

    static final class Closed
    extends State<Void> {
        Closed() {
            super(Void.class, StateType.Closed, null);
        }
    }

    public static final class Redirect
    extends State<URL> {
        Redirect(URL content) {
            super(URL.class, StateType.Redirect, content);
        }
    }

    public static final class FullContentReceived
    extends State<ByteBuf> {
        FullContentReceived(ByteBuf content) {
            super(ByteBuf.class, StateType.FullContentReceived, content);
        }
    }

    public static final class ContentReceived
    extends State<HttpContent> {
        ContentReceived(HttpContent headers) {
            super(HttpContent.class, StateType.ContentReceived, headers);
        }
    }

    public static final class HeadersReceived
    extends State<HttpResponse> {
        HeadersReceived(HttpResponse headers) {
            super(HttpResponse.class, StateType.HeadersReceived, headers);
        }
    }

    public static final class SendRequest
    extends State<HttpRequest> {
        SendRequest(HttpRequest req) {
            super(HttpRequest.class, StateType.SendRequest, req);
        }
    }

    public static final class Connected
    extends State<Channel> {
        Connected(Channel channel) {
            super(Channel.class, StateType.Connected, channel);
        }
    }

    static final class AwaitingResponse
    extends State<Void> {
        AwaitingResponse() {
            super(Void.class, StateType.AwaitingResponse, null);
        }
    }

    static final class Connecting
    extends State<Void> {
        Connecting() {
            super(Void.class, StateType.Connecting, null);
        }
    }
}

