/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.netty.http.client;

import com.mastfrog.netty.http.client.State;
import com.mastfrog.url.URL;
import com.mastfrog.util.thread.Receiver;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.lang.reflect.Method;
import java.time.Duration;

public enum StateType {
    Connecting,
    Connected,
    SendRequest,
    AwaitingResponse,
    HeadersReceived,
    ContentReceived,
    Redirect,
    FullContentReceived,
    Closed,
    Finished,
    Error,
    Timeout,
    Cancelled;


    Receiver<?> wrapperReceiver(Receiver<?> orig) {
        return this.wrapperReceiver(this.stateValueType(), orig);
    }

    public boolean isResponseComplete() {
        switch (this) {
            case AwaitingResponse: 
            case Connected: 
            case Connecting: 
            case ContentReceived: 
            case HeadersReceived: 
            case SendRequest: {
                return false;
            }
        }
        return true;
    }

    public boolean isFailure() {
        switch (this) {
            case Cancelled: 
            case Closed: 
            case Error: 
            case Timeout: {
                return true;
            }
        }
        return false;
    }

    private <T> Receiver<T> wrapperReceiver(final Class<T> type, final Receiver<?> orig) {
        return new Receiver<T>(){

            public void receive(T object) {
                Receiver r = orig;
                try {
                    r.receive(object);
                }
                catch (ClassCastException e) {
                    String typeName = null;
                    for (Method m : orig.getClass().getMethods()) {
                        Class<?> what;
                        if (!"receive".equals(m.getName()) || m.getParameterTypes().length != 1 || (what = m.getParameterTypes()[0]) == Object.class) continue;
                        typeName = what.getName();
                        break;
                    }
                    System.err.println("Receiver " + orig + " for " + type.getName() + " takes the wrong class " + typeName + " in its receive() method. Expected " + type + ". Passing null instead");
                    orig.receive(null);
                }
            }
        };
    }

    public Class<?> stateValueType() {
        switch (this) {
            case Connecting: {
                return Void.class;
            }
            case Connected: {
                return Channel.class;
            }
            case SendRequest: {
                return HttpRequest.class;
            }
            case AwaitingResponse: {
                return Void.class;
            }
            case HeadersReceived: {
                return HttpResponse.class;
            }
            case ContentReceived: {
                return HttpContent.class;
            }
            case Redirect: {
                return URL.class;
            }
            case FullContentReceived: {
                return ByteBuf.class;
            }
            case Closed: {
                return Void.class;
            }
            case Finished: {
                return FullHttpResponse.class;
            }
            case Error: {
                return Throwable.class;
            }
            case Cancelled: {
                return Boolean.class;
            }
            case Timeout: {
                return Duration.class;
            }
        }
        throw new AssertionError((Object)this);
    }

    public Class<? extends State<?>> type() {
        switch (this) {
            case Connecting: {
                return State.Connecting.class;
            }
            case Connected: {
                return State.Connected.class;
            }
            case SendRequest: {
                return State.SendRequest.class;
            }
            case AwaitingResponse: {
                return State.AwaitingResponse.class;
            }
            case HeadersReceived: {
                return State.HeadersReceived.class;
            }
            case ContentReceived: {
                return State.ContentReceived.class;
            }
            case Redirect: {
                return State.Redirect.class;
            }
            case FullContentReceived: {
                return State.FullContentReceived.class;
            }
            case Closed: {
                return State.Closed.class;
            }
            case Finished: {
                return State.Finished.class;
            }
            case Error: {
                return State.Error.class;
            }
            case Cancelled: {
                return State.Cancelled.class;
            }
            case Timeout: {
                return State.Timeout.class;
            }
        }
        throw new AssertionError((Object)this);
    }
}

