/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.scope;

import com.google.inject.Provider;
import com.mastfrog.function.misc.QuietAutoClosable;
import com.mastfrog.giulius.scope.AbstractScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class ReentrantScope
extends AbstractScope {
    private final ThreadLocal<List<Object[]>> lists = new ThreadLocal();
    private final QuietAutoClosable qac = new NTAC(this);

    public ReentrantScope() {
    }

    public ReentrantScope(Provider<String> injectionInfoProvider) {
        super(injectionInfoProvider);
    }

    Object[] includeStackTrace(Object ... scopeContents) {
        if (this.includeStackTraces) {
            Object[] nue = new Object[scopeContents.length + 1];
            System.arraycopy(scopeContents, 0, nue, 0, scopeContents.length);
            nue[nue.length - 1] = new Throwable();
            return nue;
        }
        return scopeContents;
    }

    @Override
    public QuietAutoClosable enter(Object ... o) {
        List<Object[]> context = this.lists.get();
        if (context == null) {
            context = new ArrayList<Object[]>(20);
            this.lists.set(context);
        }
        context.add(o);
        return this.qac;
    }

    @Override
    protected List<Object> contents() {
        ArrayList<Object> result = new ArrayList<Object>(40);
        List<Object[]> toSearch = this.lists.get();
        if (toSearch != null && !toSearch.isEmpty()) {
            for (Object[] l : toSearch) {
                result.addAll(Arrays.asList(l));
            }
        }
        return result;
    }

    @Override
    public void exit() {
        List<Object[]> l = this.lists.get();
        assert (l != null);
        l.remove(l.size() - 1);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Exit {0} entry count {1}", new Object[]{this.getClass().getSimpleName(), l.size()});
        }
        if (l.isEmpty()) {
            this.lists.remove();
        }
    }

    @Override
    public boolean inScope() {
        List<Object[]> l = this.lists.get();
        return l != null && !l.isEmpty();
    }

    @Override
    protected <T> T get(Class<T> type) {
        List<Object[]> toSearch = this.lists.get();
        if (toSearch != null && !toSearch.isEmpty()) {
            int max = toSearch.size();
            for (int i = max - 1; i >= 0; --i) {
                Object[] curr = toSearch.get(i);
                for (int j = curr.length - 1; j >= 0; --j) {
                    Object o = curr[j];
                    if (!type.isInstance(o)) continue;
                    return type.cast(o);
                }
            }
        }
        return null;
    }

    private static final class NTAC
    implements QuietAutoClosable {
        private final AbstractScope scope;

        public NTAC(AbstractScope scope) {
            this.scope = scope;
        }

        public void close() {
            this.scope.exit();
        }
    }
}

