/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.giulius.scope;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.mastfrog.giulius.scope.AbstractScope;
import java.util.concurrent.Callable;

public final class ScopeRunner {
    private final Injector injector;
    private final AbstractScope scope;

    @Inject
    ScopeRunner(Injector injector, AbstractScope scope) {
        this.injector = injector;
        this.scope = scope;
    }

    public AbstractScope scope() {
        return this.scope;
    }

    public void run(Class<? extends Runnable> type) {
        if (!this.scope.inScope()) {
            throw new IllegalStateException("Not in " + this.scope);
        }
        Runnable r = (Runnable)this.injector.getInstance(type);
        r.run();
    }

    public <T> T call(Class<? extends Callable<T>> type) throws Exception {
        if (!this.scope.inScope()) {
            throw new IllegalStateException("Not in " + this.scope);
        }
        return (T)((Callable)this.injector.getInstance(type)).call();
    }
}

