/*
 * Copyright 2010-2019 Tim Boudreau
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.netbeans.validation.api;

import java.util.List;

/**
 *
 * @author Tim Boudreau
 */
final class AndValidator<T> extends AbstractValidator<T> {
    private final List<Validator<T>> validators;
    AndValidator(Class<T> type, List<Validator<T>> initial) {
        super (type);
        validators = initial;
        assert validatorTypesMatch (initial) : "Validator type mismatch: " //NOI18N
                + validators;
    }

    @Override
    public void validate(Problems problems, String compName, T model) {
        for (Validator<T> v : validators) {
            v.validate(problems, compName, model);
        }
    }

    @Override
    public String toString() {
        return "AndValidator for " + validators;
    }

    private boolean validatorTypesMatch(List<? extends Validator<?>> validators) {
        Class<?> type = null;
        for (Validator<?> v : validators) {
            if (type == null) {
                type = v.modelType();
            } else {
                if (!type.equals(v.modelType())) {
                    return false;
                }
            }
        }
        return true;
    }
}
