/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.URLBuilder;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.preconditions.Checks;

final class GenericUrlComponent
implements URLComponent {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String value;
    private final boolean isAuthorityComponent;

    public GenericUrlComponent(String name, String value, boolean isAuthorityComponent) {
        Checks.notNull((String)"name", (Object)name);
        Checks.notNull((String)"value", (Object)value);
        this.name = name;
        this.value = value;
        this.isAuthorityComponent = isAuthorityComponent;
    }

    @Override
    public boolean isValid() {
        boolean result;
        boolean bl = result = this.value != null;
        if (result) {
            for (char c : this.value.toCharArray()) {
                if (!this.isAuthorityComponent || URLBuilder.isLetter(c) || URLBuilder.isNumber(c) || c == '.' || c == '-') continue;
                return false;
            }
        }
        return result;
    }

    @Override
    public String getComponentName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        Checks.notNull((String)"sb", (Object)sb);
        if (this.isAuthorityComponent) {
            sb.append(this.value);
        } else {
            URLBuilder.append(sb, this.value, new char[0]);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericUrlComponent other = (GenericUrlComponent)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.isAuthorityComponent == other.isAuthorityComponent;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 19 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 19 * hash + (this.isAuthorityComponent ? 1 : 0);
        return hash;
    }
}

