/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.URLBuilder;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.preconditions.Checks;
import org.netbeans.validation.localization.LocalizationSupport;

public final class Label
implements URLComponent {
    private static final long serialVersionUID = 2L;
    private final String label;
    private int cachedHashCode = -1;

    public Label(String domainPart) {
        Checks.notNull((String)"domainPart", (Object)domainPart);
        this.label = domainPart;
    }

    public boolean isEmpty() {
        return this.label.isEmpty();
    }

    public int length() {
        return this.label.length();
    }

    public String toString() {
        return this.label.toLowerCase();
    }

    public boolean isNumeric() {
        boolean result;
        int len = this.label.length();
        boolean bl = result = len > 0;
        if (result) {
            for (int i = 0; i < len && result; result &= URLBuilder.isNumber(this.label.charAt(i)), ++i) {
            }
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isHex() {
        boolean result = true;
        int len = this.label.length();
        for (int i = 0; i < len && result; result &= this.isHexNumber(this.label.charAt(i)), ++i) {
        }
        return result;
    }

    private boolean isHexNumber(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public int asInt(boolean hex) {
        try {
            if (hex) {
                if (this.label.isEmpty()) {
                    return 0;
                }
                return Integer.parseInt(this.label, 16);
            }
            return Integer.parseInt(this.label);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Deprecated
    public int asInt() {
        return this.asInt(this.isHex());
    }

    public boolean isValidIpComponent() {
        return this.isValidIpV4Component() || this.isValidIpV6Component();
    }

    public boolean isValidIpV6Component() {
        if (this.label.isEmpty()) {
            return true;
        }
        if (this.label.length() <= 4) {
            char c;
            boolean result = true;
            char[] cArray = this.label.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n && (result = this.isHexNumber(c = cArray[i])); ++i) {
            }
            return result;
        }
        return false;
    }

    public boolean isValidIpV4Component() {
        boolean result = this.isNumeric();
        if (result) {
            int comp = this.asInt(false);
            return comp >= 0 && comp <= 255;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        if (this.label.length() == 0) {
            return true;
        }
        if (this.label.length() > 63) {
            return false;
        }
        boolean ipV6 = this.isValidIpV6Component();
        int val = this.asInt(ipV6);
        if (val != -1) {
            int limit;
            int n = limit = ipV6 ? 65536 : 255;
            if (val < 0) {
                return false;
            }
            return val <= limit;
        }
        char[] chars = this.label.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '-': {
                    if (i != 0 && i != chars.length - 1) break;
                    return false;
                }
                case '.': {
                    return false;
                }
            }
            boolean number = URLBuilder.isNumber(c);
            boolean letter = URLBuilder.isLetter(c);
            if (number || letter) continue;
            switch (c) {
                case '-': {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(Label.class, (String)"label", (Object[])new Object[0]);
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Label other = (Label)obj;
        if (this.label.equals(other.label)) {
            return true;
        }
        if (this.isValidIpV4Component() && other.isValidIpV4Component() || this.isValidIpV6Component() && other.isValidIpV6Component()) {
            return this.asInt(true) == other.asInt(true);
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        if (this.cachedHashCode != -1) {
            return this.cachedHashCode;
        }
        if (this.isNumeric() || this.isHex()) {
            this.cachedHashCode = this.asInt(true);
            return this.cachedHashCode;
        }
        int hash = 3;
        this.cachedHashCode = hash = 59 * hash + (this.label != null ? this.toString().hashCode() : 0);
        return this.cachedHashCode;
    }
}

