/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Parameters;
import com.mastfrog.url.ParametersDelimiter;
import com.mastfrog.url.ParametersElement;
import com.mastfrog.url.URLBuilder;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.builder.AbstractBuilder;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.validation.localization.LocalizationSupport;

public final class ParsedParameters
extends Parameters
implements URLComponent,
Iterable<ParametersElement> {
    private static final long serialVersionUID = 1L;
    private final ParametersElement[] elements;
    private final ParametersDelimiter delimiter;

    public ParsedParameters(ParametersElement ... elements) {
        this(ParametersDelimiter.AMPERSAND, elements);
    }

    public ParsedParameters(ParametersDelimiter delimiter, ParametersElement ... elements) {
        Checks.notNull((String)"elements", (Object)elements);
        Checks.notNull((String)"delimiter", (Object)((Object)delimiter));
        Checks.noNullElements((String)"elements", (Object[])elements);
        this.delimiter = delimiter;
        this.elements = new ParametersElement[elements.length];
        System.arraycopy(elements, 0, this.elements, 0, elements.length);
    }

    public ParametersDelimiter getDelimiter() {
        return this.delimiter;
    }

    public String getFirst(String param) {
        Checks.notNull((String)"param", (Object)param);
        for (ParametersElement p : this.elements) {
            if (!p.getKey().equals(param)) continue;
            return p.getValue();
        }
        return null;
    }

    public String getFirstDecoded(String param) {
        String result = this.getFirst(param);
        return result == null ? null : Strings.urlDecode((String)result);
    }

    public List<String> getAll(String param) {
        ArrayList<String> result = new ArrayList<String>(this.elements.length);
        for (ParametersElement p : this.elements) {
            if (!p.getKey().equals(param)) continue;
            result.add(p.getValue());
        }
        return result;
    }

    public static Parameters parse(String queryString) {
        Checks.notNull((String)"queryString", (Object)queryString);
        if (queryString == null || queryString.length() == 0) {
            return null;
        }
        String[] parts = null;
        ParametersDelimiter delim = ParametersDelimiter.AMPERSAND;
        if (queryString.indexOf(ParametersDelimiter.AMPERSAND.charValue()) >= 0) {
            parts = queryString.split("\\" + ParametersDelimiter.SEMICOLON.charValue());
            delim = ParametersDelimiter.AMPERSAND;
        } else if (queryString.indexOf(ParametersDelimiter.SEMICOLON.charValue()) >= 0) {
            parts = queryString.split("\\" + ParametersDelimiter.SEMICOLON.charValue());
            delim = ParametersDelimiter.SEMICOLON;
        } else {
            if (queryString.startsWith("=") && queryString.length() > 1) {
                ParsedParameters result = new ParsedParameters(ParametersDelimiter.AMPERSAND, new ParametersElement(null, queryString.substring(1)));
                return result;
            }
            if (queryString.startsWith("?=") && queryString.length() > 2) {
                return new ParsedParameters(ParametersDelimiter.AMPERSAND, new ParametersElement(null, queryString.substring(2)));
            }
            String[] keyValue = queryString.split("=", 2);
            if (keyValue.length == 1) {
                return new ParsedParameters(ParametersDelimiter.AMPERSAND, new ParametersElement(keyValue[0], null));
            }
            return new ParsedParameters(ParametersDelimiter.AMPERSAND, new ParametersElement(keyValue[0], keyValue[1]));
        }
        ParametersElement[] els = new ParametersElement[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            els[i] = ParametersElement.parse(part);
        }
        ParsedParameters result = new ParsedParameters(delim, els);
        if (!result.unescaped().equals('?' + queryString)) {
            return new Parameters(queryString);
        }
        return result;
    }

    public ParametersElement[] getElements() {
        ParametersElement[] result = new ParametersElement[this.elements.length];
        System.arraycopy(this.elements, 0, result, 0, this.elements.length);
        return result;
    }

    public int size() {
        return this.elements.length;
    }

    public String unescaped() {
        String s = this.toString(this.delimiter);
        return URLBuilder.unescape(s);
    }

    public String toString() {
        return this.toString(this.delimiter);
    }

    public String toString(ParametersDelimiter delimiter) {
        Checks.notNull((String)"delimiter", (Object)((Object)delimiter));
        if (this.elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb, delimiter);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (ParametersElement el : this.elements) {
            if (el.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(Parameters.class, (String)"parameters", (Object[])new Object[0]);
    }

    @Override
    public void appendTo(StringBuilder sb) {
        Checks.notNull((String)"sb", (Object)sb);
        this.appendTo(sb, this.getDelimiter());
    }

    public void appendTo(StringBuilder sb, ParametersDelimiter delimiter) {
        Checks.notNull((String)"delimiter", (Object)((Object)delimiter));
        Checks.notNull((String)"sb", (Object)sb);
        sb.append('?');
        int max = this.elements.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                sb.append(delimiter.charValue());
            }
            if (this.elements[i] == ParametersElement.EMPTY) {
                sb.append(delimiter.charValue());
                continue;
            }
            this.elements[i].appendTo(sb);
        }
    }

    public static AbstractBuilder<ParametersElement, Parameters> builder() {
        return new QueryBuilder();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParsedParameters other = (ParsedParameters)obj;
        return Arrays.deepEquals(this.elements, other.elements);
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Arrays.deepHashCode(this.elements);
        return hash;
    }

    @Override
    public Iterator<ParametersElement> iterator() {
        return CollectionUtils.toIterator((Object[])this.elements);
    }

    private static class QueryBuilder
    extends AbstractBuilder<ParametersElement, Parameters> {
        private QueryBuilder() {
        }

        @Override
        public Parameters create() {
            List l = this.elements();
            Collections.sort(l);
            ParametersElement[] qe = l.toArray(new ParametersElement[l.size()]);
            return new ParsedParameters(qe);
        }

        @Override
        protected ParametersElement createElement(String string) {
            int ix = string.indexOf(61);
            if (ix > 0) {
                String key = string.substring(0, ix);
                String value = string.substring(ix);
                return new ParametersElement(key, value);
            }
            if (ix == 0) {
                return new ParametersElement(null, string.substring(1));
            }
            if (ix < 0) {
                return new ParametersElement(string, null);
            }
            return null;
        }
    }
}

