/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.PathElement;
import com.mastfrog.url.URLComponent;
import com.mastfrog.util.builder.AbstractBuilder;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.validation.localization.LocalizationSupport;

public final class Path
implements URLComponent,
Iterable<PathElement> {
    private static final long serialVersionUID = 1L;
    private final PathElement[] elements;
    private final boolean illegal;
    static final Pattern PATH_PATTERN = Pattern.compile("/([$.]*?)");

    public Path(PathElement ... elements) {
        Checks.notNull((String)"elements", (Object)elements);
        this.elements = new PathElement[elements.length];
        System.arraycopy(elements, 0, this.elements, 0, elements.length);
        this.illegal = this.normalizePath().illegal;
    }

    Path(NormalizeResult n) {
        Checks.notNull((String)"n", (Object)n);
        this.illegal = n.illegal;
        this.elements = this.illegal ? n.original : n.elements.toArray(new PathElement[n.elements.size()]);
    }

    public static Path parse(String path) {
        return Path.parse(path, false);
    }

    public static Path parse(String path, boolean decode) {
        Checks.notNull((String)"path", (Object)path);
        ArrayList<PathElement> l = new ArrayList<PathElement>(12);
        char[] ch = path.toCharArray();
        StringBuilder sb = new StringBuilder();
        try {
            block5: for (int i = 0; i < ch.length; ++i) {
                char c = ch[i];
                switch (c) {
                    case '/': {
                        if (i == 0) continue block5;
                        if (i == ch.length - 1) {
                            if (decode) {
                                l.add(new PathElement(URLDecoder.decode(sb.toString(), "UTF-8"), true, decode));
                            } else {
                                l.add(new PathElement(sb.toString(), true));
                            }
                        } else if (decode) {
                            l.add(new PathElement(URLDecoder.decode(sb.toString(), "UTF-8"), false, decode));
                        } else {
                            l.add(new PathElement(sb.toString(), false));
                        }
                        sb.setLength(0);
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (sb.length() > 0) {
                if (decode) {
                    l.add(new PathElement(URLDecoder.decode(sb.toString(), "UTF-8"), false, decode));
                } else {
                    l.add(new PathElement(sb.toString(), false));
                }
            }
            if (!l.isEmpty() && path.endsWith("/")) {
                PathElement el = (PathElement)l.get(l.size() - 1);
                l.set(l.size() - 1, el.toTrailingSlashElement());
            }
        }
        catch (UnsupportedEncodingException e) {
            return (Path)Exceptions.chuck((Throwable)e);
        }
        return new Path(l.toArray(new PathElement[l.size()]));
    }

    public Path toURLDecodedPath() {
        ArrayList<PathElement> el = new ArrayList<PathElement>(this.size());
        for (PathElement p : this) {
            try {
                el.add(new PathElement(URLDecoder.decode(p.toString(), "UTF-8"), true));
            }
            catch (UnsupportedEncodingException ex) {
                return (Path)Exceptions.chuck((Throwable)ex);
            }
        }
        Path result = new Path(el.toArray(new PathElement[this.size()]));
        return result.equals(this) ? this : result;
    }

    @Override
    public Iterator<PathElement> iterator() {
        return CollectionUtils.toIterator((Object[])this.elements);
    }

    public PathElement lastElement() {
        return this.elements.length == 0 ? new PathElement("") : this.elements[this.elements.length - 1];
    }

    public Path normalize() {
        return new Path(this.normalizePath());
    }

    public Path replace(String old, String nue) {
        PathElement[] els = this.getElements();
        for (int i = 0; i < els.length; ++i) {
            PathElement nu;
            if (!els[i].toNonTrailingSlashElement().toString().equals(old)) continue;
            boolean hadTrailingSlash = !els[i].toString().equals(els[i].toNonTrailingSlashElement().toString());
            els[i] = nu = new PathElement(nue, hadTrailingSlash);
        }
        return new Path(els);
    }

    public final Path elideEmptyElements() {
        boolean returnSelf = true;
        block7: for (int i = 0; i < this.elements.length; ++i) {
            PathElement[] raw = this.elements[i].rawText();
            if (raw.isEmpty()) {
                returnSelf = false;
                break;
            }
            switch (raw) {
                case ".": 
                case "..": {
                    returnSelf = false;
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        if (returnSelf) {
            return this;
        }
        ArrayList<PathElement> result = new ArrayList<PathElement>(this.size());
        boolean illegal = false;
        for (PathElement e : this.elements) {
            if (e.rawText().isEmpty() || ".".equals(e.rawText())) continue;
            if ("..".equals(e.rawText())) {
                if (result.size() > 0) {
                    result.remove(result.size() - 1);
                    if (result.size() <= 0) continue;
                    result.set(result.size() - 1, ((PathElement)result.get(result.size() - 1)).toTrailingSlashElement());
                    continue;
                }
                illegal = true;
            }
            result.add(e);
        }
        return new Path(result.toArray(new PathElement[result.size()]));
    }

    NormalizeResult normalizePath() {
        ArrayList<PathElement> result = new ArrayList<PathElement>(this.size());
        boolean illegal = false;
        for (PathElement e : this.elements) {
            if (".".equals(e.rawText())) continue;
            if ("..".equals(e.rawText())) {
                if (result.size() > 0) {
                    result.remove(result.size() - 1);
                    if (result.size() <= 0) continue;
                    result.set(result.size() - 1, ((PathElement)result.get(result.size() - 1)).toTrailingSlashElement());
                    continue;
                }
                illegal = true;
            }
            result.add(e);
        }
        NormalizeResult res = new NormalizeResult(result, this.elements, illegal);
        return res;
    }

    public Path prepend(String part) {
        return Path.merge(Path.parse(part), this);
    }

    public Path append(String part) {
        return Path.merge(this, Path.parse(part));
    }

    public static Path merge(Path ... paths) {
        Checks.notEmptyOrNull((String)"paths", (Object)paths);
        ArrayList<PathElement> l = new ArrayList<PathElement>(paths.length * 10);
        for (Path p : paths) {
            l.addAll(Arrays.asList(p.getElements()));
        }
        return new Path(l.toArray(new PathElement[l.size()]));
    }

    public boolean isParentOf(Path path) {
        Checks.notNull((String)"path", (Object)path);
        return path.toString().startsWith(this.toString());
    }

    public boolean isChildOf(Path path) {
        Checks.notNull((String)"path", (Object)path);
        return path.isParentOf(this);
    }

    public int size() {
        return this.elements.length;
    }

    public PathElement[] getElements() {
        PathElement[] result = new PathElement[this.elements.length];
        System.arraycopy(this.elements, 0, result, 0, this.elements.length);
        return result;
    }

    public Path getChildPath() {
        if (this.elements.length > 1) {
            PathElement[] els = new PathElement[this.elements.length - 1];
            System.arraycopy(this.elements, 1, els, 0, els.length);
            return new Path(els);
        }
        return null;
    }

    public String toStringWithLeadingSlash() {
        StringBuilder result = new StringBuilder();
        this.appendTo(result);
        if (result.length() == 0) {
            return "/";
        }
        if (result.charAt(0) != '/') {
            result.insert(0, '/');
        }
        return result.toString();
    }

    public Path getParentPath() {
        if (this.elements.length > 1) {
            PathElement[] els = new PathElement[this.elements.length - 1];
            System.arraycopy(this.elements, 0, els, 0, els.length);
            return new Path(els);
        }
        return null;
    }

    public boolean lastElementMatches(CharSequence s) {
        return this.lastElementMatches(s, false);
    }

    public boolean lastElementMatches(CharSequence s, boolean ignoreCase) {
        if (this.elements.length == 0) {
            return false;
        }
        return Strings.charSequencesEqual((CharSequence)s, (CharSequence)this.elements[this.elements.length - 1].toString(), (boolean)ignoreCase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    public static AbstractBuilder<PathElement, Path> builder() {
        return new PathBuilder();
    }

    boolean isIllegal() {
        return this.illegal;
    }

    @Override
    public boolean isValid() {
        if (this.illegal) {
            return false;
        }
        for (PathElement e : this.elements) {
            if (e.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(Path.class, (String)"path", (Object[])new Object[0]);
    }

    public boolean isProbableFileReference() {
        return this.elements.length == 0 ? false : this.elements[this.elements.length - 1].isProbableFileReference();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        Checks.notNull((String)"sb", (Object)sb);
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            this.elements[i].appendTo(sb, i == this.elements.length - 1);
        }
    }

    public PathElement getElement(int ix) {
        Checks.nonNegative((String)"ix", (int)ix);
        return this.elements[ix];
    }

    public PathElement getLastElement() {
        if (this.elements.length > 0) {
            PathElement last = this.elements[this.elements.length - 1];
            return last.toNonTrailingSlashElement();
        }
        return new PathElement("", true);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Arrays.deepHashCode(this.elements);
        return hash;
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException ex) {
            return (URI)Exceptions.chuck((Throwable)ex);
        }
    }

    public URI toURIWithLeadingSlash() {
        try {
            return new URI(this.toStringWithLeadingSlash());
        }
        catch (URISyntaxException ex) {
            return (URI)Exceptions.chuck((Throwable)ex);
        }
    }

    public String[] toStringArray() {
        String[] result = new String[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getElement(i).toString();
        }
        return result;
    }

    static final class NormalizeResult {
        private final List<PathElement> elements;
        private final boolean illegal;
        private final PathElement[] original;

        public NormalizeResult(List<PathElement> elements, PathElement[] original, boolean illegal) {
            Checks.notNull((String)"original", (Object)original);
            Checks.notNull((String)"elements", elements);
            this.original = new PathElement[original.length];
            System.arraycopy(original, 0, this.original, 0, original.length);
            this.elements = elements;
            this.illegal = illegal;
        }
    }

    private static final class PathBuilder
    extends AbstractBuilder<PathElement, Path> {
        private PathBuilder() {
        }

        @Override
        public Path create() {
            PathElement[] elements = new PathElement[this.size()];
            elements = this.elements().toArray(elements);
            return new Path(elements);
        }

        @Override
        protected PathElement createElement(String element) {
            Checks.notNull((String)"string", (Object)element);
            return new PathElement(element, false);
        }

        protected PathElement createElementWithTrailingSlash(String element) {
            Checks.notNull((String)"string", (Object)element);
            return new PathElement(element, true);
        }
    }
}

