/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.URLComponent;
import org.netbeans.validation.localization.LocalizationSupport;

public final class Port
implements URLComponent {
    private static final long serialVersionUID = 1L;
    private final short port;
    private boolean valid;

    public Port(int port) {
        this.port = (short)(port + Short.MIN_VALUE);
        this.valid = true;
    }

    public Port(String port) {
        int portValue;
        try {
            portValue = Integer.parseInt(port) + Short.MIN_VALUE;
            this.valid = true;
        }
        catch (NumberFormatException nfe) {
            portValue = Short.MIN_VALUE;
            this.valid = false;
        }
        this.port = (short)portValue;
    }

    boolean isIllegalChars() {
        return !this.valid;
    }

    public int intValue() {
        return this.valid ? this.port + Short.MAX_VALUE + 1 : -1;
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    @Override
    public boolean isValid() {
        if (this.valid) {
            int val = this.intValue();
            return val > 0 && val < 65536;
        }
        return false;
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(Port.class, (String)"port", (Object[])new Object[0]);
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.intValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof Port && ((Port)obj).intValue() == this.intValue();
    }

    public int hashCode() {
        return this.port;
    }
}

