/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Port;
import com.mastfrog.url.Protocols;
import com.mastfrog.url.URLComponent;

public interface Protocol
extends URLComponent {
    public static final Protocol INVALID = new Protocol(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return "invalid_protocol";
        }

        @Override
        public Port getDefaultPort() {
            return new Port(0);
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public boolean match(String protocol) {
            return this.getName().equals(protocol);
        }

        @Override
        public boolean isKnownProtocol() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public String getComponentName() {
            return Protocols.HTTP.getComponentName();
        }

        @Override
        public void appendTo(StringBuilder sb) {
            sb.append("invalid");
        }

        @Override
        public boolean isNetworkProtocol() {
            return true;
        }

        @Override
        public boolean isSecureVersionOf(Protocol other) {
            return false;
        }

        @Override
        public boolean isInsecureVersionOf(Protocol other) {
            return false;
        }
    };

    public String getName();

    public Port getDefaultPort();

    public boolean isSecure();

    public boolean match(String var1);

    public boolean isKnownProtocol();

    public boolean isNetworkProtocol();

    public boolean isSecureVersionOf(Protocol var1);

    public boolean isInsecureVersionOf(Protocol var1);
}

