/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.url;

import com.mastfrog.url.Port;
import com.mastfrog.url.Protocol;
import com.mastfrog.url.URLBuilder;
import com.mastfrog.util.preconditions.Checks;
import org.netbeans.validation.localization.LocalizationSupport;

public enum Protocols implements Protocol
{
    HTTP,
    HTTPS,
    FTP,
    FILE,
    WS,
    WSS;


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public Port getDefaultPort() {
        switch (this) {
            case HTTP: 
            case WS: {
                return new Port(80);
            }
            case WSS: 
            case HTTPS: {
                return new Port(443);
            }
            case FTP: {
                return new Port(21);
            }
        }
        return null;
    }

    @Override
    public boolean isSecure() {
        return this == HTTPS;
    }

    public boolean match(Protocol protocol) {
        return protocol != null && protocol.getName().toLowerCase().equals(this.getName());
    }

    @Override
    public boolean match(String protocol) {
        Checks.notNull((String)"protocol", (Object)protocol);
        return this.name().compareToIgnoreCase(protocol) == 0;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static Protocol forName(String name) {
        for (Protocols p : Protocols.values()) {
            if (!p.match(name)) continue;
            return p;
        }
        return name == null ? null : new GenericProtocol(name);
    }

    @Override
    public boolean isKnownProtocol() {
        return true;
    }

    @Override
    public String getComponentName() {
        return LocalizationSupport.getMessage(Protocols.class, (String)"protocol", (Object[])new Object[0]);
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public boolean isNetworkProtocol() {
        return this != FILE;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    @Override
    public boolean isSecureVersionOf(Protocol other) {
        return this == HTTPS && "http".equals(other.getName().toLowerCase());
    }

    @Override
    public boolean isInsecureVersionOf(Protocol other) {
        return this == HTTP && "https".equals(other.getName().toLowerCase());
    }

    private static final class GenericProtocol
    implements Protocol {
        private static final long serialVersionUID = 1L;
        private final String name;

        GenericProtocol(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name.toLowerCase();
        }

        @Override
        public Port getDefaultPort() {
            return new Port(-1);
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public boolean match(String protocol) {
            return this.name.equalsIgnoreCase(protocol);
        }

        @Override
        public boolean isKnownProtocol() {
            return false;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o instanceof Protocol ? ((Protocol)o).getName().equals(this.getName()) : false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean isValid() {
            char[] chars = this.name.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (i == 0 && !URLBuilder.isLetter(c)) {
                    return false;
                }
                if (URLBuilder.isLetter(c) || URLBuilder.isNumber(c) || c == '+' || c == '-') continue;
                return false;
            }
            return true;
        }

        @Override
        public String getComponentName() {
            return "protocol";
        }

        @Override
        public void appendTo(StringBuilder sb) {
            sb.append(this.getName());
        }

        @Override
        public boolean isNetworkProtocol() {
            return true;
        }

        @Override
        public boolean isSecureVersionOf(Protocol other) {
            return false;
        }

        @Override
        public boolean isInsecureVersionOf(Protocol other) {
            return false;
        }
    }
}

