/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.fileformat;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public final class PropertiesFileUtils {
    private static final char[] ESCAPED_SPACE = "\\ ".toCharArray();
    private static final int[] NIBBLES = new int[]{12, 8, 4, 0};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private PropertiesFileUtils() {
    }

    public static final void savePropertiesFile(Properties props, OutputStream out, String comment, boolean close) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(keys);
        ArrayList<String> lines = new ArrayList<String>();
        if (comment != null) {
            lines.add("# " + comment);
        }
        for (String key : keys) {
            String val = props.getProperty(key);
            key = PropertiesFileUtils.convert(key, true);
            val = PropertiesFileUtils.convert(val, false);
            lines.add(key + "=" + val);
        }
        PropertiesFileUtils.printLines(lines, out, StandardCharsets.ISO_8859_1, close);
    }

    private static String convert(String keyVal, boolean escapeSpace) {
        int len = keyVal.length();
        StringBuilder sb = new StringBuilder(len * 2 < 0 ? Integer.MAX_VALUE : len * 2);
        block8: for (int i = 0; i < len; ++i) {
            char ch = keyVal.charAt(i);
            if (ch > '=' && ch < '\u007f') {
                if (ch == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case ' ': {
                    sb.append((Object)(escapeSpace ? ESCAPED_SPACE : (char[])Character.valueOf(' ')));
                    continue block8;
                }
                case '\n': {
                    PropertiesFileUtils.appendEscaped('n', sb);
                    continue block8;
                }
                case '\r': {
                    PropertiesFileUtils.appendEscaped('r', sb);
                    continue block8;
                }
                case '\t': {
                    PropertiesFileUtils.appendEscaped('t', sb);
                    continue block8;
                }
                case '\f': {
                    PropertiesFileUtils.appendEscaped('f', sb);
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    sb.append('\\').append(ch);
                    continue block8;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        PropertiesFileUtils.appendEscapedHex(ch, sb);
                        continue block8;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static void appendEscaped(char c, StringBuilder sb) {
        sb.append('\\').append(c);
    }

    private static void appendEscapedHex(char c, StringBuilder sb) {
        sb.append('\\').append('u');
        for (int i : NIBBLES) {
            char hex = HEX[c >> i & 0xF];
            sb.append(hex);
        }
    }

    public static int printLines(Iterable<String> lines, OutputStream out, boolean close) throws IOException {
        return PropertiesFileUtils.printLines(lines, out, StandardCharsets.UTF_8, close);
    }

    public static int printLines(Iterable<String> lines, OutputStream out, Charset encoding, boolean close) throws IOException {
        int count = 0;
        for (String line : lines) {
            byte[] bytes = line.getBytes(encoding);
            out.write(bytes);
            out.write(10);
            ++count;
        }
        if (close) {
            out.close();
        }
        return count;
    }
}

