/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.fileformat;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleJSON {
    static final DateTimeFormatter ISO_INSTANT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant().toFormatter(Locale.US);
    private static final DecimalFormat FLOATING_POINT = new DecimalFormat("###############0.0#############");
    private static final ZoneId GMT = ZoneId.of("GMT");

    private SimpleJSON() {
    }

    public static String stringify(Object o) {
        return SimpleJSON.stringify(o, Style.MINIFIED);
    }

    public static String stringify(Object o, Style style) {
        try {
            return SimpleJSON.write(o, new StringBuilder(), 0, style).toString();
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleJSON.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static StringBuilder stringifyInto(Object o, StringBuilder sb, Style style) {
        try {
            return SimpleJSON.stringifyInto(o, sb, style);
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleJSON.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static <A extends Appendable> A stringifyInto(Object o, A appendable, Style style) throws IOException {
        return SimpleJSON.write(o, appendable, 0, style);
    }

    public static boolean canDefinitelySerialize(Object o) {
        if (o == null) {
            return true;
        }
        boolean result = o instanceof Integer || o instanceof CharSequence || o instanceof Long || o instanceof Boolean || o instanceof Double || o instanceof Float || o instanceof Short || o instanceof Character || o instanceof Byte || o instanceof byte[] || o instanceof int[] || o instanceof short[] || o instanceof String[] || o instanceof char[] || o instanceof long[] || o instanceof float[] || o instanceof double[] || o instanceof boolean[] || o instanceof ZonedDateTime || o instanceof LocalDateTime || o instanceof Instant || o instanceof OffsetDateTime || o instanceof Duration || o instanceof IntSupplier || o instanceof DoubleSupplier || o instanceof LongSupplier || o instanceof BooleanSupplier || o instanceof AtomicLong || o instanceof AtomicInteger || o instanceof ZoneId || o instanceof ZoneOffset || o instanceof Locale || o instanceof Enum || o instanceof InetAddress || o instanceof InetSocketAddress || o instanceof URL || o instanceof UUID || o instanceof File || o instanceof Path || o instanceof BigInteger || o instanceof BigDecimal || o instanceof Class || o instanceof Package || o instanceof Throwable;
        return result;
    }

    private static <A extends Appendable> A write(Object o, A sb, int depth, Style style) throws IOException {
        if (o == null) {
            sb.append("null");
        } else if (o instanceof Integer || o instanceof Long || o instanceof Short || o instanceof Byte) {
            sb.append(Long.toString(((Number)o).longValue()));
        } else if (o instanceof Double || o instanceof Float) {
            double d = ((Number)o).doubleValue();
            sb.append(FLOATING_POINT.format(d));
        } else if (o instanceof Boolean) {
            sb.append(Boolean.toString((Boolean)o));
        } else if (o instanceof Character) {
            SimpleJSON.delimit('\"', sb, () -> sb.append(((Character)o).charValue()));
        } else if (o instanceof char[]) {
            SimpleJSON.write(new String((char[])o), sb, depth, style);
        } else if (o instanceof byte[]) {
            String s = Base64.getEncoder().encodeToString((byte[])o);
            SimpleJSON.write(s, sb, depth, style);
        } else if (o instanceof CharSequence) {
            SimpleJSON.delimit('\"', sb, () -> SimpleJSON.escape((CharSequence)o, sb));
        } else if (o instanceof Date) {
            ZonedDateTime ldt = Instant.ofEpochMilli(((Date)o).getTime()).atZone(GMT);
            SimpleJSON.write(ldt, sb, depth, style);
        } else if (o instanceof OffsetDateTime) {
            SimpleJSON.delimit('\"', sb, () -> sb.append(((OffsetDateTime)o).format(ISO_INSTANT)));
        } else if (o instanceof ZonedDateTime) {
            SimpleJSON.delimit('\"', sb, () -> sb.append(((ZonedDateTime)o).format(ISO_INSTANT)));
        } else if (o instanceof Instant) {
            SimpleJSON.stringify(((Instant)o).atZone(GMT));
        } else if (o instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)o;
            SimpleJSON.write(ldt.toInstant(ZoneId.systemDefault().getRules().getOffset(Instant.now())), sb, depth, style);
        } else if (o instanceof Duration) {
            SimpleJSON.delimit('\"', sb, () -> sb.append(o.toString()));
        } else if (o instanceof List) {
            if (((List)o).isEmpty()) {
                sb.append("[]");
            } else {
                SimpleJSON.writeList((List)o, sb, depth, style);
            }
        } else if (o instanceof Collection) {
            if (((Collection)o).isEmpty()) {
                sb.append("[]");
            } else {
                SimpleJSON.writeList((Collection)o, sb, depth, style);
            }
        } else if (o instanceof Map) {
            if (((Map)o).isEmpty()) {
                sb.append("{}");
            } else {
                SimpleJSON.writeMap((Map)o, sb, depth, style);
            }
        } else if (o instanceof Enum) {
            SimpleJSON.write(((Enum)o).name(), sb, depth, style);
        } else if (o.getClass().isArray()) {
            int max = Array.getLength(o);
            if (max == 0) {
                sb.append("[]");
            } else {
                ArrayList<Object> l = new ArrayList<Object>(max);
                for (int i = 0; i < max; ++i) {
                    Object item = Array.get(o, i);
                    l.add(item);
                }
                SimpleJSON.write(l, sb, depth, style);
            }
        } else if (o instanceof Reference) {
            SimpleJSON.write(((Reference)o).get(), sb, depth, style);
        } else if (o instanceof Optional) {
            Optional opt = (Optional)o;
            if (opt.isPresent()) {
                SimpleJSON.write(opt.get(), sb, depth, style);
            } else {
                SimpleJSON.write(null, sb, depth, style);
            }
        } else if (o instanceof IntSupplier) {
            SimpleJSON.appendInt(((IntSupplier)o).getAsInt(), sb);
        } else if (o instanceof LongSupplier) {
            SimpleJSON.appendLong(((LongSupplier)o).getAsLong(), sb);
        } else if (o instanceof DoubleSupplier) {
            sb.append(FLOATING_POINT.format(((DoubleSupplier)o).getAsDouble()));
        } else if (o instanceof BooleanSupplier) {
            sb.append(((BooleanSupplier)o).getAsBoolean() ? "true" : "false");
        } else if (o instanceof Supplier) {
            SimpleJSON.write(((Supplier)o).get(), sb, depth, style);
        } else if (o instanceof AtomicReference) {
            SimpleJSON.write(((AtomicReference)o).get(), sb, depth, style);
        } else if (o instanceof AtomicInteger) {
            SimpleJSON.write(((AtomicInteger)o).get(), sb, depth, style);
        } else if (o instanceof AtomicLong) {
            SimpleJSON.write(((AtomicLong)o).get(), sb, depth, style);
        } else if (o instanceof InetAddress) {
            sb.append(((InetAddress)o).getHostAddress());
        } else if (o instanceof InetSocketAddress) {
            sb.append(((InetSocketAddress)o).getHostString()).append(':');
            SimpleJSON.appendInt(((InetSocketAddress)o).getPort(), sb);
        } else if (o instanceof URL) {
            sb.append(((URL)o).toExternalForm());
        } else if (o instanceof Locale) {
            sb.append(((Locale)o).getDisplayName());
        } else if (o instanceof ZoneId) {
            sb.append(((ZoneId)o).getId());
        } else if (o instanceof ZoneOffset) {
            sb.append(((ZoneOffset)o).getId());
        } else if (o instanceof UUID) {
            sb.append(((UUID)o).toString());
        } else if (o instanceof File) {
            sb.append(((File)o).getAbsolutePath());
        } else if (o instanceof Path) {
            sb.append(((Path)o).toString());
        } else if (o instanceof BigInteger) {
            SimpleJSON.delimit('\"', sb, () -> sb.append(o.toString()));
        } else if (o instanceof BigDecimal) {
            SimpleJSON.delimit('\"', sb, () -> sb.append(o.toString()));
        } else if (o instanceof Throwable) {
            SimpleJSON.write(SimpleJSON.mapifyThrowable((Throwable)o), sb, depth, style);
        } else if (o instanceof Class) {
            SimpleJSON.write(((Class)o).getName(), sb, depth, style);
        } else if (o instanceof Package) {
            SimpleJSON.write(((Package)o).getName(), sb, depth, style);
        } else if (o instanceof Throwable) {
            LinkedHashMap<String, String> t = new LinkedHashMap<String, String>();
            t.put("type", o.getClass().getName());
            t.put("message", ((Throwable)o).getMessage());
            SimpleJSON.write(t, sb, depth, style);
        } else {
            SimpleJSON.write(SimpleJSON.mapify(o), sb, depth, style);
        }
        return sb;
    }

    private static Map<String, Object> mapifyThrowable(Throwable thrown) {
        return SimpleJSON.mapifyThrowable(thrown, new HashSet<StackTraceElement>());
    }

    private static Map<String, Object> mapifyThrowable(Throwable thrown, Set<StackTraceElement> seen) {
        Throwable[] addtl;
        StackTraceElement[] els;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("type", thrown.getClass().getName());
        if (thrown.getMessage() != null) {
            result.put("message", thrown.getMessage());
        }
        if ((els = thrown.getStackTrace()) != null && els.length > 0) {
            ArrayList stack = new ArrayList(els.length);
            result.put("stack", stack);
            for (int i = 0; i < els.length && !seen.contains(els[i]); ++i) {
                LinkedHashMap<String, Object> frame = new LinkedHashMap<String, Object>();
                StackTraceElement el = els[i];
                frame.put("class", el.getClassName());
                frame.put("file", el.getFileName());
                frame.put("line", el.getLineNumber());
                frame.put("method", el.getMethodName());
                stack.add(frame);
            }
        }
        if (thrown.getCause() != null) {
            result.put("cause", SimpleJSON.mapifyThrowable(thrown.getCause()));
        }
        if ((addtl = thrown.getSuppressed()) != null && addtl.length > 0) {
            ArrayList<Map<String, Object>> suppressed = new ArrayList<Map<String, Object>>(addtl.length);
            for (Throwable supp : addtl) {
                suppressed.add(SimpleJSON.mapifyThrowable(supp, seen));
            }
        }
        return result;
    }

    private static Map<String, Object> mapify(Object o) {
        Class<?> type = o.getClass();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getFields()));
        Collections.sort(fields, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        for (Field field : fields) {
            int mods = field.getModifiers();
            if ((mods & 8) != 0 || (mods & 1) != 1) continue;
            try {
                result.put(field.getName(), field.get(o));
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(SimpleJSON.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(SimpleJSON.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private static <A extends Appendable> A appendInt(int val, A a) throws IOException {
        if (a instanceof StringBuilder) {
            ((StringBuilder)a).append(val);
        } else {
            if (val < 0) {
                a.append('-');
            } else if (val == 0) {
                a.append('0');
                return a;
            }
            while (val != 0) {
                a.append((char)(48 + val % 10));
                val /= 10;
            }
        }
        return a;
    }

    private static <A extends Appendable> A appendLong(long val, A a) throws IOException {
        if (a instanceof StringBuilder) {
            ((StringBuilder)a).append(val);
        } else {
            if (val < 0L) {
                a.append('-');
            } else if (val == 0L) {
                a.append('0');
                return a;
            }
            while (val != 0L) {
                a.append((char)(48L + val % 10L));
                val /= 10L;
            }
        }
        return a;
    }

    private static <A extends Appendable> A appendCharArray(char[] chars, A a) throws IOException {
        if (a instanceof StringBuilder) {
            ((StringBuilder)a).append(chars);
        } else {
            for (int i = 0; i < chars.length; ++i) {
                a.append(chars[i]);
            }
        }
        return a;
    }

    private static <A extends Appendable> void writeList(final Iterable<?> list, final A sb, final int depth, final Style style) throws IOException {
        final char[] pad = style.newLinePad(depth);
        SimpleJSON.delimit('[', ']', sb, new IORunnable(){

            @Override
            public void run() throws IOException {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    SimpleJSON.appendCharArray(pad, sb);
                    SimpleJSON.write(o, sb, depth + 1, style);
                    if (it.hasNext()) {
                        SimpleJSON.appendCharArray(style.comma(), sb);
                        continue;
                    }
                    if (style != Style.PRETTY) continue;
                    SimpleJSON.appendCharArray(pad, sb);
                }
            }
        });
    }

    private static <A extends Appendable> void writeMap(Map<?, ?> map, A sb, int depth, Style style) throws IOException {
        char[] pad = style.newLinePad(depth);
        SimpleJSON.delimit('{', '}', sb, () -> {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                SimpleJSON.appendCharArray(pad, sb);
                if (!(e.getKey() instanceof CharSequence)) {
                    SimpleJSON.delimit('\"', sb, () -> SimpleJSON.write(e.getKey(), sb, depth + 1, style));
                } else {
                    SimpleJSON.write(e.getKey(), sb, depth + 1, style);
                }
                SimpleJSON.appendCharArray(style.keyValueDelmiter(), sb);
                SimpleJSON.write(e.getValue(), sb, depth + 1, style);
                if (!it.hasNext()) continue;
                SimpleJSON.appendCharArray(style.comma(), sb);
            }
        });
    }

    private static <A extends Appendable> void escape(CharSequence orig, A into) throws IOException {
        int max = orig.length();
        block9: for (int i = 0; i < max; ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\b': {
                    into.append('\\').append('b');
                    continue block9;
                }
                case '\f': {
                    into.append('\\').append('f');
                    continue block9;
                }
                case '\n': {
                    into.append('\\').append('n');
                    continue block9;
                }
                case '\r': {
                    into.append('\\').append('r');
                    continue block9;
                }
                case '\t': {
                    into.append('\\').append('t');
                    continue block9;
                }
                case '\"': {
                    into.append('\\').append('\"');
                    continue block9;
                }
                case '\\': {
                    into.append('\\').append('\\');
                    continue block9;
                }
                default: {
                    into.append(c);
                }
            }
        }
    }

    private static <A extends Appendable> void delimit(char delimiter, A sb, IORunnable run) throws IOException {
        sb.append(delimiter);
        run.run();
        sb.append(delimiter);
    }

    private static <A extends Appendable> void delimit(char delimiterOpen, char delimiterClose, A sb, IORunnable run) throws IOException {
        sb.append(delimiterOpen);
        run.run();
        sb.append(delimiterClose);
    }

    @FunctionalInterface
    private static interface IORunnable {
        public void run() throws IOException;
    }

    public static enum Style {
        MINIFIED,
        COMPACT,
        PRETTY;

        static final char[] EMPTY;
        static final char[] SINGLE_SPACE;
        static final char[] COMMA_NO_SPACE;
        static final char[] COMMA_SPACE;
        private static final char[] COLON;
        private static final char[] COLON_SPACE;
        private static final char[] COLON_SPACES;

        boolean isSpaces() {
            return this != MINIFIED;
        }

        boolean isIndent() {
            return this == PRETTY;
        }

        char[] newLinePad(int depth) {
            switch (this) {
                case MINIFIED: {
                    return EMPTY;
                }
                case COMPACT: {
                    return SINGLE_SPACE;
                }
                case PRETTY: {
                    char[] c = new char[depth * 2 + 1];
                    Arrays.fill(c, ' ');
                    c[0] = 10;
                    return c;
                }
            }
            throw new AssertionError((Object)this);
        }

        char[] comma() {
            switch (this) {
                case MINIFIED: 
                case COMPACT: {
                    return COMMA_NO_SPACE;
                }
                case PRETTY: {
                    return COMMA_SPACE;
                }
            }
            throw new AssertionError((Object)this);
        }

        char[] keyValueDelmiter() {
            switch (this) {
                case MINIFIED: {
                    return COLON;
                }
                case COMPACT: {
                    return COLON_SPACE;
                }
                case PRETTY: {
                    return COLON_SPACES;
                }
            }
            throw new AssertionError((Object)this);
        }

        static {
            EMPTY = new char[0];
            SINGLE_SPACE = new char[]{' '};
            COMMA_NO_SPACE = new char[]{','};
            COMMA_SPACE = new char[]{',', ' '};
            COLON = new char[]{':'};
            COLON_SPACE = new char[]{':', ' '};
            COLON_SPACES = new char[]{' ', ':', ' '};
        }
    }
}

