/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.preconditions;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Exceptions {
    static final ExceptionHandler HANDLER;

    private Exceptions() {
    }

    public static void printStackTrace(String msg, Throwable t) {
        HANDLER.printStackTrace(msg, t);
    }

    public static void printStackTrace(Class<?> caller, String msg, Throwable t) {
        HANDLER.printStackTrace(caller, msg, t);
    }

    public static void printStackTrace(Class<?> caller, Throwable t) {
        HANDLER.printStackTrace(caller, t);
    }

    public static void printStackTrace(Throwable t) {
        HANDLER.printStackTrace(t);
    }

    public static <ReturnType> ReturnType chuck(Throwable t) {
        Exceptions.chuck(RuntimeException.class, t);
        throw new AssertionError((Object)t);
    }

    public static <T extends Throwable> void chuck(Class<T> type, Throwable t) throws T {
        throw t;
    }

    public static <ReturnType> ReturnType chuckUnless(Throwable t, ReturnType what, BooleanSupplier predicate) {
        if (!predicate.getAsBoolean()) {
            return Exceptions.chuck(t);
        }
        return what;
    }

    public static <ReturnType> ReturnType chuckOriginal(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        Exceptions.chuck(RuntimeException.class, t);
        throw new AssertionError((Object)t);
    }

    static {
        Iterator<ExceptionHandler> e = ServiceLoader.load(ExceptionHandler.class).iterator();
        HANDLER = e.hasNext() ? e.next() : new DefaultExceptionHandler();
    }

    public static interface ExceptionHandler {
        default public void printStackTrace(String msg, Throwable t) {
            Logger.getLogger(Exceptions.class.getName()).log(Level.SEVERE, msg, t);
        }

        default public void printStackTrace(Class<?> caller, String msg, Throwable t) {
            Logger.getLogger(caller.getName()).log(Level.SEVERE, msg, t);
        }

        default public void printStackTrace(Class<?> caller, Throwable t) {
            Logger.getLogger(caller.getName()).log(Level.SEVERE, null, t);
        }

        default public void printStackTrace(Throwable t) {
            Logger.getLogger(Exceptions.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private static final class DefaultExceptionHandler
    implements ExceptionHandler {
        private DefaultExceptionHandler() {
        }
    }
}

