/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.file;

import com.mastfrog.function.throwing.io.IOFunction;
import com.mastfrog.util.file.WatchManager;
import com.mastfrog.util.streams.ContinuousLineStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Tail
implements IOFunction<Predicate<CharSequence>, Runnable> {
    private final WatchManager mgr;
    private final Path path;
    private final int bufferSize;
    private final Charset charset;

    Tail(Path path, int bufferSize, Charset charset) throws IOException {
        this(WatchManager.sharedInstance(), path, bufferSize, charset);
    }

    Tail(WatchManager mgr, Path path, int bufferSize, Charset charset) {
        this.path = path;
        this.bufferSize = bufferSize;
        this.charset = charset;
        this.mgr = mgr;
    }

    Runnable watch(Predicate<CharSequence> lineConsumer) throws IOException {
        ContinuousLineStream stream = ContinuousLineStream.of(this.path.toFile(), this.bufferSize, this.charset);
        C c = new C(this.path, stream, lineConsumer, this.mgr);
        this.mgr.watch(this.path, c, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        return c;
    }

    public Runnable apply(Predicate<CharSequence> in) throws IOException {
        return this.watch(in);
    }

    static class C
    implements BiConsumer<Path, WatchEvent.Kind<?>>,
    Runnable {
        private final Path path;
        private final ContinuousLineStream stream;
        private final Predicate<CharSequence> lineConsumer;
        private final WatchManager mgr;
        private final AtomicBoolean cancelled = new AtomicBoolean();

        public C(Path path, ContinuousLineStream stream, Predicate<CharSequence> lineConsumer, WatchManager mgr) {
            this.path = path;
            this.stream = stream;
            this.lineConsumer = lineConsumer;
            this.mgr = mgr;
        }

        @Override
        public void accept(Path t, WatchEvent.Kind<?> u) {
            if (!t.equals(this.path)) {
                new Exception(t + "").printStackTrace();
                return;
            }
            if (u == StandardWatchEventKinds.ENTRY_DELETE) {
                this.run();
                return;
            }
            try {
                while (this.stream.hasMoreLines() && !this.cancelled.get()) {
                    CharSequence line = this.stream.nextLine();
                    if (this.lineConsumer.test(line)) continue;
                    this.run();
                    return;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Tail.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void run() {
            this.cancelled.set(true);
            this.mgr.unwatch(this.path, this);
        }
    }
}

