/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import com.mastfrog.util.streams.GeneralByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class ByteArrayChannel
implements GeneralByteChannel {
    private byte[] bytes;
    private int cursor;
    private boolean closed;

    ByteArrayChannel(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] toByteArray() {
        if (this.cursor == this.bytes.length) {
            return this.bytes;
        }
        return Arrays.copyOf(this.bytes, this.cursor);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int rem = dst.remaining();
        if (rem == 0) {
            return 0;
        }
        int max = Math.min(this.bytes.length - this.cursor, rem);
        if (max <= 0) {
            return 0;
        }
        dst.put(this.bytes, this.cursor, max);
        this.cursor += max;
        return max;
    }

    @Override
    public int reset() {
        int oldCursor = this.cursor;
        this.closed = false;
        this.cursor = 0;
        return oldCursor;
    }

    @Override
    public boolean isOpen() {
        return !this.closed && this.cursor < this.bytes.length;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int amt = src.remaining();
        if (amt > 0) {
            if (this.bytes.length - this.cursor < amt) {
                this.bytes = Arrays.copyOf(this.bytes, this.cursor + amt);
            }
            src.get(this.bytes, this.cursor, amt);
            this.cursor += amt;
            return amt;
        }
        return 0;
    }

    @Override
    public long position() throws IOException {
        return this.cursor;
    }

    @Override
    public int cursorPosition() {
        return this.cursor;
    }

    @Override
    public ByteArrayChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IOException("Position < 0: " + newPosition);
        }
        if (newPosition > (long)this.bytes.length) {
            throw new IOException("Position past end: " + newPosition + " of " + this.bytes.length);
        }
        this.cursor = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.bytes.length;
    }

    @Override
    public ByteArrayChannel truncate(long size) throws IOException {
        if (size > (long)this.bytes.length) {
            return this;
        }
        this.bytes = Arrays.copyOf(this.bytes, (int)size);
        return this;
    }
}

