/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

final class ByteBufferCollectionInputStream
extends InputStream {
    private final Iterator<ByteBuffer> iter;
    private int count;
    private ByteBuffer buf;

    ByteBufferCollectionInputStream(ByteBuffer ... buffers) {
        this(Arrays.asList(buffers));
    }

    ByteBufferCollectionInputStream(Iterable<ByteBuffer> ib) {
        this.iter = ib.iterator();
        if (ib instanceof Collection) {
            this.count = ((Collection)ib).size();
        }
    }

    private ByteBuffer buf() {
        if (this.buf == null && this.iter.hasNext()) {
            this.buf = this.iter.next();
            if (this.buf.position() != 0) {
                this.buf.flip();
            }
            return this.buf;
        }
        if (this.buf != null && this.buf.position() == this.buf.limit()) {
            this.buf = null;
            return this.buf();
        }
        return this.buf;
    }

    @Override
    public int read() throws IOException {
        ByteBuffer b = this.curr();
        if (b == null) {
            return -1;
        }
        return b.get();
    }

    ByteBuffer curr() {
        ByteBuffer b = this.buf();
        if (b == null) {
            return null;
        }
        while (b != null && b.position() == b.limit()) {
            b = this.buf();
        }
        return b;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        ByteBuffer b = this.curr();
        if (b == null) {
            return -1;
        }
        int oldPos = b.position();
        b.get(bytes);
        return b.position() - oldPos;
    }

    @Override
    public int read(byte[] bytes, int offset, int len) throws IOException {
        ByteBuffer b = this.curr();
        if (b == null) {
            return -1;
        }
        int oldPos = b.position();
        int remaining = b.limit() - oldPos;
        if (remaining > 0) {
            b.get(bytes, offset, Math.min(remaining, len));
        }
        return b.position() - oldPos;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.count + " buffers finished?" + this.iter.hasNext();
    }
}

