/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class ByteBufferInputStream
extends InputStream {
    final ByteBuffer buf;

    ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        return this.buf.remaining() == 0 ? -1 : (int)this.buf.get();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buf.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public int available() throws IOException {
        return this.buf.limit() - this.buf.position();
    }

    @Override
    public long skip(long n) throws IOException {
        int pos = this.buf.position();
        int rem = this.available();
        if (n > (long)this.buf.remaining()) {
            this.buf.position(this.buf.limit());
            return rem;
        }
        int target = pos + Math.max(0, Math.min(Integer.MAX_VALUE, (int)n));
        this.buf.position(target);
        return target - pos;
    }

    @Override
    public void close() throws IOException {
        this.buf.position(this.buf.limit());
        super.close();
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        int rem = this.available();
        int remainingInArray = b.length - off;
        int lengthToRead = Math.min(remainingInArray, Math.min(rem, len));
        this.buf.get(b, off, lengthToRead);
        return lengthToRead;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        int lengthToRead = Math.min(len, this.available());
        byte[] bytes = new byte[lengthToRead];
        this.buf.get(bytes);
        return bytes;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        byte[] result = new byte[this.available()];
        this.buf.get(result);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = Math.min(this.available(), b.length);
        this.buf.get(b, 0, result);
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off + len > b.length) {
            throw new IOException("offset + length=" + (off + len) + " but array length is " + b.length);
        }
        int rem = this.available();
        if (rem == 0) {
            return -1;
        }
        int result = Math.min(len, rem);
        this.buf.get(b, off, result);
        return result;
    }
}

