/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.ContinuousStringStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ContinuousLineStream
implements AutoCloseable,
Iterator<CharSequence> {
    private final ContinuousStringStream stringStream;
    private final CharsetDecoder charsetDecoder;
    private final LinkedList<CharSequence> queuedLines = new LinkedList();
    private String cachedPartialNextLine = null;
    private final int byteCount;
    private final int maxLinesToBuffer;
    private CharBuffer lastCharBuffer;
    private static final boolean isJdk6 = "1.6".equals(System.getProperty("java.specification.version"));
    long sizeAtLastFindNext = -1L;

    public ContinuousLineStream(ContinuousStringStream stringStream, CharsetDecoder charsetDecoder, int charsPerBuffer) {
        this(stringStream, charsetDecoder, charsPerBuffer, Integer.MAX_VALUE);
    }

    public ContinuousLineStream(ContinuousStringStream stringStream, CharsetDecoder charsetDecoder, int charsPerBuffer, int maxLinesToBuffer) {
        this.maxLinesToBuffer = Checks.greaterThanOne((String)"maxLinesToBuffer", (int)maxLinesToBuffer);
        this.stringStream = (ContinuousStringStream)Checks.notNull((String)"stringStream", (Object)stringStream);
        this.charsetDecoder = (CharsetDecoder)Checks.notNull((String)"charsetDecoder", (Object)charsetDecoder);
        float bytesPerChar = Math.max(1.0f, 1.0f / charsetDecoder.averageCharsPerByte());
        this.byteCount = Math.max(512, (int)((float)charsPerBuffer * bytesPerChar));
    }

    public static ContinuousLineStream of(Path file) {
        return ContinuousLineStream.of(file.toFile());
    }

    public static ContinuousLineStream of(Path file, int bufferSize) {
        return ContinuousLineStream.of(file.toFile(), bufferSize);
    }

    public static ContinuousLineStream of(Path file, int bufferSize, Charset charset) {
        return ContinuousLineStream.of(file.toFile(), bufferSize, charset);
    }

    public static ContinuousLineStream of(File file) {
        return ContinuousLineStream.of(file, 8192);
    }

    public static ContinuousLineStream of(File file, int bufferSize) {
        return ContinuousLineStream.of(file, bufferSize, StandardCharsets.UTF_8);
    }

    public static ContinuousLineStream of(File file, int bufferSize, Charset charset) {
        try {
            Checks.nonZero((String)"bufferSize", (int)Checks.nonNegative((String)"bufferSize", (int)bufferSize));
            Checks.notNull((String)"charset", (Object)charset);
            Checks.readable((String)"file", (File)file);
            CharsetDecoder dec = charset.newDecoder();
            int charBufferSize = Math.max(2, (int)Math.ceil(dec.averageCharsPerByte() * (float)bufferSize));
            ContinuousStringStream stream = new ContinuousStringStream(new FileInputStream(file).getChannel(), bufferSize);
            CharsetDecoder decoder = charset.newDecoder();
            return new ContinuousLineStream(stream, decoder, charBufferSize);
        }
        catch (FileNotFoundException ex) {
            return (ContinuousLineStream)Exceptions.chuck((Throwable)ex);
        }
    }

    public boolean isOpen() {
        return this.stringStream.isOpen();
    }

    private void check() throws IOException {
        if (this.queuedLines.isEmpty()) {
            this.findNextLines();
        }
    }

    public synchronized boolean hasMoreLines() throws IOException {
        this.check();
        boolean result = !this.queuedLines.isEmpty();
        return result;
    }

    public synchronized CharSequence nextLine() throws IOException {
        this.check();
        return this.queuedLines.isEmpty() ? null : this.queuedLines.pop();
    }

    public long position() throws IOException {
        return this.stringStream.position();
    }

    public synchronized void position(long pos) throws IOException {
        this.stringStream.position(pos);
        this.cachedPartialNextLine = null;
        this.queuedLines.clear();
    }

    public synchronized String remainingData() {
        return this.cachedPartialNextLine;
    }

    public long available() throws IOException {
        return this.stringStream.available();
    }

    private CharBuffer readCharacters() throws IOException {
        if (this.lastCharBuffer != null && this.lastCharBuffer.position() < this.lastCharBuffer.limit()) {
            return this.lastCharBuffer;
        }
        CharBuffer characterData = this.lastCharBuffer = ByteBuffer.allocateDirect(this.byteCount).asCharBuffer();
        this.stringStream.decode(characterData, this.charsetDecoder);
        return characterData;
    }

    private static CharSequence subsequence(CharSequence string, int start, int end) {
        if (isJdk6) {
            return string.toString().subSequence(start, end);
        }
        return string.subSequence(start, end);
    }

    private synchronized void findNextLines() throws IOException {
        if (!this.stringStream.hasContent() || !this.queuedLines.isEmpty()) {
            return;
        }
        block0: while (this.queuedLines.isEmpty() && this.stringStream.hasContent()) {
            CharBuffer characterData = this.readCharacters();
            int lineStart = characterData.position();
            int limit = characterData.limit();
            int prevChar = 0;
            int charIndex = 0;
            while (characterData.remaining() > 0) {
                char c = characterData.get();
                if (c == '\n') {
                    if (charIndex == lineStart) {
                        if (this.cachedPartialNextLine != null) {
                            this.queuedLines.add(this.cachedPartialNextLine);
                            this.cachedPartialNextLine = null;
                        } else {
                            this.queuedLines.add("");
                            lineStart = charIndex + 1;
                        }
                    } else {
                        int end = Math.max(0, prevChar == 13 ? charIndex - 1 : charIndex);
                        int oldPos = characterData.position();
                        characterData.position(lineStart);
                        CharSequence currentLine = ContinuousLineStream.subsequence(characterData, 0, end - lineStart);
                        characterData.position(oldPos);
                        if (this.cachedPartialNextLine != null) {
                            this.queuedLines.add(this.cachedPartialNextLine + currentLine);
                            this.cachedPartialNextLine = null;
                        } else {
                            if (currentLine.length() > 0 && currentLine.charAt(0) == '\n') {
                                currentLine = currentLine.subSequence(1, currentLine.length());
                            }
                            this.queuedLines.add(currentLine);
                        }
                        lineStart = charIndex + 1;
                    }
                } else if (charIndex == limit - 1) {
                    int oldPos = characterData.position();
                    characterData.position(lineStart);
                    CharSequence partialLine = ContinuousLineStream.subsequence(characterData, 0, charIndex + 1 - lineStart);
                    if (partialLine.length() > 0 && partialLine.charAt(0) == '\n') {
                        partialLine = partialLine.subSequence(1, partialLine.length());
                    }
                    characterData.position(oldPos);
                    this.cachedPartialNextLine = this.cachedPartialNextLine == null ? partialLine.toString() : this.cachedPartialNextLine + partialLine.toString();
                }
                if (this.queuedLines.size() >= this.maxLinesToBuffer) continue block0;
                prevChar = c;
                ++charIndex;
            }
        }
    }

    public List<CharSequence> closeReturningTail() throws IOException {
        try {
            ArrayList<CharSequence> result = new ArrayList<CharSequence>(this.queuedLines);
            this.queuedLines.clear();
            if (this.cachedPartialNextLine != null && this.cachedPartialNextLine.length() > 0) {
                result.add(this.cachedPartialNextLine);
                this.cachedPartialNextLine = null;
            }
            ArrayList<CharSequence> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    public boolean isAtEndOfFile() throws IOException {
        return !this.isOpen() || this.stringStream.available() == 0;
    }

    @Override
    public void close() throws IOException {
        this.stringStream.close();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasMoreLines();
        }
        catch (IOException ex) {
            return (Boolean)Exceptions.chuck((Throwable)ex);
        }
    }

    @Override
    public CharSequence next() {
        try {
            return this.nextLine();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterable<CharSequence> toIterable() {
        return () -> this;
    }
}

