/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.streams.ByteArrayChannel;
import com.mastfrog.util.streams.ByteBufferCollectionInputStream;
import com.mastfrog.util.streams.ByteBufferInputStream;
import com.mastfrog.util.streams.GeneralByteChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class Streams {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public GeneralByteChannel channel(byte[] bytes) {
        return new ByteArrayChannel((byte[])Checks.notNull((String)"bytes", (Object)bytes));
    }

    public static int copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int byteCount;
        Checks.nonZero((String)"bufferSize", (int)bufferSize);
        Checks.nonNegative((String)"bufferSize", (int)bufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int byteCount;
        byte[] buffer = new byte[Streams.bufferSize(in)];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    private static int bufferSize(InputStream in) {
        int bufferSize = 4096;
        try {
            int avail = in.available();
            if (avail > 0) {
                bufferSize = Math.min(bufferSize, avail);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSize;
    }

    public static int copy(InputStream in, OutputStream out, OutputStream otherOut) throws IOException {
        int byteCount;
        byte[] buffer = new byte[Streams.bufferSize(in)];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            otherOut.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    public static String readUTF8String(InputStream in) throws IOException {
        return Streams.readString(in, StandardCharsets.UTF_8);
    }

    public static String readAsciiString(InputStream in) throws IOException {
        return Streams.readString(in, StandardCharsets.US_ASCII);
    }

    public static String readResourceAsUTF8(Class<?> relativeTo, String filename) throws IOException {
        try (InputStream in = relativeTo.getResourceAsStream(filename);){
            if (in == null) {
                String string = null;
                return string;
            }
            String string = Streams.readUTF8String(in);
            return string;
        }
    }

    public static String readString(InputStream in) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in));){
            String string = Streams.readString(r);
            return string;
        }
    }

    public static String readString(InputStream in, int bufferSize) throws IOException {
        Checks.nonNegative((String)"bufferSize", (int)bufferSize);
        try (Reader r = bufferSize <= 0 ? new InputStreamReader(in) : new BufferedReader(new InputStreamReader(in), bufferSize);){
            String string = Streams.readString(r);
            return string;
        }
    }

    public static String readString(InputStream in, String charset, int bufferSize) throws IOException {
        Checks.nonNegative((String)"bufferSize", (int)bufferSize);
        try (Reader r = bufferSize == 0 ? new InputStreamReader(in, charset) : new BufferedReader(new InputStreamReader(in, charset), bufferSize);){
            String string = Streams.readString(r);
            return string;
        }
    }

    public static String readString(InputStream in, Charset charset, int bufferSize) throws IOException {
        Checks.nonNegative((String)"bufferSize", (int)bufferSize);
        try (Reader r = bufferSize == 0 ? new InputStreamReader(in, charset) : new BufferedReader(new InputStreamReader(in, charset), bufferSize);){
            String string = Streams.readString(r);
            return string;
        }
    }

    public static String readString(InputStream in, String charset) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, Charset.forName(charset)));){
            String string = Streams.readString(r);
            return string;
        }
    }

    public static String readString(InputStream in, Charset charset) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, charset));){
            String string = Streams.readString(r);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readSql(InputStream is) {
        Checks.notNull((String)"input stream is", (Object)is);
        StringBuilder bldr = new StringBuilder();
        int bufferSize = Streams.bufferSize(is);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is), bufferSize);
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.startsWith("--")) continue;
                    bldr.append(line);
                }
            }
            finally {
                is.close();
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(bldr.toString(), ";");
        while (t.hasMoreTokens()) {
            String cmd = t.nextToken();
            l.add(cmd);
        }
        return l.toArray(new String[l.size()]);
    }

    public static String readString(InputStream in, CharSequence encoding) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, encoding.toString()), Streams.bufferSize(in));){
            String string = Streams.readString(r);
            return string;
        }
    }

    public static String readString(Reader in) throws IOException {
        int value;
        StringBuilder buffer = new StringBuilder(2048);
        while ((value = in.read()) != -1) {
            buffer.append((char)value);
        }
        return buffer.toString();
    }

    public static InputStream[] locate(String location) {
        Checks.notNull((String)"location", (Object)location);
        ArrayList<NamedInputStream> inputStreams = new ArrayList<NamedInputStream>();
        try {
            if (location.contains("://") || location.startsWith("file:/")) {
                URL url = new URL(location);
                NamedInputStream i = new NamedInputStream(url, url.openStream());
                inputStreams.add(i);
            } else {
                Enumeration i;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = Streams.class.getClassLoader();
                }
                Enumeration<Object> enumeration = i = loader == null ? Collections.emptyEnumeration() : loader.getResources(location);
                if (i == null || !i.hasMoreElements()) {
                    Enumeration<Object> enumeration2 = i = loader == null ? Collections.emptyEnumeration() : loader.getResources(location);
                }
                if (i != null && i.hasMoreElements()) {
                    while (i.hasMoreElements()) {
                        URL url = (URL)i.nextElement();
                        inputStreams.add(new NamedInputStream(url, url.openStream()));
                    }
                } else {
                    try {
                        inputStreams.add(new NamedInputStream(location, new FileInputStream(location)));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return inputStreams.isEmpty() ? new InputStream[]{} : inputStreams.toArray(new InputStream[inputStreams.size()]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeString(String s, File to) throws IOException {
        try (FileOutputStream out = new FileOutputStream(to);){
            out.write(s.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static InputStream asInputStream(ByteBuffer buf) {
        return Streams.asInputStream(true, buf.duplicate());
    }

    public static InputStream asInputStream(boolean rewind, ByteBuffer buf) {
        ByteBuffer use = buf.asReadOnlyBuffer();
        if (rewind) {
            use.rewind();
        }
        return new ByteBufferInputStream(use);
    }

    static ByteBufferInputStream _asInputStream(ByteBuffer buf) {
        return new ByteBufferInputStream(!buf.isReadOnly() ? buf.asReadOnlyBuffer() : buf);
    }

    public static InputStream asInputStream(ReadableByteChannel channel) {
        if (channel instanceof InputStreamByteChannel) {
            return ((InputStreamByteChannel)channel).in;
        }
        return new ByteChannelInputStream(channel);
    }

    public static ReadableByteChannel asByteChannel(InputStream in) {
        if (in instanceof ByteChannelInputStream) {
            return ((ByteChannelInputStream)in).channel;
        }
        return new InputStreamByteChannel(in);
    }

    public static ByteBuffer asByteBuffer(InputStream in) throws IOException {
        int amt;
        if (in instanceof ByteBufferInputStream) {
            ByteBuffer res = ((ByteBufferInputStream)in).buf.asReadOnlyBuffer();
            res.rewind();
            return res;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(2048);
        int pos = 0;
        byte[] b = new byte[2048];
        while ((amt = in.read(b)) > 0) {
            if (pos + amt > buf.capacity()) {
                ByteBuffer nue = ByteBuffer.allocateDirect(buf.capacity() + 2048);
                buf.rewind();
                nue.put(buf);
                buf = nue;
            }
            pos += amt;
            buf.put(b);
        }
        buf.rewind();
        buf.limit(pos);
        return buf;
    }

    public static OutputStream nullOutputStream() {
        return NullOutputStream.INSTANCE;
    }

    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    public static PrintStream nullPrintStream() {
        return NullPrintStream.INSTANCE;
    }

    public static InputStream asInputStream(Iterable<ByteBuffer> buffers) {
        return new ByteBuffersInputStream(buffers.iterator());
    }

    public static InputStream forByteBuffers(ByteBuffer ... iter) {
        return new ByteBufferCollectionInputStream(iter);
    }

    public static InputStream forByteBuffers(Iterable<ByteBuffer> iter) {
        return new ByteBufferCollectionInputStream(iter);
    }

    public static OutputStream asOutputStream(ByteBuffer buffer) {
        return new ByteBufferOutputStream(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File orig, File nue, boolean create) throws IOException {
        if (orig == nue) {
            throw new IOException("Copying file to itself");
        }
        if (orig.isDirectory()) {
            throw new IllegalArgumentException(orig.getAbsolutePath() + " is a directory");
        }
        boolean newExists = nue.exists();
        if (newExists && !create) {
            throw new IOException(nue + " does not exist");
        }
        if (!newExists) {
            if (!nue.createNewFile()) {
                throw new IOException("Could not create file " + nue);
            }
        } else if (nue.isDirectory()) {
            throw new IllegalArgumentException("Copying file to a directory");
        }
        try (FileInputStream in = new FileInputStream(orig);
             FileChannel inChannel = in.getChannel();
             FileOutputStream out = new FileOutputStream(nue);
             FileChannel outChannel = out.getChannel();){
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
    }

    public static InputStream streamForURL(URL url) {
        return new LazyURLStream(url);
    }

    public static PrintStream teeSystemOut(PrintStream other) {
        return Streams.tee(System.out, other);
    }

    public static PrintStream tee(PrintStream ... streams) {
        return new MergePrintStream(streams);
    }

    private Streams() {
    }

    private static String stripTrailingSeparator(String path) {
        if (path.charAt(path.length() - 1) == File.separatorChar) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void link(File original, File target) throws IOException {
        String rp = Streams.getRelativePath(original.getAbsolutePath(), target.getAbsolutePath());
        String[] cmd = new String[]{"ln", "-s", rp, target.getName()};
        ProcessBuilder b = new ProcessBuilder(new String[0]);
        b.directory(target.getParentFile());
        b.command(cmd);
        Process p = b.start();
        try {
            p.waitFor();
            p.destroy();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Streams.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static String getRelativePath(String targetPath, String basePath) throws IOException {
        int distanceToCommonParent;
        String pathSeparator = File.separator;
        String tp = Streams.stripTrailingSeparator(targetPath);
        String bp = Streams.stripTrailingSeparator(basePath);
        String[] base = bp.split(Pattern.quote(pathSeparator));
        String[] target = tp.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (distanceToCommonParent = 0; distanceToCommonParent < target.length && distanceToCommonParent < base.length && target[distanceToCommonParent].equals(base[distanceToCommonParent]); ++distanceToCommonParent) {
            common.append(target[distanceToCommonParent]).append(pathSeparator);
        }
        if (distanceToCommonParent == 0) {
            throw new IOException("No common parent: '" + tp + "' and '" + bp + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(bp);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != distanceToCommonParent) {
            int numDirsUp = baseIsFile ? base.length - distanceToCommonParent - 1 : base.length - distanceToCommonParent;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append("..").append(pathSeparator);
            }
        }
        relative.append(tp.substring(common.length()));
        return relative.toString();
    }

    private static final class MergePrintStream
    extends PrintStream {
        private final PrintStream[] p;

        MergePrintStream(PrintStream ... p) {
            super(Streams.nullOutputStream());
            this.p = p;
        }

        @Override
        public PrintStream append(CharSequence csq) {
            for (PrintStream pp : this.p) {
                pp.append(csq);
            }
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            for (PrintStream pp : this.p) {
                pp.append(csq, start, end);
            }
            return this;
        }

        @Override
        public PrintStream append(char c) {
            for (PrintStream pp : this.p) {
                pp.append(c);
            }
            return this;
        }

        @Override
        public boolean checkError() {
            boolean result = false;
            for (PrintStream pp : this.p) {
                result |= pp.checkError();
            }
            return result;
        }

        @Override
        protected void clearError() {
            super.clearError();
        }

        @Override
        public void close() {
            for (PrintStream pp : this.p) {
                pp.close();
            }
        }

        @Override
        public void flush() {
            for (PrintStream pp : this.p) {
                pp.flush();
            }
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            for (PrintStream pp : this.p) {
                pp.format(format, args);
            }
            return this;
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            for (PrintStream pp : this.p) {
                pp.format(l, format, args);
            }
            return this;
        }

        @Override
        public void print(boolean b) {
            for (PrintStream pp : this.p) {
                pp.print(b);
            }
        }

        @Override
        public void print(char c) {
            for (PrintStream pp : this.p) {
                pp.print(c);
            }
        }

        @Override
        public void print(int i) {
            for (PrintStream pp : this.p) {
                pp.print(i);
            }
        }

        @Override
        public void print(long l) {
            for (PrintStream pp : this.p) {
                pp.print(l);
            }
        }

        @Override
        public void print(float f) {
            for (PrintStream pp : this.p) {
                pp.print(f);
            }
        }

        @Override
        public void print(double d) {
            for (PrintStream pp : this.p) {
                pp.print(d);
            }
        }

        @Override
        public void print(char[] s) {
            for (PrintStream pp : this.p) {
                pp.print(s);
            }
        }

        @Override
        public void print(String s) {
            for (PrintStream pp : this.p) {
                pp.print(s);
            }
        }

        @Override
        public void print(Object obj) {
            for (PrintStream pp : this.p) {
                pp.print(obj);
            }
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            for (PrintStream pp : this.p) {
                pp.printf(format, args);
            }
            return this;
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            for (PrintStream pp : this.p) {
                pp.printf(l, format, args);
            }
            return this;
        }

        @Override
        public void println() {
            for (PrintStream pp : this.p) {
                pp.println();
            }
        }

        @Override
        public void println(boolean x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(char x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(int x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(long x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(float x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(double x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(char[] x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(String x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        public void println(Object x) {
            for (PrintStream pp : this.p) {
                pp.println(x);
            }
        }

        @Override
        protected void setError() {
            try {
                Method m = PrintStream.class.getDeclaredMethod("setError", new Class[0]);
                m.setAccessible(true);
                for (PrintStream pp : this.p) {
                    try {
                        m.invoke((Object)pp, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        Logger.getLogger(Streams.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            catch (NoSuchMethodException | SecurityException ex) {
                Logger.getLogger(Streams.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void write(int b) {
            for (PrintStream pp : this.p) {
                pp.write(b);
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            for (PrintStream pp : this.p) {
                pp.write(buf, off, len);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            for (PrintStream pp : this.p) {
                pp.write(b);
            }
        }
    }

    private static final class LazyURLStream
    extends InputStream {
        private final URL url;
        private InputStream stream;

        LazyURLStream(URL url) {
            this.url = url;
        }

        private synchronized InputStream stream() throws IOException {
            if (this.stream == null) {
                this.stream = this.url.openStream();
            }
            return this.stream;
        }

        @Override
        public synchronized int read() throws IOException {
            return this.stream().read();
        }

        @Override
        public synchronized int available() throws IOException {
            return this.stream().available();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
            super.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.stream().mark(readlimit);
            }
            catch (IOException ex) {
                Logger.getLogger(LazyURLStream.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public synchronized boolean markSupported() {
            try {
                return this.stream().markSupported();
            }
            catch (IOException ex) {
                Logger.getLogger(LazyURLStream.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.stream().read(b);
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            return this.stream().read(b, off, len);
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.stream != null) {
                this.stream.reset();
            }
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            return this.stream().skip(n);
        }
    }

    private static final class ByteChannelInputStream
    extends InputStream {
        private final ReadableByteChannel channel;

        ByteChannelInputStream(ReadableByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            this.channel.read(buf);
            buf.rewind();
            return buf.get();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            return this.channel.read(buf);
        }

        @Override
        public int available() throws IOException {
            if (this.channel instanceof FileChannel) {
                FileChannel fc = (FileChannel)this.channel;
                return (int)Math.max(0L, fc.size() - fc.position());
            }
            return super.available();
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.channel.close();
            }
        }
    }

    private static final class InputStreamByteChannel
    implements ReadableByteChannel {
        private final InputStream in;
        private boolean open = true;

        InputStreamByteChannel(InputStream in) {
            this.in = in;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            byte[] b = new byte[2048];
            int result = this.in.read(b);
            if (result > 0) {
                dst.put(b);
            }
            return result;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() throws IOException {
            this.open = false;
            this.in.close();
        }
    }

    private static final class ByteBufferOutputStream
    extends OutputStream {
        private final ByteBuffer buffer;

        ByteBufferOutputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int i) throws IOException {
            this.buffer.put((byte)i);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            this.buffer.put(bytes, i, i1);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.buffer.put(bytes);
        }
    }

    private static final class ByteBuffersInputStream
    extends InputStream {
        private final Iterator<ByteBuffer> iter;
        private ByteBuffer curr;

        ByteBuffersInputStream(Iterator<ByteBuffer> iter) {
            this.iter = iter;
            this.curr = iter.hasNext() ? iter.next() : ByteBuffer.allocate(0);
        }

        private ByteBuffer buf() {
            while (this.curr != null && this.curr.remaining() == 0) {
                if (this.curr.remaining() != 0) continue;
                this.curr = this.iter.hasNext() ? this.iter.next() : null;
            }
            return this.curr;
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buf = this.buf();
            if (buf == null || buf.remaining() == 0) {
                return -1;
            }
            return buf.get();
        }

        @Override
        public int read(byte[] b) throws IOException {
            int position = 0;
            ByteBuffer buf = this.buf();
            while (buf != null && buf.remaining() > 0) {
                int oldPosition = buf.position();
                buf.get(b, position, b.length - position);
                position += buf.position() - oldPosition;
                buf = this.buf();
            }
            return position == 0 ? -1 : position;
        }
    }

    static final class NullPrintStream
    extends PrintStream {
        private static final NullPrintStream INSTANCE = new NullPrintStream();

        NullPrintStream() {
            super(NullOutputStream.INSTANCE);
        }

        @Override
        public PrintStream append(char c) {
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq) {
            return this;
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this;
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this;
        }

        @Override
        public void println(Object x) {
        }

        @Override
        public void println(String x) {
        }

        @Override
        public void println(char[] x) {
        }

        @Override
        public void println(double x) {
        }

        @Override
        public void println(float x) {
        }

        @Override
        public void println(long x) {
        }

        @Override
        public void println(int x) {
        }

        @Override
        public void println(char x) {
        }

        @Override
        public void println(boolean x) {
        }

        @Override
        public void println() {
        }

        @Override
        public void print(Object obj) {
        }

        @Override
        public void print(String s) {
        }

        @Override
        public void print(char[] s) {
        }

        @Override
        public void print(double d) {
        }

        @Override
        public void print(float f) {
        }

        @Override
        public void print(long l) {
        }

        @Override
        public void print(int i) {
        }

        @Override
        public void print(char c) {
        }

        @Override
        public void print(boolean b) {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        protected void clearError() {
        }

        @Override
        protected void setError() {
        }

        @Override
        public boolean checkError() {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        public String toString() {
            return "/dev/null";
        }

        @Override
        public void writeBytes(byte[] buf) {
        }

        public int hashCode() {
            return 0;
        }
    }

    static final class NullWriter
    extends Writer {
        private static final NullWriter INSTANCE = new NullWriter();

        NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Writer append(char c) throws IOException {
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            return this;
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            return this;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
        }

        @Override
        public void write(String str) throws IOException {
        }

        @Override
        public void write(char[] cbuf) throws IOException {
        }

        @Override
        public void write(int c) throws IOException {
        }

        public String toString() {
            return "/dev/null";
        }

        public int hashCode() {
            return 0;
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        private static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "/dev/null";
        }
    }

    static class NamedInputStream
    extends FilterInputStream {
        private final String name;

        NamedInputStream(Object src, InputStream in) {
            super(in);
            this.name = src + "";
        }

        public String toString() {
            return this.name + " - " + this.in;
        }
    }
}

