/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams.stdio;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.Streams;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class ThreadMappedStdIO {
    private final Map<Thread, IO> ioForThread = new ConcurrentHashMap<Thread, IO>();
    private final IO base = new IO();
    private IO original;
    private int entryCount;
    private final Str stdout = new Str(this::stdout);
    private final Str stderr = new Str(this::stderr);
    private static final ThreadMappedStdIO INSTANCE = new ThreadMappedStdIO();
    private static PrintStream nullPrintStream;

    private ThreadMappedStdIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isActive() {
        ThreadMappedStdIO threadMappedStdIO = INSTANCE;
        synchronized (threadMappedStdIO) {
            return ThreadMappedStdIO.INSTANCE.entryCount > 0;
        }
    }

    public static void bypass(Runnable r) {
        INSTANCE._bypass(r);
    }

    private void _bypass(Runnable r) {
        IO io = this.ioForThread.get(Thread.currentThread());
        if (io == null) {
            r.run();
            return;
        }
        try {
            this.ioForThread.remove(Thread.currentThread());
            r.run();
        }
        finally {
            this.ioForThread.put(Thread.currentThread(), io);
        }
    }

    public static <T> T blackholeNonThrowing(Supplier<T> toRun) {
        try {
            return ThreadMappedStdIO.blackhole(toRun::get);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
    }

    public static void blackhole(Runnable toRun) {
        try {
            ThreadMappedStdIO.blackhole(() -> {
                toRun.run();
                return null;
            });
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    public static void blackhole(ThrowingRunnable toRun) throws Exception {
        ThreadMappedStdIO.blackhole(() -> {
            toRun.run();
            return null;
        });
    }

    public static <T> T blackhole(ThrowingSupplier<T> toRun) throws Exception {
        PrintStream noOp = nullPrintStream == null ? (nullPrintStream = new PrintStream(Streams.nullOutputStream())) : nullPrintStream;
        return ThreadMappedStdIO.enter(noOp, toRun);
    }

    public static <T> T enter(PrintStream output, ThrowingSupplier<T> toRun) throws Exception {
        return INSTANCE._enter(output, toRun);
    }

    private <T> T _enter(PrintStream output, ThrowingSupplier<T> toRun) throws Exception {
        return ThreadMappedStdIO.enter(output, output, toRun);
    }

    public static <T> T enterNonThrowing(PrintStream output, Supplier<T> toRun) {
        return INSTANCE._enterNonThrowing(output, toRun);
    }

    private <T> T _enterNonThrowing(PrintStream output, Supplier<T> toRun) {
        try {
            return this._enter(output, output, toRun::get);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
    }

    public static <T> T enterNonThrowing(PrintStream stdout, PrintStream stderr, Supplier<T> toRun) {
        return INSTANCE._enterNonThrowing(stdout, stderr, toRun);
    }

    private <T> T _enterNonThrowing(PrintStream stdout, PrintStream stderr, Supplier<T> toRun) {
        try {
            return this._enter(stdout, stderr, toRun::get);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return (T)Exceptions.chuck((Throwable)ex);
        }
    }

    public static void enter(PrintStream output, ThrowingRunnable toRun) throws Exception {
        INSTANCE._enter(output, toRun);
    }

    private void _enter(PrintStream output, ThrowingRunnable toRun) throws Exception {
        ThreadMappedStdIO.enter(output, output, () -> {
            toRun.run();
            return null;
        });
    }

    public static void enter(PrintStream output, PrintStream error, ThrowingRunnable toRun) throws Exception {
        INSTANCE._enter(output, error, toRun);
    }

    private void _enter(PrintStream output, PrintStream error, ThrowingRunnable toRun) throws Exception {
        ThreadMappedStdIO.enter(output, error, () -> {
            toRun.run();
            return null;
        });
    }

    public static void enterNonThrowing(PrintStream output, PrintStream error, Runnable toRun) {
        INSTANCE._enterNonThrowing(output, error, toRun);
    }

    private void _enterNonThrowing(PrintStream output, PrintStream error, Runnable toRun) {
        try {
            this._enter(output, error, () -> {
                toRun.run();
                return null;
            });
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    public static void enterNonThrowing(PrintStream output, Runnable toRun) {
        INSTANCE._enterNonThrowing(output, toRun);
    }

    private void _enterNonThrowing(PrintStream output, Runnable toRun) {
        try {
            ThreadMappedStdIO.enter(output, output, () -> {
                toRun.run();
                return null;
            });
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Exceptions.chuck((Throwable)ex);
        }
    }

    public static <T> T enter(PrintStream output, PrintStream error, ThrowingSupplier<T> toRun) throws Exception {
        return INSTANCE._enter(output, error, toRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _enter(PrintStream output, PrintStream error, ThrowingSupplier<T> toRun) throws Exception {
        IO toRestore = this.enter(output, error);
        try {
            Object object = toRun.get();
            return (T)object;
        }
        finally {
            if (this.exit(toRestore)) {
                this.ioForThread.clear();
                this.original = null;
            }
        }
    }

    PrintStream stdout() {
        return this.io().stdout();
    }

    PrintStream stderr() {
        return this.io().stdout();
    }

    IO io() {
        IO result = this.ioForThread.get(Thread.currentThread());
        if (result == null) {
            result = this.original;
        }
        if (result == null) {
            result = this.base;
        }
        return result;
    }

    private synchronized IO enter(PrintStream output, PrintStream error) {
        IO previous = this.ioForThread.get(Thread.currentThread());
        IO io = new IO(output, error);
        this.ioForThread.put(Thread.currentThread(), io);
        if (this.entryCount++ == 0) {
            this.init();
        }
        return previous;
    }

    private synchronized boolean exit(IO toRestore) {
        if (toRestore != null) {
            this.ioForThread.put(Thread.currentThread(), toRestore);
        } else {
            this.ioForThread.remove(Thread.currentThread());
        }
        if (--this.entryCount == 0) {
            this.deinit();
            return true;
        }
        return false;
    }

    private void init() {
        assert (Thread.holdsLock(this));
        this.original = new IO();
        System.setOut(this.stdout);
        System.setErr(this.stderr);
    }

    private void deinit() {
        assert (Thread.holdsLock(this));
        if (this.original != null) {
            System.setOut(this.original.stdout);
            System.setErr(this.original.stderr);
            this.original = null;
        } else {
            System.setOut(this.base.stdout);
            System.setErr(this.base.stderr);
        }
    }

    static class Str
    extends PrintStream {
        private final Supplier<PrintStream> delegate;

        Str(Supplier<PrintStream> delegate) {
            super(Streams.nullOutputStream());
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            this.delegate.get().flush();
        }

        @Override
        public void close() {
            this.delegate.get().close();
        }

        @Override
        public boolean checkError() {
            return this.delegate.get().checkError();
        }

        @Override
        public void write(int b) {
            this.delegate.get().write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.delegate.get().write(buf, off, len);
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.delegate.get().write(buf);
        }

        @Override
        public void print(boolean b) {
            this.delegate.get().print(b);
        }

        @Override
        public void print(char c) {
            this.delegate.get().print(c);
        }

        @Override
        public void print(int i) {
            this.delegate.get().print(i);
        }

        @Override
        public void print(long l) {
            this.delegate.get().print(l);
        }

        @Override
        public void print(float f) {
            this.delegate.get().print(f);
        }

        @Override
        public void print(double d) {
            this.delegate.get().print(d);
        }

        @Override
        public void print(char[] s) {
            this.delegate.get().print(s);
        }

        @Override
        public void print(String s) {
            this.delegate.get().print(s);
        }

        @Override
        public void print(Object obj) {
            this.delegate.get().print(obj);
        }

        @Override
        public void println() {
            this.delegate.get().println();
        }

        @Override
        public void println(boolean x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(char x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(int x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(long x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(float x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(double x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(String x) {
            this.delegate.get().println(x);
        }

        @Override
        public void println(Object x) {
            this.delegate.get().println(x);
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this.delegate.get().printf(format, args);
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this.delegate.get().printf(l, format, args);
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return this.delegate.get().format(format, args);
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return this.delegate.get().format(l, format, args);
        }

        @Override
        public PrintStream append(CharSequence csq) {
            return this.delegate.get().append(csq);
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            return this.delegate.get().append(csq, start, end);
        }

        @Override
        public PrintStream append(char c) {
            return this.delegate.get().append(c);
        }
    }

    private static final class IO {
        final PrintStream stdout;
        final PrintStream stderr;

        public IO(PrintStream stdout, PrintStream stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public IO() {
            this(System.out, System.err);
        }

        public PrintStream stdout() {
            return this.stdout;
        }

        public PrintStream stderr() {
            return this.stdout;
        }
    }
}

