/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.file;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.state.Int;
import com.mastfrog.function.state.Obj;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.io.IOFunction;
import com.mastfrog.function.throwing.io.IOSupplier;
import com.mastfrog.util.file.CharBuffersCharSequence;
import com.mastfrog.util.file.Tail;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.ContinuousLineStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileUtils {
    public static final String SYSPROP_DEFAULT_BUFFER_SIZE = "FileUtils.defaultBufferSize";
    private static final int DEFAULT_BUFFER_SIZE;
    private static final String PREFIX = "java-";
    private static final AtomicInteger FILES_INDEX;
    private static final Set<StandardOpenOption> OPEN_WRITE_CREATE;
    private static final Set<StandardOpenOption> OPEN_APPEND_CREATE;
    private static final FileVisitOption[] NO_FV_OPTIONS;
    private static final FileVisitOption[] FOLLOW_LINKS;
    private static final PosixFilePermission[] NO_PERMISSIONS;
    private static final String[] DEFAULT_SEARCH_PATH;

    public synchronized Path newFile(Path dir, String name, String ext) throws IOException {
        return Files.createFile(this.newPath(dir, name, ext), new FileAttribute[0]);
    }

    public synchronized Path newPath(Path dir, String name, String ext) throws IOException {
        int ix = 0;
        Path p = dir.resolve(name + "." + ext);
        while (Files.exists(p, new LinkOption[0])) {
            p = dir.resolve(name + "-" + ++ix + "." + ext);
        }
        Files.createFile(p, new FileAttribute[0]);
        return p;
    }

    public static synchronized Path newTempDir() throws IOException {
        return FileUtils.newTempDir(PREFIX);
    }

    public static synchronized Path newTempDir(String prefix) throws IOException {
        return FileUtils.newTempDir(prefix, NO_PERMISSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Path newTempDir(String prefix, PosixFilePermission ... permissions) throws IOException {
        boolean setInterrupt = false;
        Class<FileUtils> clazz = FileUtils.class;
        synchronized (FileUtils.class) {
            Path path = FileUtils.newTempPath(prefix);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException ex) {
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(100));
                }
                catch (InterruptedException ex1) {
                    setInterrupt = true;
                }
            }
            FileUtils.setPermissions(path, permissions);
            if (setInterrupt) {
                Thread.currentThread().interrupt();
            }
            return path;
        }
    }

    public static synchronized Path newTempFile(PosixFilePermission ... perms) throws IOException {
        return FileUtils.newTempFile(PREFIX, perms);
    }

    public static synchronized Path newTempFile() throws IOException {
        return FileUtils.newTempFile(PREFIX, NO_PERMISSIONS);
    }

    public static synchronized Path newTempFile(String prefix) throws IOException {
        return FileUtils.newTempFile(prefix, NO_PERMISSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Path newTempFile(String prefix, PosixFilePermission ... permissions) throws IOException {
        boolean setInterrupt = false;
        Class<FileUtils> clazz = FileUtils.class;
        synchronized (FileUtils.class) {
            Path path;
            while (true) {
                path = FileUtils.newTempPath(prefix);
                try {
                    Files.createFile(path, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    try {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(100));
                    }
                    catch (InterruptedException ex1) {
                        setInterrupt = true;
                    }
                    continue;
                }
                break;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            FileUtils.setPermissions(path, permissions);
            if (setInterrupt) {
                Thread.currentThread().interrupt();
            }
            return path;
        }
    }

    public static void setPermissions(Path path, PosixFilePermission ... permissions) throws IOException {
        if (permissions.length == 0) {
            return;
        }
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        for (int i = 0; i < permissions.length; ++i) {
            perms.add(permissions[i]);
        }
        Files.setPosixFilePermissions(path, perms);
    }

    public static boolean deleteIfExists(Path first, Path ... more) throws IOException {
        boolean result = FileUtils.deleteIfExists(first);
        for (Path p : more) {
            result |= FileUtils.deleteIfExists(p);
        }
        return result;
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
                return true;
            }
            catch (FileNotFoundException | NoSuchFileException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.FINEST, null, ex);
            }
        }
        return false;
    }

    public static synchronized Path newTempPath(String prefix) {
        Checks.notNull((String)"prefix", (Object)prefix);
        Path tmp = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        long now = System.currentTimeMillis();
        String base = prefix + Long.toString(now, 36) + "-" + FILES_INDEX.getAndIncrement();
        Path target = tmp.resolve(base);
        int ix = 1;
        while (Files.exists(target, new LinkOption[0])) {
            target = tmp.resolve(base + "-" + ix++);
        }
        return target;
    }

    public static void writeFile(Path path, CharSequence content, Charset as, int bufferSize, boolean append) throws IOException {
        FileUtils.writeFile(path, true, content, as, bufferSize, append, new FileAttribute[0]);
    }

    public static void writeUtf8(Path path, CharSequence content) throws IOException {
        FileUtils.writeFile(path, content, StandardCharsets.UTF_8);
    }

    public static void writeAscii(Path path, CharSequence content) throws IOException {
        FileUtils.writeFile(path, content, StandardCharsets.US_ASCII);
    }

    public static void writeFile(Path path, CharSequence content, Charset as) throws IOException {
        FileUtils.writeFile(path, true, content, as, DEFAULT_BUFFER_SIZE, false, new FileAttribute[0]);
    }

    public static void writeFile(Path path, CharSequence content, Charset as, boolean append, FileAttribute ... attrs) throws IOException {
        FileUtils.writeFile(path, true, content, as, DEFAULT_BUFFER_SIZE, append, attrs);
    }

    public static void writeFile(Path path, CharSequence content, Charset as, int bufferSize, boolean append, FileAttribute ... attrs) throws IOException {
        FileUtils.writeFile(path, true, content, as, bufferSize, append, attrs);
    }

    public static void writeFile(Path path, boolean permissive, CharSequence content, Charset as, int bufferSize, boolean append, FileAttribute ... attrs) throws IOException {
        FileUtils.writeFile(path, permissive, content, false, as, bufferSize, append, attrs);
    }

    public static void writeFile(Path path, boolean permissive, CharSequence content, boolean directBuffers, Charset as, int bufferSize, boolean append, FileAttribute ... attrs) throws IOException {
        Set<StandardOpenOption> options = append ? OPEN_APPEND_CREATE : OPEN_WRITE_CREATE;
        ((FileChannel)FileUtils.writeCharSequence(content, permissive, as, bufferSize, directBuffers, () -> FileChannel.open(path, options, attrs))).close();
    }

    public static <T extends WritableByteChannel> T writeCharSequence(CharSequence content, boolean permissive, Charset as, int bufferSize, boolean directBuffers, IOSupplier<? extends T> channelSupplier) throws IOException {
        Checks.notNull((String)"content", (Object)content);
        Checks.notNull((String)"as", (Object)as);
        Checks.greaterThanZero((String)"bufferSize", (int)bufferSize);
        Checks.notNull((String)"channelSupplier", channelSupplier);
        WritableByteChannel channel = (WritableByteChannel)channelSupplier.get();
        try {
            int bytesWritten;
            ByteBuffer buffer = directBuffers ? ByteBuffer.allocateDirect(Math.max(4, bufferSize)) : ByteBuffer.allocate(Math.max(4, bufferSize));
            CharsetEncoder enc = as.newEncoder();
            CharBuffer charBuffer = CharBuffer.wrap(content);
            do {
                buffer.clear();
                CoderResult res = enc.encode(charBuffer, buffer, false);
                if (!permissive && res.isError() || res.isMalformed()) {
                    res.throwException();
                }
                buffer.flip();
            } while ((bytesWritten = channel.write(buffer)) != 0);
            return (T)channel;
        }
        catch (Exception ex) {
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
            return (T)((WritableByteChannel)Exceptions.chuck((Throwable)ex));
        }
    }

    public static CharSequence readAscii(Path path) throws IOException {
        return FileUtils.readCharSequence(path, StandardCharsets.US_ASCII);
    }

    public static String readAsciiString(Path path) throws IOException {
        return FileUtils.readString(path, StandardCharsets.US_ASCII);
    }

    public static CharSequence readUTF8(Path path) throws IOException {
        return FileUtils.readCharSequence(path, StandardCharsets.UTF_8);
    }

    public static String readUTF8String(Path path) throws IOException {
        return FileUtils.readString(path, StandardCharsets.UTF_8);
    }

    public static String readString(Path path, Charset as) throws IOException {
        return FileUtils.readString(path, DEFAULT_BUFFER_SIZE, as, true);
    }

    public static CharSequence readCharSequence(Path path, Charset charset) throws IOException {
        return FileUtils.readCharSequence(path, DEFAULT_BUFFER_SIZE, charset, true);
    }

    public static String readString(Path path, int bufferSize, Charset charset) throws IOException {
        return FileUtils.readString(path, bufferSize, charset, true);
    }

    public static CharSequence readCharSequence(Path path, int bufferSize, Charset charset) throws IOException {
        return FileUtils.readCharSequence(path, bufferSize, charset, true);
    }

    public static String readString(Path path, int bufferSize, Charset charset, boolean permissive) throws IOException {
        return FileUtils.readCharSequence(path, bufferSize, charset, permissive).toString();
    }

    public static CharSequence readCharSequence(Path path, int bufferSize, Charset charset, boolean permissive) throws IOException {
        return FileUtils.readCharSequence(path, false, bufferSize, charset, permissive);
    }

    public static CharSequence readCharSequence(Path path, boolean directBuffers, int bufferSize, Charset charset, boolean permissive) throws IOException {
        Checks.notNull((String)"path", (Object)path);
        Checks.greaterThanZero((String)"bufferSize", (int)bufferSize);
        Checks.notNull((String)"charset", (Object)charset);
        ReadableByteChannel[] holder = new ReadableByteChannel[1];
        CharSequence result = FileUtils.readCharSequence(directBuffers, bufferSize, charset, permissive, holder, (IOSupplier<ReadableByteChannel>)((IOSupplier)() -> FileChannel.open(path, StandardOpenOption.READ)));
        if (holder[0] != null) {
            holder[0].close();
        }
        return result;
    }

    public static CharSequence readCharSequence(boolean directBuffers, int bufferSize, Charset charset, boolean permissive, ReadableByteChannel[] channelHolder, IOSupplier<ReadableByteChannel> ch) throws IOException {
        Checks.greaterThanZero((String)"channelHolder.length", (int)channelHolder.length);
        ReadableByteChannel channel = channelHolder[0] = (ReadableByteChannel)ch.get();
        try {
            CharBuffer charBuffer;
            int count;
            SeekableByteChannel sk;
            if (channel instanceof SeekableByteChannel && ((SeekableByteChannel)channel).size() == 0L && (sk = (SeekableByteChannel)channel).position() == sk.size()) {
                return "";
            }
            bufferSize = Math.max(4, bufferSize);
            ByteBuffer readBuffer = directBuffers ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
            CharsetDecoder decoder = charset.newDecoder();
            ArrayList<CharBuffer> charBuffers = new ArrayList<CharBuffer>();
            bufferSize = Math.max((int)Math.ceil(1.0f / decoder.averageCharsPerByte()), bufferSize);
            int charBufferSize = Math.max(2, (int)Math.ceil(decoder.averageCharsPerByte() * (float)bufferSize));
            while (readBuffer.limit() > 0 && (count = FileUtils.decode(channel, readBuffer, charBuffer = directBuffers ? ByteBuffer.allocate(charBufferSize).asCharBuffer() : CharBuffer.allocate(charBufferSize), decoder, true)) >= 0) {
                if (charBuffer.limit() > 0) {
                    charBuffers.add(charBuffer);
                }
                if (count != 0) continue;
                break;
            }
            return new CharBuffersCharSequence(charBuffers.toArray(new CharBuffer[charBuffers.size()]));
        }
        catch (Exception ioe) {
            channel.close();
            return (CharSequence)Exceptions.chuck((Throwable)ioe);
        }
    }

    public static int decode(ReadableByteChannel fileChannel, ByteBuffer readBuffer, CharBuffer target, CharsetDecoder charsetDecoder, boolean permissive) throws IOException {
        int result = FileUtils.decode(fileChannel, readBuffer, target, charsetDecoder, permissive, null);
        target.flip();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decode(ReadableByteChannel fileChannel, ByteBuffer readBuffer, CharBuffer target, CharsetDecoder charsetDecoder, boolean permissive, CoderResult[] res) throws IOException {
        Obj obj = res == null ? null : Obj.create();
        try {
            int n = FileUtils.decode(fileChannel, readBuffer, target, charsetDecoder, (Obj<CoderResult>)obj, permissive);
            return n;
        }
        finally {
            if (res != null) {
                res[0] = (CoderResult)obj.get();
            }
        }
    }

    public static int decode(ReadableByteChannel fileChannel, ByteBuffer readBuffer, CharBuffer target, CharsetDecoder charsetDecoder, Obj<CoderResult> res, boolean permissive) throws IOException {
        CoderResult lastCoderResult = null;
        int total = 0;
        do {
            long oldPos = readBuffer.position();
            int numBytesRead = fileChannel.read(readBuffer);
            if ((long)readBuffer.position() <= oldPos && oldPos <= 0L) break;
            ByteBuffer rb = readBuffer;
            total = (int)((long)total + ((long)Math.max(0, numBytesRead) + oldPos));
            if (numBytesRead < 0 && rb.position() == 0) {
                return -1;
            }
            if (numBytesRead <= 0 && rb.position() == rb.limit()) {
                return -1;
            }
            rb.flip();
            lastCoderResult = charsetDecoder.decode(rb, target, true);
            if (rb.position() < rb.limit()) {
                ByteBuffer tail = rb.slice();
                rb.rewind();
                rb.put(tail);
                if (target.position() == target.capacity()) {
                    break;
                }
            } else {
                rb.rewind();
            }
            if (permissive || !lastCoderResult.isError() && !lastCoderResult.isUnmappable() && !lastCoderResult.isMalformed()) continue;
            lastCoderResult.throwException();
        } while (target.capacity() < target.position());
        if (res != null) {
            res.set(lastCoderResult);
        }
        return total;
    }

    public static void deltree(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        HashSet paths = new HashSet();
        while (true) {
            try (Stream<Path> all2 = Files.walk(dir, new FileVisitOption[0]);){
                all2.forEach(paths::add);
            }
            catch (NoSuchFileException all2) {
                continue;
            }
            break;
        }
        ArrayList l = new ArrayList(paths);
        l.sort((pa, pb) -> -Integer.compare(pa.getNameCount(), pb.getNameCount()));
        for (Path p : l) {
            try {
                Files.delete(p);
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
    }

    public static IOFunction<Predicate<CharSequence>, Runnable> tail(Path file, Charset charset) throws IOException {
        ExecutorService svc = Executors.newCachedThreadPool();
        IOFunction<Predicate<CharSequence>, Runnable> result = FileUtils.tail(file, charset, DEFAULT_BUFFER_SIZE, svc);
        return pred -> {
            Runnable stopWatching = (Runnable)result.apply(pred);
            return () -> {
                try {
                    stopWatching.run();
                }
                finally {
                    svc.shutdown();
                }
            };
        };
    }

    public static IOFunction<Predicate<CharSequence>, Runnable> tail(Path file, Charset charset, int bufferSize, Executor exe) throws IOException {
        return new Tail(file, bufferSize, charset);
    }

    public static Path findExecutable(String command) {
        return FileUtils.findExecutable(command, true, true, new String[0]);
    }

    public static Path findExecutable(String command, String ... alsoSearch) {
        return FileUtils.findExecutable(command, true, true, alsoSearch);
    }

    public static Path findExecutable(String command, boolean useDefaultSearchPath, boolean useSystemPath, String ... alsoSearch) {
        String systemPath;
        command = Paths.get(command, new String[0]).getFileName().toString();
        HashSet<String> searched = new HashSet<String>();
        for (String als : alsoSearch) {
            for (String path : FileUtils.splitUniqueNoEmpty(File.pathSeparatorChar, als)) {
                Path dir = Paths.get(path, new String[0]);
                Path file = dir.resolve(command);
                if (Files.exists(file, new LinkOption[0]) && Files.isExecutable(file)) {
                    return file;
                }
                searched.add(path);
            }
        }
        if (useSystemPath && (systemPath = System.getenv("PATH")) != null) {
            for (String path : FileUtils.splitUniqueNoEmpty(File.pathSeparatorChar, systemPath)) {
                Path dir = Paths.get(path, new String[0]);
                Path file = dir.resolve(command);
                if (Files.exists(file, new LinkOption[0]) && Files.isExecutable(file)) {
                    return file;
                }
                searched.add(path);
            }
        }
        if (useDefaultSearchPath) {
            for (String path : DEFAULT_SEARCH_PATH) {
                if (searched.contains(path)) continue;
                Path dir = Paths.get(path, new String[0]);
                Path file = dir.resolve(command);
                if (Files.exists(file, new LinkOption[0]) && Files.isExecutable(file)) {
                    return file;
                }
                searched.add(path);
            }
        }
        return Paths.get(command, new String[0]);
    }

    static Set<String> splitUniqueNoEmpty(char splitOn, String path) {
        if (path == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> seqs = new LinkedHashSet<String>();
        StringBuilder curr = new StringBuilder();
        int max = path.length();
        for (int i = 0; i < max; ++i) {
            char c = path.charAt(i);
            if (c == splitOn || i == max - 1) {
                String s;
                if (i == max - 1 && c != splitOn) {
                    curr.append(c);
                }
                if ((s = curr.toString().trim()).length() > 0) {
                    seqs.add(s);
                }
                curr.setLength(0);
                continue;
            }
            curr.append(c);
        }
        return seqs;
    }

    public static Predicate<Path> filesOnly() {
        return pth -> !Files.isDirectory(pth, new LinkOption[0]);
    }

    public static Predicate<Path> foldersOnly() {
        return pth -> !Files.isDirectory(pth, new LinkOption[0]);
    }

    public static Predicate<Path> byExtension(String ext) {
        Checks.notEmpty((String)"ext", (CharSequence)((String)Checks.notNull((String)"ext", (Object)ext)));
        if (ext.charAt(0) != '.') {
            ext = '.' + ext;
        }
        String extension = ext;
        return pth -> pth.toString().endsWith(extension);
    }

    public static Set<Path> find(Path dir, String extension) throws IOException {
        return FileUtils.find(dir, false, extension);
    }

    public static Set<Path> find(Path dir, boolean relativize, String extension) throws IOException {
        LinkedHashSet result = new LinkedHashSet(24);
        Predicate<Path> test = FileUtils.filesOnly().and(FileUtils.byExtension(extension));
        int count = FileUtils.search(relativize, dir, false, test, result::add);
        return count == 0 ? Collections.emptySet() : result;
    }

    public static int search(boolean relativize, Path dir, boolean followLinks, Predicate<? super Path> predicate, Consumer<? super Path> consumer) throws IOException {
        int[] count = new int[1];
        try (Stream<Path> all = Files.walk(dir, followLinks ? FOLLOW_LINKS : NO_FV_OPTIONS);){
            all.filter(predicate).forEach(path -> {
                if (relativize) {
                    path = dir.relativize((Path)path);
                }
                consumer.accept((Path)path);
                count[0] = count[0] + 1;
            });
        }
        return count[0];
    }

    public static Stream<CharSequence> lines(Path path) {
        return FileUtils.lines(path, DEFAULT_BUFFER_SIZE, StandardCharsets.UTF_8);
    }

    public static Stream<CharSequence> lines(Path path, Charset charset) {
        return FileUtils.lines(path, DEFAULT_BUFFER_SIZE, charset);
    }

    public static Stream<CharSequence> lines(Path path, int bufferSize, Charset charset) {
        final ContinuousLineStream lines = ContinuousLineStream.of(path, DEFAULT_BUFFER_SIZE, charset);
        return StreamSupport.stream(() -> new Spliterator<CharSequence>(){

            @Override
            public boolean tryAdvance(Consumer<? super CharSequence> action) {
                try {
                    if (lines.hasMoreLines()) {
                        action.accept(lines.nextLine());
                        return true;
                    }
                }
                catch (IOException ex) {
                    return (Boolean)Exceptions.chuck((Throwable)ex);
                }
                return false;
            }

            @Override
            public Spliterator<CharSequence> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 272;
            }
        }, 272, false);
    }

    public static Iterator<Path> filesToPaths(Iterator<File> files) {
        return new ConvertIterator<File, Path>(files, File::toPath);
    }

    public static Iterator<File> pathsToFiles(Iterator<Path> paths) {
        return new ConvertIterator<Path, File>(paths, Path::toFile);
    }

    public static Iterable<Path> filesToPaths(Iterable<File> file) {
        return () -> FileUtils.filesToPaths(file.iterator());
    }

    public static Iterable<File> pathsToFiles(Iterable<Path> file) {
        return () -> FileUtils.pathsToFiles(file.iterator());
    }

    public static Optional<Path> ifExists(Path path) {
        if (path == null) {
            return Optional.empty();
        }
        if (Files.exists(path, new LinkOption[0])) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static Optional<Path> ifDirectory(Path path) {
        return FileUtils.ifExists(path).flatMap(maybeDir -> Files.isDirectory(maybeDir, new LinkOption[0]) ? Optional.of(maybeDir) : Optional.empty());
    }

    public static ThrowingOptional<Path> ifExistsT(Path path) {
        if (path == null) {
            return ThrowingOptional.empty();
        }
        if (Files.exists(path, new LinkOption[0])) {
            return ThrowingOptional.of((Object)path);
        }
        return ThrowingOptional.empty();
    }

    public static ThrowingOptional<Path> ifDirectoryT(Path path) {
        return FileUtils.ifExistsT(path).flatMapThrowing(maybeDir -> Files.isDirectory(maybeDir, new LinkOption[0]) ? ThrowingOptional.of((Object)maybeDir) : ThrowingOptional.empty());
    }

    public static int[] copyFolderTree(Path from, Path to) throws IOException {
        Int files = Int.create();
        Int dirs = Int.create();
        try (Stream<Path> srcStream = Files.walk(from, 1280, new FileVisitOption[0]);){
            srcStream.forEach(fileOrDir -> {
                Path rel = from.relativize((Path)fileOrDir);
                Path target = to.resolve(rel);
                boolean dir = Files.isDirectory(fileOrDir, new LinkOption[0]);
                FileUtils.quietly(() -> {
                    Path destDir;
                    Path path = destDir = dir ? target : target.getParent();
                    if (!Files.exists(destDir, new LinkOption[0])) {
                        Files.createDirectories(destDir, new FileAttribute[0]);
                        dirs.increment();
                    }
                    if (!dir) {
                        if (!Files.exists(fileOrDir, new LinkOption[0])) {
                            Files.copy(fileOrDir, target, new CopyOption[0]);
                        } else {
                            Files.copy(fileOrDir, target, StandardCopyOption.REPLACE_EXISTING);
                        }
                        files.increment();
                    }
                });
            });
        }
        return new int[]{files.getAsInt(), dirs.getAsInt()};
    }

    private static void quietly(ThrowingRunnable tr) {
        tr.toNonThrowing().run();
    }

    public static Path userCacheRoot() {
        Path home = Paths.get(System.getProperty("user.home", System.getenv("HOME")), new String[0]);
        String os = System.getProperty("os.name");
        if ("Mac OS X".equals(os)) {
            return home.resolve("Library").resolve("Caches");
        }
        return home.resolve(".cache");
    }

    public static Path temp() {
        return Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), new String[0]);
    }

    public static Path home() {
        return FileUtils.fromSystemProperty("user.home", () -> FileUtils.fromSystemProperty("java.io.tmpdir", () -> Paths.get("/", new String[0])));
    }

    private static Path fromSystemProperty(String what, Supplier<Path> fallback) {
        String prop = System.getProperty(what);
        return prop == null ? fallback.get() : Paths.get(prop, new String[0]);
    }

    public static String homeRelativePath(Path what) {
        Path home = FileUtils.home();
        if (what.startsWith(home)) {
            return "~/" + home.relativize(what).toString();
        }
        return what.toString();
    }

    public static void unzip(InputStream in, Path dir) throws IOException {
        Checks.notNull((String)"dir", (Object)dir);
        try (ZipInputStream zip = new ZipInputStream((InputStream)Checks.notNull((String)"in", (Object)in));){
            ZipEntry en;
            while ((en = zip.getNextEntry()) != null) {
                Path dest;
                if (en.isDirectory()) {
                    dest = dir.resolve(en.getName());
                    if (Files.exists(dest, new LinkOption[0])) continue;
                    Files.createDirectories(dest, new FileAttribute[0]);
                    continue;
                }
                dest = dir.resolve(en.getName());
                if (!Files.exists(dest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                }
                Files.copy(zip, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private FileUtils() {
        throw new AssertionError();
    }

    static {
        FILES_INDEX = new AtomicInteger(1);
        OPEN_WRITE_CREATE = EnumSet.noneOf(StandardOpenOption.class);
        OPEN_APPEND_CREATE = EnumSet.noneOf(StandardOpenOption.class);
        NO_FV_OPTIONS = new FileVisitOption[0];
        FOLLOW_LINKS = new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS};
        NO_PERMISSIONS = new PosixFilePermission[0];
        DEFAULT_SEARCH_PATH = new String[]{"/usr/bin", "/usr/local/bin", "/opt/local/bin", "/bin", "/sbin", "/usr/sbin", "/opt/bin"};
        OPEN_WRITE_CREATE.add(StandardOpenOption.CREATE);
        OPEN_WRITE_CREATE.add(StandardOpenOption.WRITE);
        OPEN_WRITE_CREATE.add(StandardOpenOption.TRUNCATE_EXISTING);
        OPEN_APPEND_CREATE.add(StandardOpenOption.CREATE);
        OPEN_APPEND_CREATE.add(StandardOpenOption.APPEND);
        String s = System.getProperty(SYSPROP_DEFAULT_BUFFER_SIZE);
        if (s != null) {
            DEFAULT_BUFFER_SIZE = Integer.parseInt(s);
            Checks.greaterThanZero((String)SYSPROP_DEFAULT_BUFFER_SIZE, (int)DEFAULT_BUFFER_SIZE);
        } else {
            DEFAULT_BUFFER_SIZE = 512;
        }
    }

    private static final class ConvertIterator<T, R>
    implements Iterator<R> {
        private final Iterator<T> iter;
        private final Function<T, R> func;

        public ConvertIterator(Iterator<T> iter, Function<T, R> func) {
            this.iter = iter;
            this.func = func;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public R next() {
            return this.func.apply(this.iter.next());
        }
    }
}

