/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.file;

import com.mastfrog.function.state.Bool;
import com.mastfrog.function.state.Int;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class WatchManager {
    private final Map<FileSystem, FileSystemRegistration> fsRegs = new ConcurrentHashMap<FileSystem, FileSystemRegistration>();
    private final ScheduledExecutorService executor;
    private final long perKeyWait;
    private final long maxTimePer;
    private final AtomicBoolean started = new AtomicBoolean();
    private final long interval;
    private Future<?> nextScheduled;
    private final AtomicBoolean paused = new AtomicBoolean();
    private static Reference<WatchManager> sharedInstance;
    private Boolean isSharedInstance;

    static synchronized WatchManager sharedInstance(boolean create) {
        WatchManager result = null;
        if (sharedInstance != null) {
            result = sharedInstance.get();
        }
        if (result == null && create) {
            result = new WatchManager();
            sharedInstance = new WeakReference<WatchManager>(result);
        }
        return result;
    }

    static WatchManager sharedInstance() {
        return WatchManager.sharedInstance(true);
    }

    public WatchManager(ScheduledExecutorService executor, Duration perKeyWait, Duration maxTimePer, Duration interval) {
        this(executor, perKeyWait.toMillis(), maxTimePer.toMillis(), interval.toMillis());
    }

    public WatchManager(Duration perKeyWait, Duration maxTimePer, Duration interval) {
        this(Executors.newScheduledThreadPool(1), perKeyWait, maxTimePer, interval);
    }

    public WatchManager() {
        this(Executors.newScheduledThreadPool(1), 200L, 120L, 500L);
    }

    public WatchManager(ScheduledExecutorService executor, long perKeyWait, long maxTimePer, long interval) {
        this.executor = executor;
        this.perKeyWait = perKeyWait;
        this.maxTimePer = maxTimePer;
        this.interval = interval;
    }

    private boolean isSharedInstance() {
        if (this.isSharedInstance != null) {
            return this.isSharedInstance;
        }
        WatchManager shared = WatchManager.sharedInstance(false);
        this.isSharedInstance = shared == this;
        return this.isSharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause(boolean pause) {
        if (this.isSharedInstance()) {
            return false;
        }
        if (this.paused.compareAndSet(!pause, pause)) {
            WatchManager watchManager = this;
            synchronized (watchManager) {
                if (pause) {
                    if (this.nextScheduled != null) {
                        this.nextScheduled.cancel(false);
                    }
                } else if (this.nextScheduled == null || this.nextScheduled.isDone() && this.started.get() && !this.isEmpty()) {
                    this.nextScheduled = this.executor.schedule(this::run, this.interval, TimeUnit.MILLISECONDS);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int pollLoop() throws InterruptedException {
        ArrayList<FileSystemRegistration> copy;
        Bool anyTimedOut = Bool.create();
        int total = 0;
        WatchManager watchManager = this;
        synchronized (watchManager) {
            copy = new ArrayList<FileSystemRegistration>(this.fsRegs.values());
        }
        for (FileSystemRegistration fs : copy) {
            long wait = anyTimedOut.getAsBoolean() ? 0L : this.perKeyWait;
            total += fs.pollLoop(wait, this.maxTimePer, anyTimedOut);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (this.isSharedInstance()) {
            return false;
        }
        if (this.started.compareAndSet(true, false)) {
            WatchManager watchManager = this;
            synchronized (watchManager) {
                if (this.nextScheduled != null) {
                    this.nextScheduled.cancel(true);
                }
                this.fsRegs.clear();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        try {
            while (this.pollLoop() > 0) {
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(WatchManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (this.started.get() && !this.paused.get()) {
                WatchManager watchManager = this;
                synchronized (watchManager) {
                    if (!this.isEmpty()) {
                        this.nextScheduled = this.executor.schedule(this::run, this.interval, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    public synchronized void watch(Path target, BiConsumer<Path, WatchEvent.Kind<?>> c, WatchEvent.Kind<?> oneKind, WatchEvent.Kind<?> ... more) throws IOException {
        HashSet set = new HashSet(more.length + 1);
        set.add(oneKind);
        set.addAll(Arrays.asList(more));
        this.watch(target, c, set);
    }

    public synchronized void watch(Path target, BiConsumer<Path, WatchEvent.Kind<?>> c, Set<WatchEvent.Kind<?>> kinds) throws IOException {
        if (kinds.isEmpty()) {
            throw new IllegalArgumentException("No kinds");
        }
        Path folder = Files.isDirectory(target, new LinkOption[0]) ? target : target.getParent();
        FileSystem fs = folder.getFileSystem();
        FileSystemRegistration reg = this.fsRegs.computeIfAbsent(fs, FileSystemRegistration::new);
        reg.add(folder, target, kinds, c);
        if (this.started.compareAndSet(false, true) && !this.paused.get() && !this.isEmpty()) {
            this.nextScheduled = this.executor.submit(this::run);
        }
    }

    public synchronized void unwatch(Path target, BiConsumer<Path, WatchEvent.Kind<?>> c) {
        HashSet toRemove = new HashSet();
        this.fsRegs.forEach((fs, reg) -> {
            if (reg.remove(target, c)) {
                toRemove.add(fs);
            }
        });
        toRemove.forEach(this.fsRegs::remove);
        if (this.isEmpty() && this.nextScheduled != null) {
            this.nextScheduled.cancel(true);
        }
    }

    public synchronized boolean isEmpty() {
        HashSet<FileSystem> toRemove = new HashSet<FileSystem>();
        boolean result = true;
        for (Map.Entry<FileSystem, FileSystemRegistration> e : this.fsRegs.entrySet()) {
            boolean empty = e.getValue().isEmpty();
            result &= empty;
            if (!empty) continue;
            toRemove.add(e.getKey());
            e.getValue().close();
        }
        toRemove.forEach(this.fsRegs::remove);
        result = this.fsRegs.isEmpty();
        if (result) {
            this.started.set(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap<FileSystem, FileSystemRegistration> copy;
        WatchManager watchManager = this;
        synchronized (watchManager) {
            copy = new HashMap<FileSystem, FileSystemRegistration>(this.fsRegs);
        }
        StringBuilder sb = new StringBuilder("WatchManager:");
        if (copy.isEmpty()) {
            sb.append(" (empty)");
        }
        for (Map.Entry e : copy.entrySet()) {
            for (Path p : ((FileSystem)e.getKey()).getRootDirectories()) {
                sb.append(p).append(' ');
            }
            sb.append(e.getValue());
        }
        return sb.toString();
    }

    public RecursiveWatcher recursiveWatch(Path root, int maxDepth, BiConsumer<Path, WatchEvent.Kind<?>> consumer, WatchEvent.Kind<?> kind, WatchEvent.Kind<?> ... more) throws IOException {
        HashSet all = new HashSet();
        all.add(kind);
        all.addAll(Arrays.asList(more));
        RecursiveWatcherImpl watcher = new RecursiveWatcherImpl(root, this, maxDepth, all, consumer);
        watcher.attach();
        return watcher;
    }

    private static class FileSystemRegistration {
        private final FileSystem fs;
        private final Map<Path, FolderWatchRegistration> registrations = new HashMap<Path, FolderWatchRegistration>();
        private WatchService svc;

        public FileSystemRegistration(FileSystem fs) {
            this.fs = fs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            HashMap<Path, FolderWatchRegistration> copy;
            StringBuilder sb = new StringBuilder();
            FileSystemRegistration fileSystemRegistration = this;
            synchronized (fileSystemRegistration) {
                copy = new HashMap<Path, FolderWatchRegistration>(this.registrations);
            }
            for (Map.Entry entry : copy.entrySet()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append('\t').append(entry.getKey()).append(' ').append(entry.getValue());
            }
            return sb.toString();
        }

        synchronized boolean remove(Path path, BiConsumer<Path, WatchEvent.Kind<?>> consumer) {
            HashSet toRemove = new HashSet();
            this.registrations.forEach((pth, fwr) -> {
                if (fwr.remove(path, consumer)) {
                    toRemove.add(pth);
                }
            });
            toRemove.forEach(this.registrations::remove);
            return this.isEmpty();
        }

        synchronized boolean isEmpty() {
            if (this.registrations.isEmpty()) {
                return true;
            }
            HashSet toRemove = new HashSet();
            this.registrations.forEach((pth, fwr) -> {
                if (fwr.isEmpty()) {
                    toRemove.add(pth);
                }
            });
            toRemove.forEach(this.registrations::remove);
            boolean result = this.registrations.isEmpty();
            if (result) {
                this.close();
            }
            return result;
        }

        synchronized void close() {
            if (this.svc != null) {
                try {
                    this.svc.close();
                    this.svc = null;
                }
                catch (IOException ex) {
                    Logger.getLogger(WatchManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.registrations.clear();
            }
        }

        synchronized void add(Path folder, Path target, Set<WatchEvent.Kind<?>> kinds, BiConsumer<Path, WatchEvent.Kind<?>> c) throws IOException {
            FolderWatchRegistration reg = this.registrations.computeIfAbsent(folder, FolderWatchRegistration::new);
            WatchService ws = this.watchService();
            reg.add(target, ws, c, kinds);
        }

        synchronized WatchService watchService() throws IOException {
            if (this.svc != null) {
                return this.svc;
            }
            this.svc = this.fs.newWatchService();
            return this.svc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int pollLoop(long ms, long maxTimeMillis, Bool anyTimedOut) throws InterruptedException {
            WatchKey key;
            Int processed = Int.create();
            long start = System.currentTimeMillis();
            do {
                WatchService ws;
                FileSystemRegistration fileSystemRegistration = this;
                synchronized (fileSystemRegistration) {
                    ws = this.svc;
                }
                if (ws == null) break;
                if (System.currentTimeMillis() - start > maxTimeMillis) {
                    anyTimedOut.set();
                    break;
                }
                WatchKey watchKey = key = ms == 0L ? ws.poll() : ws.poll(ms, TimeUnit.MILLISECONDS);
                if (key == null) continue;
                WatchKey wk = key;
                try {
                    List<WatchEvent<?>> evts = key.pollEvents();
                    evts.forEach(evt -> {
                        if (!(evt.context() instanceof Path)) {
                            return;
                        }
                        this.registrations.forEach((path, fwr) -> {
                            int count = fwr.eachConsumer(wk, (WatchEvent<?>)evt, consumer -> {
                                Path ctx = (Path)evt.context();
                                consumer.accept(path.resolve(ctx), evt.kind());
                            });
                            processed.increment(count);
                        });
                    });
                }
                finally {
                    wk.reset();
                }
            } while (key != null);
            if (processed.getAsInt() > 0) {
                StringBuilder sb = new StringBuilder();
                for (Path dr : this.fs.getRootDirectories()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(dr);
                }
            }
            return processed.getAsInt();
        }
    }

    private static final class RecursiveWatcherImpl
    implements BiConsumer<Path, WatchEvent.Kind<?>>,
    RecursiveWatcher {
        private final Path root;
        private final WatchManager mgr;
        private final Set<WatchEvent.Kind<?>> set;
        private final BiConsumer<Path, WatchEvent.Kind<?>> consumer;
        static final Set<WatchEvent.Kind<?>> ALL;
        private final Set<Path> listeningTo = ConcurrentHashMap.newKeySet(36);
        private final int maxDepth;

        RecursiveWatcherImpl(Path root, WatchManager mgr, int maxDepth, Set<WatchEvent.Kind<?>> set, BiConsumer<Path, WatchEvent.Kind<?>> consumer) throws IOException {
            this.root = root;
            this.mgr = mgr;
            this.set = set;
            this.consumer = consumer;
            this.maxDepth = maxDepth;
        }

        public String toString() {
            return "RecursiveWatcher(" + this.consumer + ")";
        }

        @Override
        public synchronized Set<? extends Path> attach() {
            if (!this.listeningTo.isEmpty()) {
                return Collections.unmodifiableSet(this.listeningTo);
            }
            try {
                this.mgr.watch(this.root, this, ALL);
                this.listeningTo.add(this.root);
                try (Stream<Path> str = Files.walk(this.root, this.maxDepth, FileVisitOption.FOLLOW_LINKS);){
                    str.filter(fl -> Files.isDirectory(fl, new LinkOption[0])).forEach(pth -> {
                        try {
                            this.mgr.watch((Path)pth, this, ALL);
                            this.listeningTo.add((Path)pth);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(WatchManager.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                }
            }
            catch (IOException ex) {
                Logger.getLogger(WatchManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            return Collections.unmodifiableSet(this.listeningTo);
        }

        public synchronized Set<Path> detach() {
            HashSet<Path> all = new HashSet<Path>(this.listeningTo);
            this.listeningTo.clear();
            all.forEach(p -> this.mgr.unwatch((Path)p, this));
            return all;
        }

        @Override
        public void accept(Path t, WatchEvent.Kind<?> u) {
            if (u.equals(StandardWatchEventKinds.ENTRY_CREATE) && Files.isDirectory(t, new LinkOption[0])) {
                try {
                    this.listeningTo.add(t);
                    this.mgr.watch(t, this, ALL);
                }
                catch (IOException ex) {
                    Logger.getLogger(WatchManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.set.contains(u)) {
                this.consumer.accept(t, u);
            }
        }

        static {
            HashSet<WatchEvent.Kind<Path>> kinds = new HashSet<WatchEvent.Kind<Path>>();
            kinds.add(StandardWatchEventKinds.ENTRY_CREATE);
            kinds.add(StandardWatchEventKinds.ENTRY_MODIFY);
            kinds.add(StandardWatchEventKinds.ENTRY_DELETE);
            ALL = Collections.unmodifiableSet(kinds);
        }
    }

    private static class FolderWatchRegistration {
        private final Path folder;
        private final Set<OneWatch> watches = new HashSet<OneWatch>();
        private final Map<WatchEvent.Kind<?>, WatchKey> keyForKind = new IdentityHashMap();

        public FolderWatchRegistration(Path folder) {
            this.folder = folder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            HashSet<OneWatch> ows;
            HashMap kc;
            StringBuilder sb = new StringBuilder();
            Iterator iterator = this;
            synchronized (iterator) {
                kc = new HashMap(this.keyForKind);
                ows = new HashSet<OneWatch>(this.watches);
            }
            for (Map.Entry entry : kc.entrySet()) {
                sb.append("\n\t\t").append(entry.getKey()).append(' ').append(entry.getValue());
            }
            for (OneWatch oneWatch : ows) {
                sb.append("\n\t\t\t").append(oneWatch);
            }
            return sb.toString();
        }

        void ensureClosed() {
            for (Map.Entry<WatchEvent.Kind<?>, WatchKey> e : this.keyForKind.entrySet()) {
                e.getValue().cancel();
            }
            this.keyForKind.clear();
        }

        boolean remove(Path path, BiConsumer<Path, WatchEvent.Kind<?>> consumer) {
            HashSet<OneWatch> toRemove = new HashSet<OneWatch>();
            for (OneWatch ow : this.watches) {
                if (!ow.is(path, consumer)) continue;
                toRemove.add(ow);
            }
            if (!toRemove.isEmpty()) {
                this.cleanup(toRemove);
            }
            return this.isEmpty();
        }

        boolean isEmpty() {
            if (this.watches.isEmpty()) {
                this.ensureClosed();
                return true;
            }
            Set<OneWatch> toRemove = this.gc();
            this.cleanup(toRemove);
            boolean result = this.watches.isEmpty();
            if (result) {
                this.ensureClosed();
            }
            return result;
        }

        void cleanup(Set<OneWatch> toRemove) {
            if (!toRemove.isEmpty()) {
                this.watches.removeAll(toRemove);
                HashSet possiblyRemoveKeys = new HashSet();
                toRemove.forEach(ow -> ((OneWatch)ow).kinds.stream().map(k -> this.keyForKind.get(k)).filter(key -> key != null).forEach(key -> possiblyRemoveKeys.add(key)));
                Set<WatchEvent.Kind<?>> remaining = this.kinds();
                remaining.stream().map(rem -> this.keyForKind.get(rem)).filter(wk -> wk != null).forEachOrdered(wk -> possiblyRemoveKeys.remove(wk));
                possiblyRemoveKeys.forEach(remove -> remove.cancel());
            }
        }

        int eachConsumer(WatchKey key, WatchEvent<?> evt, Consumer<BiConsumer<Path, WatchEvent.Kind<?>>> cc) {
            if (!(evt.context() instanceof Path)) {
                return 0;
            }
            WatchEvent<Path> e = evt;
            WatchKey k = this.keyForKind.get(evt.kind());
            int result = 0;
            if (k != null && k.equals(key)) {
                for (OneWatch w : this.watches) {
                    BiConsumer<Path, WatchEvent.Kind<?>> c = w.match(this.folder, e);
                    if (c == null) continue;
                    ++result;
                    cc.accept(c);
                }
            }
            return result;
        }

        synchronized void add(Path target, WatchService svf, BiConsumer<Path, WatchEvent.Kind<?>> c, Set<WatchEvent.Kind<?>> kinds) throws IOException {
            Set<OneWatch> deadButNotRemoved = this.gc();
            Set<WatchEvent.Kind<?>> currentKinds = this.keyForKind.keySet();
            HashSet toAdd = new HashSet(kinds);
            toAdd.removeAll(currentKinds);
            OneWatch nue = new OneWatch(target, kinds, c);
            this.watches.add(nue);
            this.watches.removeAll(deadButNotRemoved);
            if (!toAdd.isEmpty()) {
                WatchKey wk = this.folder.register(svf, kinds.toArray(new WatchEvent.Kind[toAdd.size()]));
                for (WatchEvent.Kind kind : toAdd) {
                    this.keyForKind.put(kind, wk);
                }
            }
            HashSet noLongerNeeded = new HashSet(this.keyForKind.keySet());
            noLongerNeeded.removeAll(kinds);
            for (WatchEvent.Kind kind : noLongerNeeded) {
                WatchKey key = this.keyForKind.remove(kind);
                if (key == null) continue;
                key.cancel();
            }
        }

        private WatchEvent.Kind<?>[] kindsArray() {
            Set<WatchEvent.Kind<?>> kinds = this.kinds();
            return kinds.toArray(new WatchEvent.Kind[kinds.size()]);
        }

        private Set<WatchEvent.Kind<?>> kinds() {
            HashSet all = new HashSet();
            for (OneWatch ow : this.watches) {
                all.addAll(ow.kinds);
            }
            return all;
        }

        Set<OneWatch> gc() {
            HashSet<OneWatch> toRemove = new HashSet<OneWatch>();
            for (OneWatch ow : this.watches) {
                if (!ow.isGone()) continue;
                toRemove.add(ow);
            }
            return toRemove;
        }

        FolderWatchRegistration add(Path target, BiConsumer<Path, WatchEvent.Kind<?>> consumer, WatchEvent.Kind<?> kind, WatchEvent.Kind<?> ... more) {
            HashSet kinds = new HashSet();
            kinds.add(kind);
            kinds.addAll(Arrays.asList(more));
            this.watches.add(new OneWatch(target, kinds, consumer));
            return this;
        }

        static class OneWatch {
            private final Set<WatchEvent.Kind<?>> kinds;
            private final Reference<BiConsumer<Path, WatchEvent.Kind<?>>> consumer;
            private final Path target;
            private boolean isFile;

            public OneWatch(Path target, Set<WatchEvent.Kind<?>> kinds, BiConsumer<Path, WatchEvent.Kind<?>> consumer) {
                this.kinds = kinds;
                this.consumer = new WeakReference(consumer);
                this.target = target;
                this.isFile = !Files.isDirectory(target, new LinkOption[0]);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.target);
                if (this.isFile) {
                    sb.append(" (file)");
                }
                sb.append(" alive? ").append(this.consumer.get() != null);
                for (WatchEvent.Kind<?> k : this.kinds) {
                    sb.append(' ').append(k.name());
                }
                sb.append(' ').append(this.consumer.get());
                return sb.toString();
            }

            boolean is(Path path, BiConsumer<Path, WatchEvent.Kind<?>> consumer) {
                if (!this.target.equals(path)) {
                    return false;
                }
                if (consumer != null) {
                    BiConsumer<Path, WatchEvent.Kind<?>> ours = this.consumer.get();
                    return consumer.equals(ours);
                }
                return true;
            }

            BiConsumer<Path, WatchEvent.Kind<?>> match(Path parent, WatchEvent<Path> event) {
                if (!this.kinds.contains(event.kind())) {
                    return null;
                }
                Path et = event.context();
                if (this.isFile) {
                    Path real = parent.resolve(et);
                    if (this.target.equals(real)) {
                        return this.consumer.get();
                    }
                } else {
                    return this.consumer.get();
                }
                return null;
            }

            boolean isGone() {
                return this.consumer.get() == null;
            }
        }
    }

    public static interface RecursiveWatcher {
        public Set<? extends Path> attach();

        public Set<? extends Path> detach();
    }
}

