/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.path;

import com.mastfrog.util.path.UnixPath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;

final class WrappedUPath
implements UnixPath {
    private final Path delegate;
    static final WrappedUPath EMPTY_PATH = WrappedUPath.of(Paths.get("", new String[0]));
    static final WrappedUPath EMPTY_PATH_ABS = WrappedUPath.of(Paths.get("/", new String[0]));

    WrappedUPath(Path delegate) {
        this.delegate = delegate;
        assert (!(delegate instanceof WrappedUPath)) : "double-wrapped";
    }

    static WrappedUPath of(Path p) {
        if (p instanceof WrappedUPath) {
            return (WrappedUPath)p;
        }
        if (p != null) {
            return new WrappedUPath(p);
        }
        return null;
    }

    @Override
    public UnixPath toRelativePath() {
        if (this.isAbsolute()) {
            return new WrappedUPath(Paths.get(File.separator, new String[0]).relativize(this.delegate));
        }
        return this;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.delegate.getFileSystem();
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public UnixPath getRoot() {
        return WrappedUPath.of(this.delegate.getRoot());
    }

    @Override
    public UnixPath getFileName() {
        return WrappedUPath.of(this.delegate.getFileName());
    }

    @Override
    public UnixPath getParent() {
        return WrappedUPath.of(this.delegate.getParent());
    }

    @Override
    public int getNameCount() {
        return this.delegate.getNameCount();
    }

    @Override
    public UnixPath getName(int index) {
        return WrappedUPath.of(this.delegate.getName(index));
    }

    @Override
    public WrappedUPath subpath(int beginIndex, int endIndex) {
        return WrappedUPath.of(this.delegate.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public boolean startsWith(String other) {
        return this.delegate.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.delegate.endsWith(other);
    }

    @Override
    public boolean endsWith(String other) {
        return this.delegate.endsWith(other);
    }

    @Override
    public UnixPath normalize() {
        return WrappedUPath.of(this.delegate.normalize());
    }

    @Override
    public UnixPath resolve(Path other) {
        return WrappedUPath.of(this.delegate.resolve(other));
    }

    @Override
    public UnixPath resolve(String other) {
        return WrappedUPath.of(this.delegate.resolve(other));
    }

    @Override
    public UnixPath resolveSibling(Path other) {
        return WrappedUPath.of(this.delegate.resolveSibling(other));
    }

    @Override
    public UnixPath resolveSibling(String other) {
        return WrappedUPath.of(this.delegate.resolveSibling(other));
    }

    @Override
    public UnixPath relativize(Path other) {
        return WrappedUPath.of(this.delegate.relativize(other));
    }

    @Override
    public URI toUri() {
        return this.delegate.toUri();
    }

    @Override
    public UnixPath toAbsolutePath() {
        return WrappedUPath.of(this.delegate.toAbsolutePath());
    }

    @Override
    public UnixPath toRealPath(LinkOption ... options) throws IOException {
        return WrappedUPath.of(this.delegate.toRealPath(options));
    }

    @Override
    public File toFile() {
        return this.delegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.delegate.register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.delegate.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        return new It(this.delegate.iterator());
    }

    @Override
    public int compareTo(Path other) {
        return this.delegate.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Path toNativePath() {
        return this.delegate;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof WrappedUPath) {
            WrappedUPath other = (WrappedUPath)o;
            return this.delegate.equals(other.delegate);
        }
        if (o instanceof Path) {
            return this.delegate.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    static class It
    implements Iterator<Path> {
        private final Iterator<Path> orig;

        public It(Iterator<Path> orig) {
            this.orig = orig;
        }

        @Override
        public boolean hasNext() {
            return this.orig.hasNext();
        }

        @Override
        public Path next() {
            return WrappedUPath.of(this.orig.next());
        }
    }
}

