/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.Strings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class AlignedText {
    private List<Line> lines = new ArrayList<Line>(20);
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###,###,###,##0.0###");
    private DecimalFormat integerFormat = new DecimalFormat("###,###,###,###,###,###,##0");

    public AlignedText() {
    }

    public AlignedText(String tabbed) {
        for (String line : tabbed.split("\n")) {
            Line l = new Line(this);
            for (String col : line.split("\t")) {
                l.append(col).end();
            }
            l.end();
        }
    }

    public static String formatTabbed(CharSequence seq) {
        return new AlignedText(seq.toString()).toString();
    }

    AlignedText add(Line line) {
        this.lines.add(line);
        return this;
    }

    private int columnWidth(int columnIndex) {
        int result = 0;
        for (Line line : this.lines) {
            result = Math.max(result, line.length(columnIndex));
        }
        return result;
    }

    private boolean isNumbers(int columnIndex) {
        boolean result = true;
        for (Line line : this.lines) {
            CharSequence sq = line.getColumn(columnIndex);
            String cc = sq.toString().trim();
            if (cc.isEmpty() || !Strings.isDigits(cc)) continue;
            result = false;
            break;
        }
        return result;
    }

    private String pad(int length) {
        char[] result = new char[length];
        Arrays.fill(result, ' ');
        return new String(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Line line : this.lines) {
            String txt = line.toString();
            while (txt.length() > 0 && Character.isWhitespace(txt.charAt(txt.length() - 1))) {
                txt = txt.substring(0, txt.length() - 1);
            }
            sb.append(txt).append('\n');
        }
        return sb.toString();
    }

    public String end() {
        return this.toString();
    }

    public AlignedText setNumberFormat(DecimalFormat fmt) {
        this.integerFormat = fmt;
        return this;
    }

    public AlignedText setDecimalFormat(DecimalFormat fmt) {
        this.decimalFormat = fmt;
        return this;
    }

    public AStringBuilder append(String s) {
        Line l = new Line(this);
        return l.append(s);
    }

    public AStringBuilder append(char s) {
        Line l = new Line(this);
        return l.append(s);
    }

    public AStringBuilder append(int val) {
        Line l = new Line(this);
        return l.append(this.integerFormat.format(val));
    }

    public AStringBuilder append(long val) {
        Line l = new Line(this);
        return l.append(this.integerFormat.format(val));
    }

    public AStringBuilder append(short val) {
        Line l = new Line(this);
        return l.append(this.integerFormat.format(val));
    }

    public AStringBuilder append(byte val) {
        Line l = new Line(this);
        return l.append(this.integerFormat.format(val));
    }

    public AStringBuilder append(double val) {
        Line l = new Line(this);
        return l.append(this.decimalFormat.format(val));
    }

    public AStringBuilder append(float val) {
        Line l = new Line(this);
        return l.append(this.decimalFormat.format(val));
    }

    public static void main(String[] args) {
        String s = new AlignedText().append("GET/HEAD").end().append("/sp").end().append("Do something cool").end().append("23").end().end().append("GET").end().append("/some/long/path/too").end().append("Hey now what is this doing?").end().append("52043").end().end().end();
        System.out.println(s);
        System.out.println("----------------------\n\n");
        String tabbed = "FOO\t/path/to/foo\t341\tI like this thing I think\t3920202\nBAR/BAZ\t/shrimp\t52\tWell, that's short\t39\n";
        System.out.println(new AlignedText(tabbed));
    }

    public static final class AStringBuilder
    implements Appendable,
    AutoCloseable,
    CharSequence,
    Endable<Line>,
    Lineable<AStringBuilder> {
        private final StringBuilder sb = new StringBuilder();
        private final Line line;
        private boolean added;

        AStringBuilder(Line line) {
            this.line = line;
        }

        @Override
        public Line end() {
            if (!this.added) {
                this.added = true;
                this.line.add(this);
            }
            return this.line;
        }

        @Override
        public void close() {
            this.end();
        }

        public AStringBuilder append(Object obj) {
            this.sb.append(obj);
            return this;
        }

        public AStringBuilder append(String str) {
            this.sb.append(str);
            return this;
        }

        public AStringBuilder append(StringBuffer sb) {
            this.sb.append(sb);
            return this;
        }

        @Override
        public AStringBuilder append(CharSequence s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public AStringBuilder append(CharSequence s, int start, int end) {
            this.sb.append(s, start, end);
            return this;
        }

        public AStringBuilder append(char[] str) {
            this.sb.append(str);
            return this;
        }

        public AStringBuilder append(char[] str, int offset, int len) {
            this.sb.append(str, offset, len);
            return this;
        }

        public AStringBuilder append(boolean b) {
            this.sb.append(b);
            return this;
        }

        @Override
        public AStringBuilder append(char c) {
            this.sb.append(c);
            return this;
        }

        public AStringBuilder append(int i) {
            this.sb.append(i);
            return this;
        }

        public AStringBuilder append(long lng) {
            this.sb.append(lng);
            return this;
        }

        public AStringBuilder append(float f) {
            this.sb.append(f);
            return this;
        }

        public AStringBuilder append(double d) {
            this.sb.append(d);
            return this;
        }

        public AStringBuilder appendCodePoint(int codePoint) {
            this.sb.appendCodePoint(codePoint);
            return this;
        }

        public AStringBuilder delete(int start, int end) {
            this.sb.delete(start, end);
            return this;
        }

        public AStringBuilder deleteCharAt(int index) {
            this.sb.deleteCharAt(index);
            return this;
        }

        public AStringBuilder replace(int start, int end, String str) {
            this.sb.replace(start, end, str);
            return this;
        }

        public AStringBuilder insert(int index, char[] str, int offset, int len) {
            this.sb.insert(index, str, offset, len);
            return this;
        }

        public AStringBuilder insert(int offset, Object obj) {
            this.sb.insert(offset, obj);
            return this;
        }

        public AStringBuilder insert(int offset, String str) {
            this.sb.insert(offset, str);
            return this;
        }

        public AStringBuilder insert(int offset, char[] str) {
            this.sb.insert(offset, str);
            return this;
        }

        public AStringBuilder insert(int dstOffset, CharSequence s) {
            this.sb.insert(dstOffset, s);
            return this;
        }

        public AStringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
            this.sb.insert(dstOffset, s, start, end);
            return this;
        }

        public AStringBuilder insert(int offset, boolean b) {
            this.sb.insert(offset, b);
            return this;
        }

        public AStringBuilder insert(int offset, char c) {
            this.sb.insert(offset, c);
            return this;
        }

        public AStringBuilder insert(int offset, int i) {
            this.sb.insert(offset, i);
            return this;
        }

        public AStringBuilder insert(int offset, long l) {
            this.sb.insert(offset, l);
            return this;
        }

        public AStringBuilder insert(int offset, float f) {
            this.sb.insert(offset, f);
            return this;
        }

        public AStringBuilder insert(int offset, double d) {
            this.sb.insert(offset, d);
            return this;
        }

        public int indexOf(String str) {
            return this.sb.indexOf(str);
        }

        public int indexOf(String str, int fromIndex) {
            return this.sb.indexOf(str, fromIndex);
        }

        public int lastIndexOf(String str) {
            return this.sb.lastIndexOf(str);
        }

        public int lastIndexOf(String str, int fromIndex) {
            return this.sb.lastIndexOf(str, fromIndex);
        }

        public AStringBuilder reverse() {
            this.sb.reverse();
            return this;
        }

        @Override
        public String toString() {
            return this.sb.toString();
        }

        @Override
        public int length() {
            return this.sb.length();
        }

        public int capacity() {
            return this.sb.capacity();
        }

        public void ensureCapacity(int minimumCapacity) {
            this.sb.ensureCapacity(minimumCapacity);
        }

        public void trimToSize() {
            this.sb.trimToSize();
        }

        public void setLength(int newLength) {
            this.sb.setLength(newLength);
        }

        @Override
        public char charAt(int index) {
            return this.sb.charAt(index);
        }

        public int codePointAt(int index) {
            return this.sb.codePointAt(index);
        }

        public int codePointBefore(int index) {
            return this.sb.codePointBefore(index);
        }

        public int codePointCount(int beginIndex, int endIndex) {
            return this.sb.codePointCount(beginIndex, endIndex);
        }

        public int offsetByCodePoints(int index, int codePointOffset) {
            return this.sb.offsetByCodePoints(index, codePointOffset);
        }

        public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
            this.sb.getChars(srcBegin, srcEnd, dst, dstBegin);
        }

        public void setCharAt(int index, char ch) {
            this.sb.setCharAt(index, ch);
        }

        public String substring(int start) {
            return this.sb.substring(start);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.sb.subSequence(start, end);
        }

        public String substring(int start, int end) {
            return this.sb.substring(start, end);
        }

        @Override
        public IntStream chars() {
            return this.sb.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.sb.codePoints();
        }

        public boolean equals(Object o) {
            if (o instanceof CharSequence) {
                return Strings.charSequencesEqual((CharSequence)o, this.sb, false);
            }
            return false;
        }

        public int hashCode() {
            return Strings.charSequenceHashCode(this.sb);
        }

        @Override
        public AStringBuilder nextLine(String s) {
            return this.end().append(s);
        }
    }

    public static interface Lineable<T> {
        public T nextLine(String var1);
    }

    public static interface Endable<T> {
        public T end();
    }

    public final class Line
    implements Endable<AlignedText>,
    Lineable<AStringBuilder> {
        private final List<AStringBuilder> columns = new ArrayList<AStringBuilder>(10);
        private final AlignedText txt;
        private boolean added;

        Line(AlignedText txt) {
            this.txt = txt;
        }

        CharSequence getColumn(int i) {
            if (i >= this.columns.size()) {
                return "";
            }
            return this.columns.get(i);
        }

        public AStringBuilder append(String s) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(s);
            return b;
        }

        public AStringBuilder append(char s) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(s);
            return b;
        }

        public AStringBuilder append(int val) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(AlignedText.this.integerFormat.format(val));
            return b;
        }

        public AStringBuilder append(long val) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(AlignedText.this.integerFormat.format(val));
            return b;
        }

        public AStringBuilder append(short val) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(AlignedText.this.integerFormat.format(val));
            return b;
        }

        public AStringBuilder append(byte val) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(AlignedText.this.integerFormat.format(val));
            return b;
        }

        public AStringBuilder append(double val) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(AlignedText.this.decimalFormat.format(val));
            return b;
        }

        public AStringBuilder append(float val) {
            AStringBuilder b = new AStringBuilder(this);
            b.append(AlignedText.this.decimalFormat.format(val));
            return b;
        }

        Line add(AStringBuilder b) {
            this.columns.add(b);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.columns.size(); ++i) {
                String pad;
                AStringBuilder c = this.columns.get(i);
                int width = AlignedText.this.columnWidth(i);
                if (AlignedText.this.isNumbers(i)) {
                    pad = AlignedText.this.pad(width - c.length());
                    sb.append(pad).append(c).append("  ");
                    continue;
                }
                pad = AlignedText.this.pad(width - c.length() + 2);
                sb.append(c);
                sb.append(pad);
            }
            return sb.toString();
        }

        @Override
        public AStringBuilder nextLine(String s) {
            this.end();
            return this.txt.append(s);
        }

        @Override
        public AlignedText end() {
            if (!this.added) {
                this.txt.add(this);
            }
            return this.txt;
        }

        int length(int column) {
            if (column >= this.columns.size()) {
                return 0;
            }
            return this.columns.get(column).length();
        }
    }
}

