/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.AppendingCharSequence;
import com.mastfrog.util.strings.ComparableCharSequence;
import com.mastfrog.util.strings.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AppendableCharSequence
implements Appendable,
Comparable<CharSequence>,
CharSequence,
ComparableCharSequence,
AppendingCharSequence {
    private static final int INCREMENT = 10;
    private final List<CharSequence> seqs;
    private int length;
    private int lastElement = -2;
    private int lastCharAtRequested = -2;
    private int lastAggregateLength = -2;

    public AppendableCharSequence(int components) {
        this.seqs = new ArrayList<CharSequence>(components);
    }

    public AppendableCharSequence(char first) {
        this(Strings.singleChar(first));
    }

    public AppendableCharSequence(CharSequence ... seqs) {
        Checks.notNull((String)"seqs", (Object)seqs);
        Checks.noNullElements((String)"seqs", (Object[])seqs);
        this.seqs = new ArrayList<CharSequence>(10);
        for (CharSequence s : seqs) {
            this.seqs.add(s);
            this.length += s.length();
        }
    }

    @Override
    public int compareTo(CharSequence o) {
        return Strings.compareCharSequences(this, o, false);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (this.length == 0) {
            throw new StringIndexOutOfBoundsException("Length is 0 but requested " + index);
        }
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index + " out of range - length " + this.length);
        }
        if (index == this.length - 1) {
            CharSequence cs = this.seqs.get(this.seqs.size() - 1);
            return cs.charAt(cs.length() - 1);
        }
        if (index == 0) {
            CharSequence cs = this.seqs.get(0);
            return cs.charAt(0);
        }
        int max = this.elementCount();
        int aggLength = 0;
        int ix = 0;
        if (this.lastCharAtRequested >= 0 && index >= this.lastCharAtRequested) {
            ix = this.lastElement;
            aggLength = this.lastAggregateLength;
        }
        for (int i = ix; i < max; ++i) {
            CharSequence seq = this.seqs.get(i);
            int len = seq.length();
            if (index >= aggLength && index < aggLength + len) {
                this.lastCharAtRequested = index;
                this.lastElement = ix;
                this.lastAggregateLength = aggLength;
                return seq.charAt(index - aggLength);
            }
            aggLength += len;
            ++ix;
        }
        throw new StringIndexOutOfBoundsException(index + " from length " + this.length);
    }

    public int elementCount() {
        return this.seqs.size();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int len;
        if (start > end) {
            throw new IllegalArgumentException("Start greater than end " + start + " > " + end);
        }
        if (start == end) {
            return Strings.emptyCharSequence();
        }
        if (start == 0 && end == this.length) {
            return this;
        }
        int aggregateLength = 0;
        int max = this.elementCount();
        AppendableCharSequence result = new AppendableCharSequence(new CharSequence[0]);
        for (int i = 0; i < max && aggregateLength < end + 1; aggregateLength += len, ++i) {
            CharSequence curr = this.seqs.get(i);
            len = curr.length();
            int first = Math.max(0, start - aggregateLength);
            int last = Math.min(len, Math.min(end + 1 - start, first + (end - aggregateLength)));
            if (end >= aggregateLength + len) {
                last = len;
            } else if (end <= aggregateLength + len) {
                last = end - aggregateLength;
            }
            if (last <= first) continue;
            CharSequence sub = curr.subSequence(first, last);
            result.append(sub);
        }
        return result;
    }

    @Override
    public AppendableCharSequence append(CharSequence csq) {
        Checks.notNull((String)"seq", (Object)csq);
        if (csq instanceof AppendableCharSequence) {
            AppendableCharSequence a = (AppendableCharSequence)csq;
            for (CharSequence cs : a.seqs) {
                this.append(cs);
            }
        } else {
            int len = csq.length();
            if (len == 0) {
                return this;
            }
            if (len == 1) {
                ++this.length;
                this.seqs.add(Strings.singleChar(csq.charAt(0)));
                return this;
            }
            this.length += len;
            this.seqs.add(csq);
        }
        return this;
    }

    @Override
    public AppendableCharSequence append(CharSequence csq, int start, int end) {
        Checks.notNull((String)"csq", (Object)csq);
        return this.append(csq.subSequence(start, end));
    }

    public AppendableCharSequence consolidate() {
        return new AppendableCharSequence(this.toString());
    }

    @Override
    public AppendableCharSequence append(int val) {
        return this.append(Integer.toString(val));
    }

    @Override
    public AppendableCharSequence append(long val) {
        return this.append(Long.toString(val));
    }

    @Override
    public AppendableCharSequence append(double val) {
        return this.append(Double.toString(val));
    }

    @Override
    public AppendableCharSequence append(float val) {
        return this.append(Float.toString(val));
    }

    @Override
    public AppendableCharSequence append(boolean val) {
        return this.append(Boolean.toString(val));
    }

    @Override
    public AppendableCharSequence append(short val) {
        return this.append(Short.toString(val));
    }

    @Override
    public AppendableCharSequence append(char c) {
        return this.append(Strings.singleChar(c));
    }

    @Override
    public AppendableCharSequence appendObject(Object o) {
        if (o instanceof CharSequence) {
            return this.append((CharSequence)o);
        }
        return this.append(Objects.toString(o));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.length);
        for (CharSequence seq : this.seqs) {
            sb.append(seq);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        CharSequence seq;
        int len;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof CharSequence && (len = (seq = (CharSequence)o).length()) == this.length()) {
            for (int i = 0; i < len; ++i) {
                if (this.charAt(i) == seq.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Strings.charSequenceHashCode(this);
    }
}

