/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.CharSequenceInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class CharSequenceInputStreamImpl
extends CharSequenceInputStream {
    private final CharsetEncoder encoder;
    private final CharBuffer chars;
    private final ByteBuffer outBuffer;
    private final CharSequenceInputStream.EncodingErrorBehavior errorBehavior;
    private boolean closed;

    public CharSequenceInputStreamImpl(CharSequence toRead) {
        this(toRead, null);
    }

    public CharSequenceInputStreamImpl(CharSequence toRead, Charset encoding) {
        this(toRead, encoding, -1);
    }

    public CharSequenceInputStreamImpl(CharSequence toRead, Charset encoding, int outBufferSize) {
        this(toRead, encoding, outBufferSize, CharSequenceInputStream.EncodingErrorBehavior.REPLACE);
    }

    public CharSequenceInputStreamImpl(CharSequence toRead, Charset encoding, int outBufferSize, CharSequenceInputStream.EncodingErrorBehavior errorBehavior) {
        this.chars = CharBuffer.wrap(toRead);
        this.errorBehavior = errorBehavior;
        this.encoder = (encoding == null ? StandardCharsets.UTF_8 : encoding).newEncoder();
        if (outBufferSize <= 0) {
            int estimatedBytes = (int)Math.max(2.0, Math.ceil(this.encoder.averageBytesPerChar() * (float)toRead.length()));
            this.outBuffer = ByteBuffer.allocate(estimatedBytes);
        } else {
            this.outBuffer = ByteBuffer.allocate(Math.max(2, outBufferSize));
        }
        this.outBuffer.limit(0);
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.ensureBytesAvailable()) {
            return -1;
        }
        return this.outBuffer.get();
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        if (b.length == 0) {
            return 0;
        }
        if (!this.ensureBytesAvailable()) {
            return -1;
        }
        int numBytes = Math.min(b.length, this.outBuffer.remaining());
        this.outBuffer.get(b, 0, numBytes);
        return numBytes;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        if (off + len > b.length) {
            throw new IllegalArgumentException("Offset + length = " + (off + len) + " but array size is " + b.length);
        }
        if (!this.ensureBytesAvailable()) {
            return -1;
        }
        int numBytes = Math.min(len, this.outBuffer.remaining());
        this.outBuffer.get(b, off, numBytes);
        return numBytes;
    }

    @Override
    public synchronized CharSequenceInputStream rewind() {
        this.encoder.reset();
        this.outBuffer.clear();
        this.outBuffer.limit(0);
        this.chars.position(0);
        this.closed = false;
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        this.chars.position(this.chars.capacity());
        this.outBuffer.clear();
        this.outBuffer.limit(0);
        this.closed = true;
    }

    @Override
    public synchronized long transferTo(OutputStream out) throws IOException {
        long result = 0L;
        while (this.ensureBytesAvailable()) {
            byte[] bytes = new byte[this.outBuffer.remaining()];
            this.outBuffer.get(bytes);
            out.write(bytes);
            result += (long)bytes.length;
        }
        return result;
    }

    @Override
    public synchronized byte[] readAllBytes() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.transferTo(out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    public synchronized int available() throws IOException {
        int charsRemaining = this.chars.remaining();
        return (int)Math.ceil(this.encoder.averageBytesPerChar() * (float)charsRemaining);
    }

    private boolean ensureBytesAvailable() throws IOException {
        assert (Thread.holdsLock(this)) : "Not under lock";
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        if (!this.outBuffer.hasRemaining()) {
            return this.encodeSomeBytes();
        }
        return true;
    }

    private boolean encodeSomeBytes() throws IOException {
        assert (Thread.holdsLock(this)) : "Not under lock";
        assert (!this.outBuffer.hasRemaining()) : "Should not get here with unread bytes";
        if (!this.chars.hasRemaining()) {
            return false;
        }
        this.outBuffer.clear();
        CoderResult coderResult = this.encoder.encode(this.chars, this.outBuffer, false);
        if (coderResult.isUnmappable() || coderResult.isMalformed()) {
            switch (this.errorBehavior) {
                case OMIT: {
                    this.encoder.reset();
                    this.chars.position(Math.min(this.chars.limit(), this.chars.position() + coderResult.length()));
                    this.outBuffer.flip();
                    return this.outBuffer.hasRemaining() || this.chars.hasRemaining();
                }
                case THROW: {
                    coderResult.throwException();
                }
                case REPLACE: {
                    int estimatedMangledCharacters = (int)Math.min(1.0f, (float)coderResult.length() / this.encoder.averageBytesPerChar());
                    char[] c = new char[estimatedMangledCharacters];
                    char fillChar = this.encoder.canEncode('\ufffd') ? (char)'\ufffd' : '-';
                    Arrays.fill(c, fillChar);
                    CharBuffer cb = CharBuffer.wrap(c);
                    this.encoder.encode(cb, this.outBuffer, false);
                    this.chars.position(Math.min(this.chars.limit(), this.chars.position() + coderResult.length()));
                }
            }
        }
        this.outBuffer.flip();
        return this.outBuffer.hasRemaining();
    }

    public String toString() {
        return "StringInputStream(chars @" + this.chars.position() + "/" + this.chars.capacity() + " bytes@ " + this.outBuffer.position() + "/" + this.outBuffer.capacity() + " for\n" + this.chars + ")";
    }
}

