/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.Strings;

public interface ComparableCharSequence
extends CharSequence,
Comparable<CharSequence> {
    public static final ComparableCharSequence EMPTY = new ComparableCharSequence(){

        @Override
        public int compareTo(CharSequence o) {
            return o.length() == 0 ? 0 : -1;
        }

        @Override
        public int indexOf(char c) {
            return -1;
        }

        @Override
        public int lastIndexOf(char c) {
            return -1;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new ArrayIndexOutOfBoundsException("0 length string but requested char " + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start == 0 && end == 0) {
                return this;
            }
            throw new ArrayIndexOutOfBoundsException("0 length string but requested substring " + start + " -> " + end);
        }

        public boolean equals(Object o) {
            return o instanceof CharSequence && ((CharSequence)o).length() == 0;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    @Override
    default public int compareTo(CharSequence o) {
        return Strings.compareCharSequences(this, o, false);
    }

    default public boolean startsWith(CharSequence seq) {
        int myLen = this.length();
        int seqLength = seq.length();
        if (seqLength > myLen) {
            return false;
        }
        for (int i = seqLength - 1; i >= 0; --i) {
            if (this.charAt(i) == seq.charAt(i)) continue;
            return false;
        }
        return true;
    }

    default public int indexOf(char c) {
        int len = this.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (c != this.charAt(i)) continue;
                return i;
            }
        }
        return -1;
    }

    default public int lastIndexOf(char c) {
        int len = this.length();
        if (len > 0) {
            for (int i = len - 1; i >= 0; --i) {
                if (c != this.charAt(i)) continue;
                return i;
            }
        }
        return -1;
    }
}

