/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.AppendingCharSequence;
import com.mastfrog.util.strings.ComparableCharSequence;
import com.mastfrog.util.strings.Strings;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class ConcatCharSequence
implements CharSequence,
Appendable,
AppendingCharSequence,
ComparableCharSequence {
    private final List<CharSequence> chars;
    private int hash = 0;

    public ConcatCharSequence() {
        this.chars = new ArrayList<CharSequence>(10);
    }

    public ConcatCharSequence(int val) {
        this.chars = new ArrayList<CharSequence>(val);
    }

    public ConcatCharSequence(char c) {
        this();
        this.chars.add(Strings.singleChar(c));
    }

    public ConcatCharSequence(CharSequence initial) {
        this();
        this.chars.add(initial);
    }

    @Override
    public ConcatCharSequence append(char ch) {
        this.chars.add(Strings.singleChar(ch));
        this.hash = 0;
        return this;
    }

    @Override
    public ConcatCharSequence append(CharSequence buffer) {
        if (buffer == this) {
            throw new IllegalArgumentException("Add to self");
        }
        if (buffer instanceof ConcatCharSequence) {
            assert (this.doesNotContainSelf((ConcatCharSequence)buffer)) : "Indirectly adding self to self";
            this.chars.addAll(((ConcatCharSequence)buffer).chars);
            this.hash = 0;
            return this;
        }
        this.chars.add(buffer);
        this.hash = 0;
        return this;
    }

    private boolean doesNotContainSelf(ConcatCharSequence seq) {
        return seq.doesNotContain(this);
    }

    private boolean doesNotContain(ConcatCharSequence seq) {
        for (CharSequence cs : this.chars) {
            if (cs == seq) {
                return false;
            }
            if (!(cs instanceof ConcatCharSequence)) continue;
            return ((ConcatCharSequence)cs).doesNotContain(seq);
        }
        return true;
    }

    public ConcatCharSequence consolidate() {
        String s = this.toString();
        this.chars.clear();
        this.chars.add(s);
        this.hash = 0;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.chars.isEmpty() || this.length() == 0;
    }

    public void clear() {
        this.chars.clear();
    }

    @Override
    public int length() {
        int result = 0;
        for (CharSequence cb : this.chars) {
            result += cb.length();
        }
        return result;
    }

    @Override
    public char charAt(int index) {
        int pos = 0;
        for (CharSequence cb : this.chars) {
            if (index >= pos && index < cb.length() + pos) {
                return cb.charAt(index - pos);
            }
            pos += cb.length();
        }
        throw new IndexOutOfBoundsException(index + " of " + this.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == end) {
            return new ConcatCharSequence();
        }
        ConcatCharSequence result = null;
        int position = 0;
        for (CharSequence currBuffer : this.chars) {
            if (start >= position && start < currBuffer.length() + position) {
                if (end <= position + currBuffer.length()) {
                    CharSequence res = currBuffer.subSequence(start - position, end - position);
                    return res;
                }
                if (start == position) {
                    if (result == null) {
                        result = new ConcatCharSequence();
                    }
                    result.append(currBuffer);
                } else {
                    if (result == null) {
                        result = new ConcatCharSequence();
                    }
                    result.append(currBuffer.subSequence(start - position, currBuffer.length()));
                }
            } else if (start <= position && end >= position + currBuffer.length()) {
                if (result == null) {
                    result = new ConcatCharSequence();
                }
                result.append(currBuffer);
            } else if (start <= position && end < position + currBuffer.length()) {
                if (result == null) {
                    result = new ConcatCharSequence();
                }
                result.append(currBuffer.subSequence(0, end - position));
                break;
            }
            position += currBuffer.length();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence cb : this.chars) {
            sb.append(cb);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o == this ? true : (o instanceof String ? this.toString().equals(o) : (o instanceof CharSequence ? this.contentEquals((CharSequence)o, this) : false));
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (CharSequence cb : this.chars) {
                int max = cb.length();
                for (int i = 0; i < max; ++i) {
                    h = 31 * h + cb.charAt(i);
                }
            }
            this.hash = h;
        }
        return h;
    }

    private boolean contentEquals(CharSequence a, CharSequence b) {
        boolean result;
        boolean bl = result = a.length() == b.length();
        if (result) {
            int max = a.length();
            for (int i = 0; i < max; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public ConcatCharSequence append(CharSequence csq, int start, int end) {
        this.append(csq.subSequence(start, end));
        return this;
    }
}

