/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.strings.ComparableCharSequence;
import com.mastfrog.util.strings.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class EightBitStrings
implements Serializable {
    private final InternTable INTERN_TABLE = new InternTable();
    public final CharSequence DOT = this.create(".");
    public final CharSequence QUOTE = this.create("\"");
    public final CharSequence SPACE = this.create(" ");
    public final CharSequence QUOTE_SPACE = this.create("\" ");
    public final CharSequence CLOSE_OPEN_QUOTE = this.create("\" \"");
    private final boolean disabled;
    private final boolean aggressive;
    private final boolean ascii;
    static boolean debug;

    public EightBitStrings(boolean disabled) {
        this(disabled, false, true);
    }

    public EightBitStrings(boolean disabled, boolean aggressive, boolean ascii) {
        this.disabled = disabled;
        this.aggressive = aggressive;
        this.ascii = ascii;
    }

    public Charset charset() {
        return this.ascii ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8;
    }

    public void clear() {
        this.INTERN_TABLE.dispose();
    }

    public ComparableCharSequence create(CharSequence string) {
        if (this.disabled) {
            return string instanceof ComparableCharSequence ? (ComparableCharSequence)string : new StringWrapper(string.toString());
        }
        if (this.aggressive) {
            return this.concat(string);
        }
        return this.INTERN_TABLE.intern(string);
    }

    public ComparableCharSequence concat(CharSequence ... seqs) {
        if (seqs.length == 1 && seqs[0] instanceof ComparableCharSequence) {
            return (ComparableCharSequence)seqs[0];
        }
        if (this.disabled) {
            StringBuilder sb = new StringBuilder();
            for (CharSequence c : seqs) {
                sb.append(c);
            }
            return new StringWrapper(sb.toString());
        }
        if (this.aggressive) {
            ArrayList<String> nue = new ArrayList<String>(seqs.length + seqs.length / 2);
            for (CharSequence seq : seqs) {
                if (seq == ComparableCharSequence.EMPTY) continue;
                int ln = seq.length();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < ln; ++i) {
                    char c = seq.charAt(i);
                    if (Character.isLetter(c) || Character.isDigit(c)) {
                        sb.append(c);
                        continue;
                    }
                    nue.add(sb.toString());
                    sb.setLength(0);
                    nue.add(new String(new char[]{c}));
                }
                if (sb.length() <= 0) continue;
                nue.add(sb.toString());
            }
            if (nue.size() != seqs.length) {
                seqs = nue.toArray(new CharSequence[nue.size()]);
            }
        }
        return new Concatenation(this.INTERN_TABLE, seqs);
    }

    public ComparableCharSequence concatQuoted(Collection<Object> seqs) {
        if (this.disabled) {
            StringBuilder sb = new StringBuilder("\"");
            boolean first = true;
            for (Object c : seqs) {
                if (!first) {
                    sb.append(this.SPACE);
                }
                if (c instanceof CharSequence) {
                    sb.append(this.QUOTE);
                }
                sb.append(c);
                if (c instanceof CharSequence) {
                    sb.append(this.QUOTE);
                }
                first = false;
            }
            return new StringWrapper(sb.toString());
        }
        ArrayList<CharSequence> quoted = new ArrayList<CharSequence>(seqs.size() * 3 + 1);
        Iterator<Object> it = seqs.iterator();
        while (it.hasNext()) {
            Object c = it.next();
            if (c instanceof CharSequence) {
                quoted.add(this.QUOTE);
                quoted.add((CharSequence)c);
                if (it.hasNext()) {
                    quoted.add(this.QUOTE_SPACE);
                    continue;
                }
                quoted.add(this.QUOTE);
                continue;
            }
            quoted.add(this.create(c.toString()));
            quoted.add(this.SPACE);
        }
        Concatenation result = new Concatenation(this.INTERN_TABLE, quoted.toArray(new CharSequence[quoted.size()]));
        if (result.entries.length == 1) {
            return result.entries[0];
        }
        return result;
    }

    private byte[] toBytes(CharSequence seq) {
        if (seq instanceof Entry) {
            return ((Entry)seq).bytes;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(seq.toString().getBytes(this.charset()));
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static CharSequence toCharSequence(Charset charset, byte[] bytes) {
        try {
            return charset.newDecoder().decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    int internTableSize() {
        return this.INTERN_TABLE.last + 1;
    }

    List<CharSequence> dumpInternTable() {
        return this.INTERN_TABLE.dumpInternTable();
    }

    static int compareCharSequences(CharSequence a, CharSequence b) {
        if (a == b) {
            return 0;
        }
        int aLength = a.length();
        int bLength = b.length();
        int max = Math.min(aLength, bLength);
        if (a instanceof Entry && b instanceof Entry) {
            Entry ae = (Entry)a;
            Entry be = (Entry)b;
            return ae.compare(be);
        }
        for (int i = 0; i < max; ++i) {
            if (a.charAt(i) > b.charAt(i)) {
                return 1;
            }
            if (a.charAt(i) >= b.charAt(i)) continue;
            return -1;
        }
        if (aLength == bLength) {
            return 0;
        }
        if (aLength > bLength) {
            return 1;
        }
        return -1;
    }

    private static boolean charSequencesEqual(CharSequence a, CharSequence b) {
        int maxB;
        int maxA;
        if (a instanceof Entry && b instanceof Entry) {
            return Arrays.equals(((Entry)a).bytes, ((Entry)b).bytes);
        }
        if (a instanceof Concatenation && b instanceof Concatenation) {
            Concatenation ca = (Concatenation)a;
            Concatenation cb = (Concatenation)b;
            if (ca.entries.length > 0 && cb.entries.length > 0 && ca.entries[0].compareChars(cb.entries[0]) != 0) {
                return false;
            }
        }
        if ((maxA = a.length()) != (maxB = b.length())) {
            return false;
        }
        for (int i = 0; i < maxA; ++i) {
            char bb;
            char aa = a.charAt(i);
            if (aa == (bb = b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static class StringWrapper
    implements ComparableCharSequence,
    Serializable {
        private final String s;

        public StringWrapper(String s) {
            this.s = s.intern();
        }

        @Override
        public int length() {
            return this.s.length();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public char charAt(int index) {
            return this.s.charAt(index);
        }

        public int codePointAt(int index) {
            return this.s.codePointAt(index);
        }

        public int codePointBefore(int index) {
            return this.s.codePointBefore(index);
        }

        public int codePointCount(int beginIndex, int endIndex) {
            return this.s.codePointCount(beginIndex, endIndex);
        }

        public int offsetByCodePoints(int index, int codePointOffset) {
            return this.s.offsetByCodePoints(index, codePointOffset);
        }

        public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
            this.s.getChars(srcBegin, srcEnd, dst, dstBegin);
        }

        public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
            this.s.getBytes(srcBegin, srcEnd, dst, dstBegin);
        }

        public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
            return this.s.getBytes(charsetName);
        }

        public byte[] getBytes(Charset charset) {
            return this.s.getBytes(charset);
        }

        public byte[] getBytes() {
            return this.s.getBytes();
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (anObject == null) {
                return false;
            }
            if (!(anObject instanceof CharSequence)) {
                return false;
            }
            if (anObject instanceof String) {
                return this.s.equals(anObject);
            }
            return this.s.contentEquals((CharSequence)anObject);
        }

        public boolean contentEquals(StringBuffer sb) {
            return this.s.contentEquals(sb);
        }

        public boolean contentEquals(CharSequence cs) {
            return this.s.contentEquals(cs);
        }

        public boolean equalsIgnoreCase(String anotherString) {
            return this.s.equalsIgnoreCase(anotherString);
        }

        @Override
        public int compareTo(CharSequence anotherString) {
            return EightBitStrings.compareCharSequences(this, anotherString);
        }

        public int compareToIgnoreCase(String str) {
            return this.s.compareToIgnoreCase(str);
        }

        public boolean regionMatches(int toffset, String other, int ooffset, int len) {
            return this.s.regionMatches(toffset, other, ooffset, len);
        }

        public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
            return this.s.regionMatches(ignoreCase, toffset, other, ooffset, len);
        }

        public boolean startsWith(String prefix, int toffset) {
            return this.s.startsWith(prefix, toffset);
        }

        public boolean startsWith(String prefix) {
            return this.s.startsWith(prefix);
        }

        public boolean endsWith(String suffix) {
            return this.s.endsWith(suffix);
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public int indexOf(int ch) {
            return this.s.indexOf(ch);
        }

        public int indexOf(int ch, int fromIndex) {
            return this.s.indexOf(ch, fromIndex);
        }

        public int lastIndexOf(int ch) {
            return this.s.lastIndexOf(ch);
        }

        public int lastIndexOf(int ch, int fromIndex) {
            return this.s.lastIndexOf(ch, fromIndex);
        }

        public int indexOf(String str) {
            return this.s.indexOf(str);
        }

        public int indexOf(String str, int fromIndex) {
            return this.s.indexOf(str, fromIndex);
        }

        public int lastIndexOf(String str) {
            return this.s.lastIndexOf(str);
        }

        public int lastIndexOf(String str, int fromIndex) {
            return this.s.lastIndexOf(str, fromIndex);
        }

        public String substring(int beginIndex) {
            return this.s.substring(beginIndex);
        }

        public String substring(int beginIndex, int endIndex) {
            return this.s.substring(beginIndex, endIndex);
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            return this.s.subSequence(beginIndex, endIndex);
        }

        public String concat(String str) {
            return this.s.concat(str);
        }

        public String replace(char oldChar, char newChar) {
            return this.s.replace(oldChar, newChar);
        }

        public boolean matches(String regex) {
            return this.s.matches(regex);
        }

        public boolean contains(CharSequence s) {
            return this.s.contains(s);
        }

        public String replaceFirst(String regex, String replacement) {
            return this.s.replaceFirst(regex, replacement);
        }

        public String replaceAll(String regex, String replacement) {
            return this.s.replaceAll(regex, replacement);
        }

        public String replace(CharSequence target, CharSequence replacement) {
            return this.s.replace(target, replacement);
        }

        public String[] split(String regex, int limit) {
            return this.s.split(regex, limit);
        }

        public String[] split(String regex) {
            return this.s.split(regex);
        }

        public static String join(CharSequence delimiter, CharSequence ... elements) {
            return String.join(delimiter, elements);
        }

        public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
            return String.join(delimiter, elements);
        }

        public String toLowerCase(Locale locale) {
            return this.s.toLowerCase(locale);
        }

        public String toLowerCase() {
            return this.s.toLowerCase();
        }

        public String toUpperCase(Locale locale) {
            return this.s.toUpperCase(locale);
        }

        public String toUpperCase() {
            return this.s.toUpperCase();
        }

        public String trim() {
            return this.s.trim();
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        public char[] toCharArray() {
            return this.s.toCharArray();
        }

        public static String format(String format, Object ... args) {
            return String.format(format, args);
        }

        public static String format(Locale l, String format, Object ... args) {
            return String.format(l, format, args);
        }

        public static String valueOf(Object obj) {
            return String.valueOf(obj);
        }

        public static String valueOf(char[] data) {
            return String.valueOf(data);
        }

        public static String valueOf(char[] data, int offset, int count) {
            return String.valueOf(data, offset, count);
        }

        public static String copyValueOf(char[] data, int offset, int count) {
            return String.copyValueOf(data, offset, count);
        }

        public static String copyValueOf(char[] data) {
            return String.copyValueOf(data);
        }

        public static String valueOf(boolean b) {
            return String.valueOf(b);
        }

        public static String valueOf(char c) {
            return String.valueOf(c);
        }

        public static String valueOf(int i) {
            return String.valueOf(i);
        }

        public static String valueOf(long l) {
            return String.valueOf(l);
        }

        public static String valueOf(float f) {
            return String.valueOf(f);
        }

        public static String valueOf(double d) {
            return String.valueOf(d);
        }

        public String intern() {
            return this.s.intern();
        }
    }

    static class Concatenation
    implements ComparableCharSequence,
    Comparable<CharSequence>,
    Serializable {
        private final Entry[] entries;
        private final InternTable table;
        private int hash = 0;

        Concatenation(InternTable table, CharSequence ... entries) {
            this.table = table;
            ArrayList<Entry> l = new ArrayList<Entry>(entries.length);
            for (CharSequence cs : entries) {
                if (cs instanceof Concatenation) {
                    Concatenation c1 = (Concatenation)cs;
                    if (c1.belongsTo(table)) {
                        l.addAll(Arrays.asList(c1.entries));
                        continue;
                    }
                    for (Entry e : c1.entries) {
                        l.add(table.intern((CharSequence)e));
                    }
                    continue;
                }
                l.add(table.intern(cs));
            }
            this.entries = l.toArray(new Entry[l.size()]);
        }

        @Override
        public int length() {
            int result = 0;
            for (int i = 0; i < this.entries.length; ++i) {
                result += this.entries[i].length;
            }
            return result;
        }

        @Override
        public char charAt(int index) {
            if (this.entries.length == 0) {
                throw new IndexOutOfBoundsException("0 length but asked for " + index);
            }
            for (int i = 0; i < this.entries.length; ++i) {
                Entry e = this.entries[i];
                if (index >= e.length) {
                    index -= e.length;
                    continue;
                }
                return e.charAt(index);
            }
            throw new IndexOutOfBoundsException(index + " of " + this.length() + " in " + this + " with entries " + Arrays.asList(this.entries));
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            int len;
            if (start > end) {
                throw new IllegalArgumentException("Start greater than end " + start + " > " + end);
            }
            if (start == end) {
                return Strings.emptyCharSequence();
            }
            if (start == 0 && end == this.length()) {
                return this;
            }
            int aggregateLength = 0;
            int max = this.entries.length;
            ArrayList<CharSequence> result = new ArrayList<CharSequence>(this.entries.length);
            for (int i = 0; i < max && aggregateLength < end + 1; aggregateLength += len, ++i) {
                Entry curr = this.entries[i];
                len = curr.length();
                int first = Math.max(0, start - aggregateLength);
                int last = Math.min(len, Math.min(end + 1 - start, first + (end - aggregateLength)));
                if (end >= aggregateLength + len) {
                    last = len;
                } else if (end <= aggregateLength + len) {
                    last = end - aggregateLength;
                }
                if (last <= first) continue;
                CharSequence sub = curr.subSequence(first, last);
                result.add(sub);
            }
            return new Concatenation(this.table, result.toArray(new CharSequence[result.size()]));
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Entry e : this.entries) {
                sb.append(e);
            }
            if (debug) {
                sb.append(" - ").append(Arrays.asList(this.entries));
            }
            return sb.toString();
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0 && this.length() > 0) {
                for (Entry e : this.entries) {
                    CharSequence chars = e.toChars();
                    int max = chars.length();
                    for (int i = 0; i < max; ++i) {
                        h = 31 * h + chars.charAt(i);
                    }
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object o) {
            if (o instanceof CharSequence) {
                return EightBitStrings.charSequencesEqual(this, (CharSequence)o);
            }
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof Concatenation) {
                Concatenation c = (Concatenation)o;
                if (c.entries.length != this.entries.length) {
                    return EightBitStrings.charSequencesEqual(this, c);
                }
                for (int i = 0; i < this.entries.length; ++i) {
                    if (this.entries[i].length() != this.entries[i].length) {
                        return EightBitStrings.charSequencesEqual(this, c);
                    }
                    if (this.entries[i].equals(c.entries[i])) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof CharSequence) {
                return EightBitStrings.charSequencesEqual(this, (CharSequence)o);
            }
            return false;
        }

        @Override
        public int compareTo(CharSequence o) {
            if (o instanceof Concatenation) {
                int res;
                Concatenation other = (Concatenation)o;
                int ec = Math.min(this.entries.length, other.entries.length);
                if (ec > 0 && (res = this.entries[0].compareChars(other.entries[0])) != 0) {
                    return res;
                }
            }
            return EightBitStrings.compareCharSequences(this, o);
        }

        private boolean belongsTo(InternTable aThis) {
            return this.table == aThis;
        }
    }

    private static final class Entry
    implements ComparableCharSequence,
    Serializable {
        private final byte[] bytes;
        private final short length;
        int hash = 0;
        private final boolean ascii;

        public Entry(byte[] bytes, short length, boolean ascii) {
            if (length < 0) {
                throw new Error("String too large");
            }
            this.bytes = bytes;
            this.length = length;
            this.ascii = ascii;
        }

        public Charset charset() {
            return this.ascii ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8;
        }

        public int hashCode() {
            if (this.hash != 0) {
                return this.hash;
            }
            int h = 0;
            if (h == 0 && this.bytes.length > 0) {
                if (this.ascii) {
                    int max = this.bytes.length;
                    for (int i = 0; i < max; ++i) {
                        h = 31 * h + (char)this.bytes[i];
                    }
                } else {
                    CharSequence val = this.toChars();
                    int max = val.length();
                    for (int i = 0; i < max; ++i) {
                        h = 31 * h + val.charAt(i);
                    }
                }
            }
            this.hash = h;
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.bytes.length < this.bytes.length) {
                    return false;
                }
                return Arrays.equals(this.bytes, other.bytes);
            }
            if (o instanceof CharSequence) {
                return EightBitStrings.charSequencesEqual(this, (CharSequence)o);
            }
            return false;
        }

        public int compareChars(Entry o) {
            int max = Math.min(this.bytes.length, o.bytes.length);
            for (int i = 0; i < max; ++i) {
                if (this.bytes[i] > o.bytes[i]) {
                    return 1;
                }
                if (this.bytes[i] >= o.bytes[i]) continue;
                return -1;
            }
            return 0;
        }

        public int compare(Entry o) {
            if (o == this) {
                return 0;
            }
            if (!this.ascii) {
                return Strings.compareCharSequences(this, o, false);
            }
            int result = this.compareChars(o);
            if (result != 0) {
                return result;
            }
            if (this.bytes.length == o.bytes.length) {
                return 0;
            }
            if (this.bytes.length > o.bytes.length) {
                return 1;
            }
            return -1;
        }

        @Override
        public String toString() {
            return new String(this.bytes, this.charset());
        }

        @Override
        public int length() {
            return this.length;
        }

        CharSequence toChars() {
            return EightBitStrings.toCharSequence(this.charset(), this.bytes);
        }

        @Override
        public char charAt(int index) {
            if (this.ascii) {
                return (char)this.bytes[index];
            }
            return EightBitStrings.toCharSequence(this.charset(), this.bytes).charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start == end) {
                return Strings.emptyCharSequence();
            }
            if (start == 0 && end == this.length) {
                return this;
            }
            if (this.ascii) {
                byte[] b = new byte[end - start];
                System.arraycopy(this.bytes, start, b, 0, b.length);
                return new Entry(b, (short)b.length, this.ascii);
            }
            return EightBitStrings.toCharSequence(this.charset(), this.bytes).subSequence(start, end);
        }

        @Override
        public int compareTo(CharSequence o) {
            if (o instanceof Entry) {
                return this.compare((Entry)o);
            }
            return EightBitStrings.compareCharSequences(this, o);
        }

        private boolean belongsTo(InternTable aThis) {
            for (Entry e : aThis.entries) {
                if (e != this) continue;
                return true;
            }
            return false;
        }
    }

    class InternTable
    implements Serializable {
        private static final int SIZE_INCREMENT = 150;
        private int last = -1;
        private Entry[] entries = new Entry[150];

        InternTable() {
        }

        void dispose() {
            this.entries = new Entry[150];
            this.last = -1;
        }

        boolean owns(CharSequence seq) {
            if (seq instanceof Entry) {
                return ((Entry)seq).belongsTo(this);
            }
            if (seq instanceof Concatenation) {
                return ((Concatenation)seq).belongsTo(this);
            }
            return false;
        }

        Entry[] intern(CharSequence ... seq) {
            Entry[] result = new Entry[seq.length];
            for (int i = 0; i < seq.length; ++i) {
                result[i] = this.intern(seq[i], false);
            }
            if (seq.length > 0) {
                this.resort(seq[0]);
            }
            return result;
        }

        Entry intern(CharSequence seq) {
            return this.intern(seq, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Entry intern(CharSequence seq, boolean sort) {
            if (seq instanceof Entry && ((Entry)seq).belongsTo(this)) {
                return (Entry)seq;
            }
            Entry entry = new Entry(EightBitStrings.this.toBytes(seq), (short)seq.length(), EightBitStrings.this.ascii);
            InternTable internTable = this;
            synchronized (internTable) {
                int offset;
                int n = offset = this.last == -1 ? -1 : Arrays.binarySearch(this.entries, 0, this.last + 1, entry);
                if (offset > 0) {
                    return this.entries[offset];
                }
                if (this.last == this.entries.length - 1) {
                    Entry[] nue = new Entry[this.entries.length + 150];
                    System.arraycopy(this.entries, 0, nue, 0, this.entries.length);
                    this.entries = nue;
                }
                this.entries[++this.last] = entry;
                this.resort(seq);
            }
            return entry;
        }

        private void resort(CharSequence seq) {
            try {
                Arrays.sort(this.entries, 0, this.last + 1);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError("Broken sorting '" + seq + "' into array for item " + this.last + ". Full table: " + this.dumpInternTable(), e);
            }
        }

        List<CharSequence> dumpInternTable() {
            return Arrays.asList(this.entries);
        }
    }
}

