/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import java.lang.reflect.Array;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

final class MultiLiteralPattern<T>
implements Function<CharSequence, T> {
    private final T[] keys;
    private final CharSequence[] seqs;
    private final int[] lengths;
    private final int minPatternLength;

    MultiLiteralPattern(Map<T, ? extends CharSequence> m, Class<T> type) {
        Object[] parts = null;
        CharSequence[] literalPatterns = new CharSequence[m.size()];
        int[] lens = new int[m.size()];
        int cursor = 0;
        int min = Integer.MAX_VALUE;
        for (Map.Entry<T, CharSequence> e : m.entrySet()) {
            int len;
            if (parts == null) {
                parts = (Object[])Array.newInstance(type, m.size());
            }
            parts[cursor] = e.getKey();
            lens[cursor] = len = e.getValue().length();
            CharSequence pattern = e.getValue();
            if (pattern.length() == 0) {
                throw new IllegalArgumentException("Cannot match on the empty string");
            }
            literalPatterns[cursor++] = pattern;
            min = Math.min(min, len);
        }
        this.keys = parts;
        this.seqs = literalPatterns;
        this.lengths = lens;
        this.minPatternLength = min;
    }

    static <T extends Enum<T>> Function<CharSequence, T> forEnums(Class<T> enumType) {
        EnumMap<T, String> all = new EnumMap<T, String>(enumType);
        for (Enum en : (Enum[])enumType.getEnumConstants()) {
            all.put(en, en.toString());
        }
        return new MultiLiteralPattern<T>(all, enumType);
    }

    static <T extends Enum<T>> Function<CharSequence, T> forEnums(Map<T, CharSequence> m) {
        if (m.isEmpty()) {
            return _ignored -> null;
        }
        return new MultiLiteralPattern<T>(m, MultiLiteralPattern.typeIn(m));
    }

    static <T> Function<CharSequence, Integer> forStrings(CharSequence ... patterns) {
        if (patterns.length == 0) {
            return _ignored -> null;
        }
        LinkedHashMap<Integer, CharSequence> map = new LinkedHashMap<Integer, CharSequence>(patterns.length);
        for (int i = 0; i < patterns.length; ++i) {
            map.put(i, patterns[i]);
        }
        return new MultiLiteralPattern<Integer>(map, Integer.class);
    }

    private static <T extends Enum<T>> Class<T> typeIn(Map<T, ?> in) {
        if (in.isEmpty()) {
            throw new IllegalArgumentException("Patterns map is empty");
        }
        return ((Enum)in.entrySet().iterator().next().getKey()).getDeclaringClass();
    }

    @Override
    public T apply(CharSequence in) {
        return new PatternMatch().test(in);
    }

    final class PatternMatch {
        private final int[] matchedChars;

        PatternMatch() {
            this.matchedChars = new int[MultiLiteralPattern.this.seqs.length];
        }

        /*
         * Unable to fully structure code
         */
        private boolean testOnePattern(int pattern, char c, int at, CharSequence in, int len) {
            if (this.matchedChars[pattern] < 0) {
                return false;
            }
            currentPositionInPattern = this.matchedChars[pattern];
            test = MultiLiteralPattern.access$000(MultiLiteralPattern.this)[pattern].charAt(currentPositionInPattern);
            v0 = charMatch = test == c;
            if (!charMatch) ** GOTO lbl-1000
            v1 = pattern;
            this.matchedChars[v1] = this.matchedChars[v1] + 1;
            if (this.matchedChars[v1] == MultiLiteralPattern.access$000(MultiLiteralPattern.this)[pattern].length()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = result = false;
            }
            if (!charMatch) {
                this.matchedChars[pattern] = 0;
            } else if (this.matchedChars[pattern] == 1 && (endChar = in.charAt(lastChar = at + (patternLastPosition = MultiLiteralPattern.access$100(MultiLiteralPattern.this)[pattern] - 1))) != (expectedEndChar = MultiLiteralPattern.access$000(MultiLiteralPattern.this)[pattern].charAt(patternLastPosition))) {
                this.matchedChars[pattern] = at + MultiLiteralPattern.access$100(MultiLiteralPattern.this)[pattern] >= len ? -1 : 0;
                result = false;
            }
            return result;
        }

        public T test(CharSequence seq) {
            int numPatterns;
            int len = seq.length();
            if (len < MultiLiteralPattern.this.minPatternLength) {
                return null;
            }
            int remainingViable = numPatterns = this.matchedChars.length;
            for (int i = 0; i < len; ++i) {
                char curr = seq.charAt(i);
                int remainingLengthInString = len - i;
                for (int j = 0; j < this.matchedChars.length; ++j) {
                    int remainingLengthInPattern = MultiLiteralPattern.this.lengths[j] - this.matchedChars[j];
                    if (remainingLengthInPattern <= remainingLengthInString) {
                        if (!this.testOnePattern(j, curr, i, seq, len)) continue;
                        return MultiLiteralPattern.this.keys[j];
                    }
                    --remainingViable;
                    this.matchedChars[j] = -1;
                }
                if (remainingViable == 0) break;
                remainingViable = numPatterns;
            }
            return null;
        }
    }
}

