/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.strings;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.strings.AppendableCharSequence;
import com.mastfrog.util.strings.AppendingCharSequence;
import com.mastfrog.util.strings.ComparableCharSequence;
import com.mastfrog.util.strings.Escaper;
import com.mastfrog.util.strings.LazyCharSequence;
import com.mastfrog.util.strings.MatchWords;
import com.mastfrog.util.strings.MultiLiteralPattern;
import com.mastfrog.util.strings.SingleCharSequence;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Strings {
    private static final BitSet PUNC = new BitSet(128);
    private static final ComparableCharSequence ELLIPSIS = new SingleCharSequence('\u2026');
    private static final int MAX_ELLIPSIS_SKEW = 12;
    private static boolean puncInitialized;
    private static final EmptyCharSequence EMPTY;
    private static final SingleCharSequence CR;
    private static final SingleCharSequence COMMA;
    private static final SingleCharSequence DOT;
    private static final SingleCharSequence COLON;
    private static final SingleCharSequence OPEN_CURLY;
    private static final SingleCharSequence CLOSE_CURLY;
    private static final SingleCharSequence OPEN_PAREN;
    private static final SingleCharSequence CLOSE_PAREN;
    private static final SingleCharSequence OPEN_SQUARE;
    private static final SingleCharSequence CLOSE_SQUARE;
    private static final SingleCharSequence SLASH;
    private static final int NYBBL_MASK = 15;
    private static final DateTimeFormatter ISO_INSTANT;
    private static final ZoneId GMT;
    private static final char[] EMPTY_CHARS;
    private static final CharPred IS_DIGIT;
    private static final CharPred IS_LETTERS;

    public static boolean isPunctuation(CharSequence name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        if (len == 1) {
            return Strings.isPunctuation(name.charAt(0));
        }
        return Strings.is(name, Strings::isPunctuation);
    }

    public static boolean isPunctuation(char c) {
        if (puncInitialized && c < '\u0080') {
            return PUNC.get(c);
        }
        return !Character.isLetter(c) && !Character.isDigit(c) && !Character.isWhitespace(c) && !Character.isISOControl(c) && Character.UnicodeBlock.of(c) != Character.UnicodeBlock.LETTERLIKE_SYMBOLS;
    }

    public static String reverse(String s) {
        int max = s.length() - 1;
        if (max < 0) {
            return s;
        }
        char[] c = new char[max + 1];
        for (int i = 0; i <= max; ++i) {
            c[i] = s.charAt(max - i);
        }
        return new String(c);
    }

    public static boolean isBlank(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        int len = s.length();
        if (len == 1) {
            return Character.isWhitespace(s.charAt(0));
        }
        if (!Character.isWhitespace(s.charAt(len - 1))) {
            return false;
        }
        return Strings.is(s, Character::isWhitespace);
    }

    public static boolean isBlank(CharSequence seq) {
        if (seq == null || seq.length() == 0) {
            return true;
        }
        return Strings.is(seq, Character::isWhitespace);
    }

    public static String dequote(String text, char quote) {
        return Strings.dequote(text, quote, quote);
    }

    public static String dequote(String text, char opening, char closing) {
        if (text.length() > 1 && text.charAt(0) == opening && text.charAt(text.length() - 1) == closing) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String dequote(String text) {
        return Strings.dequote(text, '\"');
    }

    public static String deSingleQuote(String text) {
        return Strings.dequote(text, '\'');
    }

    public static Optional<String> ifNonBlank(String text) {
        if (text == null || text.isEmpty() || Strings.isBlank(text)) {
            return Optional.empty();
        }
        return Optional.of(text);
    }

    public static CharSequence trim(CharSequence seq) {
        return Strings.trimmedSubsequence((CharSequence)Checks.notNull((String)"seq", (Object)seq));
    }

    public static List<String> trim(List<String> strings) {
        if (((List)Checks.notNull((String)"strings", strings)).isEmpty()) {
            return strings;
        }
        AbstractList result = strings instanceof LinkedList ? new LinkedList() : new ArrayList();
        for (String s : strings) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            result.add((String)s.trim());
        }
        return result;
    }

    public static Set<String> trim(Set<String> strings) {
        if (((Set)Checks.notNull((String)"strings", strings)).isEmpty()) {
            return strings;
        }
        AbstractSet result = strings instanceof SortedSet ? new TreeSet() : new LinkedHashSet();
        for (String s : strings) {
            String trimmed = s.trim();
            if (trimmed.isEmpty()) continue;
            result.add((String)trimmed);
        }
        return result;
    }

    public static String[] trim(String[] in) {
        if (((String[])Checks.notNull((String)"in", (Object)in)).length == 0) {
            return in;
        }
        String[] result = new String[in.length];
        System.arraycopy(in, 0, result, 0, result.length);
        int last = 0;
        for (int i = 0; i < result.length; ++i) {
            String trimmed = result[i].trim();
            if (trimmed.isEmpty()) continue;
            result[last++] = trimmed;
        }
        if (last == 0) {
            return new String[0];
        }
        if (last != in.length) {
            result = Arrays.copyOf(result, last);
        }
        return result;
    }

    public static String sha1(String s) {
        MessageDigest digest = Strings.createDigest("SHA-1");
        byte[] result = digest.digest(s.getBytes(Charset.forName("UTF-8")));
        return Strings.toBase64(result);
    }

    private static MessageDigest createDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("No such algorithm: " + algorithm, ex);
        }
    }

    public static <T> String toString(T[] collection) {
        return Strings.toString(Arrays.asList(collection));
    }

    public static String[] split(String string) {
        String[] result = string.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static <T> String toString(Iterable<T> collection) {
        return Strings.toString(collection.iterator());
    }

    public static String toString(Iterator<?> iter) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toString(Throwable throwable) {
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            throwable.printStackTrace(p);
        }
        return w.toString();
    }

    private Strings() {
    }

    @Deprecated
    public static String join(String ... parts) {
        return Strings.joinPath(parts);
    }

    public static String joinPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        if (parts.length > 0) {
            sb.append(parts[0]);
        }
        for (int i = 1; i < parts.length; ++i) {
            boolean gotLeadingSlash;
            String part = parts[i];
            if (part.isEmpty() || part.length() == 1 && part.charAt(0) == '/') continue;
            boolean gotTrailingSlash = sb.length() == 0 ? false : sb.charAt(sb.length() - 1) == '/';
            if (gotTrailingSlash != !(gotLeadingSlash = part.charAt(0) == '/')) {
                sb.append(part);
                continue;
            }
            if (!gotTrailingSlash) {
                sb.append('/');
                continue;
            }
            sb.append(part.substring(1));
        }
        return sb.toString();
    }

    public static int charSequenceHashCode(CharSequence seq) {
        return Strings.charSequenceHashCode(seq, false);
    }

    public static int charSequenceHashCode(CharSequence seq, boolean ignoreCase) {
        Checks.notNull((String)"seq", (Object)seq);
        int length = seq.length();
        if (length == 0) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = ignoreCase ? 31 * result + Character.toLowerCase(seq.charAt(i)) : 31 * result + seq.charAt(i);
        }
        return result;
    }

    public static boolean charSequencesEqual(CharSequence a, CharSequence b) {
        return Strings.charSequencesEqual(a, b, false);
    }

    public static int countOccurrences(char c, CharSequence in) {
        int result = 0;
        int max = in.length();
        for (int i = 0; i < max; ++i) {
            if (c != in.charAt(i)) continue;
            ++result;
        }
        return result;
    }

    public static boolean charSequencesEqual(CharSequence a, CharSequence b, boolean ignoreCase) {
        Checks.notNull((String)"a", (Object)a);
        Checks.notNull((String)"b", (Object)b);
        if (a == null != (b == null)) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a instanceof String && b instanceof String) {
            return ignoreCase ? ((String)a).equalsIgnoreCase((String)b) : a.equals(b);
        }
        int length = a.length();
        if (length != b.length()) {
            return false;
        }
        if (!ignoreCase && a.getClass() == b.getClass() && a.getClass() != NoCopySubsequence.class) {
            return a.equals(b);
        }
        if (!ignoreCase && a instanceof String) {
            return ((String)a).contentEquals(b);
        }
        if (!ignoreCase && b instanceof String) {
            return ((String)b).contentEquals(a);
        }
        if (ignoreCase) {
            return Strings.contentEqualsIgnoreCase(a, b);
        }
        return Strings.biIterate(a, (index, ch, l, remaining) -> {
            boolean match = ch == b.charAt(index);
            return !match ? BiIterateResult.NO : BiIterateResult.MAYBE;
        }).isOk();
    }

    public static CharSequence[] trim(CharSequence[] seqs) {
        if (((CharSequence[])Checks.notNull((String)"seqs", (Object)seqs)).length == 0) {
            return seqs;
        }
        CharSequence[] result = new CharSequence[seqs.length];
        System.arraycopy(seqs, 0, result, 0, seqs.length);
        int last = 0;
        for (int i = 0; i < result.length; ++i) {
            CharSequence trimmed = Strings.trim(result[i]);
            if (trimmed.length() == 0) continue;
            result[last++] = trimmed;
        }
        if (last == 0) {
            return new CharSequence[0];
        }
        if (last != seqs.length) {
            result = Arrays.copyOf(result, last);
        }
        return result;
    }

    public static int compareCharSequences(CharSequence a, CharSequence b, boolean ignoreCase) {
        if (a == b) {
            return 0;
        }
        if (a instanceof String && b instanceof String) {
            return ((String)a).compareTo((String)b);
        }
        int aLength = a.length();
        int bLength = b.length();
        if (aLength == 0 && bLength == 0) {
            return 0;
        }
        int max = Math.min(aLength, bLength);
        for (int i = 0; i < max; ++i) {
            char bc;
            char ac = ignoreCase ? Character.toLowerCase(a.charAt(i)) : a.charAt(i);
            int result = Character.compare(ac, bc = ignoreCase ? Character.toLowerCase(b.charAt(i)) : b.charAt(i));
            if (result == 0) continue;
            return result;
        }
        if (aLength == bLength) {
            return 0;
        }
        if (aLength > bLength) {
            return 1;
        }
        return -1;
    }

    public static Comparator<CharSequence> charSequenceComparator(boolean caseInsensitive) {
        return caseInsensitive ? CharSequenceComparator.INSENSITIVE : CharSequenceComparator.SENSITIVE;
    }

    public static Comparator<CharSequence> charSequenceComparator() {
        return CharSequenceComparator.INSENSITIVE;
    }

    public static CharSequence emptyCharSequence() {
        return EMPTY;
    }

    public static String join(char delim, String ... parts) {
        return Strings.join(delim, Arrays.asList(parts));
    }

    public static CharSequence join(char delim, CharSequence ... parts) {
        AppendableCharSequence seq = new AppendableCharSequence(new CharSequence[0]);
        for (int i = 0; i < parts.length; ++i) {
            seq.append(parts[i]);
            if (i == parts.length - 1) continue;
            seq.append(delim);
        }
        return seq;
    }

    public static CharSequence join(char delim, Object ... parts) {
        if (parts.length == 1 && parts[0] instanceof Iterable) {
            return Strings.join(delim, (Iterable)parts[0]);
        }
        AppendableCharSequence seq = new AppendableCharSequence(new CharSequence[0]);
        for (int i = 0; i < parts.length; ++i) {
            String ts = parts[i] == null ? "null" : parts[i].toString();
            seq.append(ts);
            if (i == parts.length - 1) continue;
            seq.append(delim);
        }
        return seq;
    }

    public static String join(char delim, Iterable<?> parts) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = parts.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String commas(Iterable<?> parts) {
        return Strings.join(", ", parts);
    }

    public static String commas(Object a, Object ... more) {
        if (a instanceof Iterable && more.length == 0) {
            return Strings.join(", ", (Iterable)a);
        }
        ArrayList all = new ArrayList(more.length + 1);
        return Strings.commas(all);
    }

    public static <T> void concatenate(String delimiter, Iterable<T> iter, StringBuilder into, Function<? super T, String> toString) {
        Iterator<T> it = iter.iterator();
        while (it.hasNext()) {
            into.append(toString.apply(it.next()));
            if (!it.hasNext()) continue;
            into.append(delimiter);
        }
    }

    public static String join(String delim, Iterable<?> parts) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = parts.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static <T> String join(char delim, Iterable<T> parts, Function<T, String> stringConvert) {
        StringBuilder sb = new StringBuilder(256);
        Iterator<T> it = parts.iterator();
        while (it.hasNext()) {
            String sv = stringConvert.apply(it.next());
            if (sv == null || sv.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(sv);
        }
        return sb.toString();
    }

    public static ComparableCharSequence singleChar(char c) {
        switch (c) {
            case '\n': {
                return CR;
            }
            case ',': {
                return COMMA;
            }
            case '.': {
                return DOT;
            }
            case ':': {
                return COLON;
            }
            case '{': {
                return OPEN_CURLY;
            }
            case '}': {
                return CLOSE_CURLY;
            }
            case '(': {
                return OPEN_PAREN;
            }
            case ')': {
                return CLOSE_PAREN;
            }
            case '[': {
                return OPEN_SQUARE;
            }
            case ']': {
                return CLOSE_SQUARE;
            }
            case '/': {
                return SLASH;
            }
            case '\u2026': {
                return ELLIPSIS;
            }
        }
        return new SingleCharSequence(c);
    }

    public static CharSequence[] split(char delim, CharSequence seq) {
        if (seq.length() == 0) {
            return new CharSequence[0];
        }
        List<CharSequence> l = Strings.splitToList(delim, seq);
        return l.toArray(new CharSequence[l.size()]);
    }

    public static CharSequence[] splitOnce(char c, CharSequence cs) {
        int max = cs.length();
        if (max == 0) {
            return new CharSequence[0];
        }
        int splitAt = -1;
        for (int i = 0; i < cs.length(); ++i) {
            if (c != cs.charAt(i)) continue;
            splitAt = i;
            break;
        }
        if (splitAt == -1) {
            return new CharSequence[]{cs};
        }
        CharSequence left = cs.subSequence(0, splitAt);
        if (splitAt < max - 1) {
            CharSequence right = cs.subSequence(splitAt + 1, max);
            return new CharSequence[]{left, right};
        }
        return new CharSequence[]{left};
    }

    public static String[] splitOnce(char c, String cs) {
        int max = cs.length();
        if (max == 0) {
            return new String[0];
        }
        int splitAt = -1;
        for (int i = 0; i < cs.length(); ++i) {
            if (c != cs.charAt(i)) continue;
            splitAt = i;
            break;
        }
        if (splitAt == -1) {
            return new String[]{cs};
        }
        String left = cs.subSequence(0, splitAt).toString();
        if (splitAt < max - 1) {
            String right = cs.subSequence(splitAt + 1, max).toString();
            return new String[]{left, right};
        }
        return new String[]{left};
    }

    public static final CharSequence stripDoubleQuotes(CharSequence cs) {
        if (cs.length() >= 2) {
            if (cs.charAt(0) == '\"') {
                cs = cs.subSequence(1, cs.length());
            }
            if (cs.charAt(cs.length() - 1) == '\"') {
                cs = cs.subSequence(0, cs.length() - 1);
            }
        }
        return cs;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode((String)Checks.notNull((String)"str", (Object)str), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return (String)Exceptions.chuck((Throwable)ex);
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode((String)Checks.notNull((String)"str", (Object)str), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return (String)Exceptions.chuck((Throwable)ex);
        }
    }

    public static String[] split(char delim, String seq) {
        ArrayList<String> result = new ArrayList<String>(20);
        int max = seq.length();
        int start = 0;
        for (int i = 0; i < max; ++i) {
            boolean last;
            char c = seq.charAt(i);
            boolean bl = last = i == max - 1;
            if (c != delim && !last) continue;
            result.add(seq.substring(start, last ? (c == delim ? i : i + 1) : i));
            start = i + 1;
        }
        return result.toArray(new String[result.size()]);
    }

    public static List<CharSequence> splitToList(char delimiter, CharSequence seq) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>(5);
        int max = seq.length();
        int start = 0;
        for (int i = 0; i < max; ++i) {
            boolean last;
            char c = seq.charAt(i);
            boolean bl = last = i == max - 1;
            if (c != delimiter && !last) continue;
            result.add(seq.subSequence(start, last ? (c == delimiter ? i : i + 1) : i));
            start = i + 1;
        }
        return result;
    }

    public static Set<CharSequence> splitUniqueNoEmpty(char delim, CharSequence seq) {
        LinkedHashSet<CharSequence> result = new LinkedHashSet<CharSequence>();
        Strings.split(delim, seq, s -> {
            if ((s = Strings.trim(s)).length() > 0) {
                result.add((CharSequence)s);
            }
            return true;
        });
        return result;
    }

    public static void split(char delim, CharSequence seq, Predicate<CharSequence> proc) {
        Checks.notNull((String)"seq", (Object)seq);
        Checks.notNull((String)"proc", proc);
        int lastStart = 0;
        int max = seq.length();
        if (max == 0) {
            return;
        }
        for (int i = 0; i < max; ++i) {
            char c = seq.charAt(i);
            if (delim != c && i != max - 1) continue;
            if (lastStart != i) {
                CharSequence sub;
                int offset;
                int n = offset = i == max - 1 ? i + 1 : i;
                if (i == max - 1 && delim == c) {
                    --offset;
                }
                if (!proc.test(sub = seq.subSequence(lastStart, offset))) {
                    return;
                }
            } else if (!proc.test("")) {
                return;
            }
            lastStart = i + 1;
        }
    }

    public static boolean startsWith(CharSequence target, CharSequence start) {
        int targetLength = target.length();
        int startLength = start.length();
        if (startLength > targetLength) {
            return false;
        }
        if (target.charAt(startLength - 1) != start.charAt(startLength - 1)) {
            return false;
        }
        for (int i = 0; i < startLength - 1; ++i) {
            if (start.charAt(i) == target.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(CharSequence target, CharSequence start) {
        int targetLength = target.length();
        int startLength = start.length();
        if (startLength > targetLength) {
            return false;
        }
        if (Character.toLowerCase(target.charAt(startLength - 1)) != Character.toLowerCase(start.charAt(startLength - 1))) {
            return false;
        }
        for (int i = 0; i < startLength; ++i) {
            if (start.charAt(i) == target.charAt(i) || Character.toLowerCase(start.charAt(i)) == target.charAt(i) || Character.toUpperCase(start.charAt(i)) == target.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        int len = a.length();
        if (b.length() != len) {
            return false;
        }
        return Strings.biIterate(a, (index, ch, l, remaining) -> {
            boolean match = Character.toLowerCase(ch) == Character.toLowerCase(b.charAt(index));
            return !match ? BiIterateResult.NO : BiIterateResult.MAYBE;
        }).isOk();
    }

    public static boolean charSequenceContains(CharSequence container, CharSequence contained, boolean ignoreCase) {
        Checks.notNull((String)"container", (Object)container);
        Checks.notNull((String)"contained", (Object)contained);
        if (!ignoreCase && container instanceof String && contained instanceof String) {
            return ((String)container).contains(contained);
        }
        int containerLength = container.length();
        int containedLength = contained.length();
        if (containedLength > containerLength) {
            return false;
        }
        int offset = 0;
        int max = container.length();
        for (int i = 0; i < max; ++i) {
            char d;
            char c = ignoreCase ? Character.toLowerCase(container.charAt(i)) : container.charAt(i);
            char c2 = d = ignoreCase ? Character.toLowerCase(contained.charAt(offset)) : contained.charAt(offset);
            offset = c != d ? 0 : ++offset;
            if (offset < containedLength) continue;
            return true;
        }
        return false;
    }

    public static int charToNybbl(char c) {
        int val;
        switch (c) {
            case '0': {
                val = 0;
                break;
            }
            case '1': {
                val = 1;
                break;
            }
            case '2': {
                val = 2;
                break;
            }
            case '3': {
                val = 3;
                break;
            }
            case '4': {
                val = 4;
                break;
            }
            case '5': {
                val = 5;
                break;
            }
            case '6': {
                val = 6;
                break;
            }
            case '7': {
                val = 7;
                break;
            }
            case '8': {
                val = 8;
                break;
            }
            case '9': {
                val = 9;
                break;
            }
            case 'A': 
            case 'a': {
                val = 10;
                break;
            }
            case 'B': 
            case 'b': {
                val = 11;
                break;
            }
            case 'C': 
            case 'c': {
                val = 12;
                break;
            }
            case 'D': 
            case 'd': {
                val = 13;
                break;
            }
            case 'E': 
            case 'e': {
                val = 14;
                break;
            }
            case 'F': 
            case 'f': {
                val = 15;
                break;
            }
            default: {
                throw new NumberFormatException("Invalid character '" + c + "' is not hex");
            }
        }
        return val;
    }

    public static byte parseHexByte(CharSequence seq) {
        if (Strings.startsWith(seq, "0x")) {
            seq = seq.subSequence(2, seq.length());
        }
        switch (seq.length()) {
            case 0: {
                return 0;
            }
            case 1: {
                return (byte)Strings.charToNybbl(seq.charAt(0));
            }
            case 2: {
                return (byte)(Strings.charToNybbl(seq.charAt(0)) << 4 | Strings.charToNybbl(seq.charAt(1)));
            }
        }
        throw new NumberFormatException("Invalid length for single byte of hex: " + seq.length() + " in '" + seq + "'");
    }

    public static short parseHexShort(CharSequence seq) {
        short result = 0;
        int last = seq.length() - 1;
        if (last > 3) {
            throw new NumberFormatException("Too many characters (> 8) for an int in '" + seq + "'");
        }
        if (Strings.startsWith(seq, "0x")) {
            seq = seq.subSequence(2, seq.length());
        }
        int i = last;
        int j = 0;
        while (i >= 0) {
            int val = Strings.charToNybbl(seq.charAt(i));
            result = (short)(result | (val <<= j));
            --i;
            j += 4;
        }
        return result;
    }

    public static int parseHexInt(CharSequence seq) {
        int result = 0;
        int last = seq.length() - 1;
        if (last > 7) {
            throw new NumberFormatException("Too many characters (> 8) for an int in '" + seq + "'");
        }
        if (Strings.startsWith(seq, "0x")) {
            seq = seq.subSequence(2, seq.length());
        }
        int i = last;
        int j = 0;
        while (i >= 0) {
            int val = Strings.charToNybbl(seq.charAt(i));
            result |= (val <<= j);
            --i;
            j += 4;
        }
        return result;
    }

    public static long parseHexLong(CharSequence seq) {
        long result = 0L;
        int last = seq.length() - 1;
        if (last > 15) {
            throw new NumberFormatException("Too many characters (> 16) for a long in '" + seq + "'");
        }
        if (Strings.startsWith(seq, "0x")) {
            seq = seq.subSequence(2, seq.length());
        }
        int i = last;
        int j = 0;
        while (i >= 0) {
            long val = Strings.charToNybbl(seq.charAt(i));
            result |= (val <<= j);
            --i;
            j += 4;
        }
        return result;
    }

    public static int parseInt(CharSequence seq) {
        int result = 0;
        int max = seq.length() - 1;
        int position = 1;
        boolean negative = false;
        block4: for (int i = max; i >= 0; --i) {
            char c = seq.charAt(i);
            switch (c) {
                case '-': {
                    if (i == 0) {
                        negative = true;
                        continue block4;
                    }
                    throw new NumberFormatException("- encountered not at start of '" + seq + "'");
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int prev = result;
                    if (prev > (result += position * (c - 48))) {
                        throw new NumberFormatException("Number too large for integer: '" + seq + "' -  " + prev + " + " + position * (c - 48) + " = " + result);
                    }
                    position *= 10;
                    continue block4;
                }
                default: {
                    throw new NumberFormatException("Illegal character '" + c + "' in number '" + seq + "'");
                }
            }
        }
        return negative ? -result : result;
    }

    public static long parseLong(CharSequence seq) {
        long result = 0L;
        int max = seq.length() - 1;
        long position = 1L;
        boolean negative = false;
        block4: for (int i = max; i >= 0; --i) {
            char c = seq.charAt(i);
            switch (c) {
                case '-': {
                    if (i == 0) {
                        negative = true;
                        continue block4;
                    }
                    throw new NumberFormatException("- encountered not at start of '" + seq + "'");
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    long prev = result;
                    if (prev > (result += position * (long)(c - 48))) {
                        throw new NumberFormatException("Number too large for long: '" + seq + "' -  " + prev + " + " + position * (long)(c - 48) + " = " + result);
                    }
                    position *= 10L;
                    continue block4;
                }
                default: {
                    throw new NumberFormatException("Illegal character '" + c + "' in number '" + seq + "'");
                }
            }
        }
        return negative ? -result : result;
    }

    public static int indexOf(char c, CharSequence seq) {
        int max = seq.length();
        for (int i = 0; i < max; ++i) {
            if (c != seq.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char c, CharSequence seq) {
        int max;
        for (int i = max = seq.length() - 1; i >= 0; --i) {
            if (c != seq.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static String interleave(CharSequence a, CharSequence b) {
        StringBuilder sb = new StringBuilder();
        int maxA = a.length();
        int maxB = b.length();
        int max = Math.max(maxA, maxB);
        for (int i = 0; i < max; ++i) {
            if (i < maxA) {
                sb.append(a.charAt(i));
            }
            if (i >= maxB) continue;
            sb.append(b.charAt(i));
        }
        return sb.toString();
    }

    public static String literalReplaceAll(String pattern, String replacement, String in) {
        return Strings.literalReplaceAll(pattern, replacement, in, false).toString();
    }

    public static String literalReplaceAllIgnoreCase(String pattern, String replacement, String in) {
        return Strings.literalReplaceAll(pattern, replacement, in, true).toString();
    }

    public static CharSequence literalReplaceAll(CharSequence pattern, CharSequence replacement, CharSequence in, boolean ignoreCase) {
        if (in.length() < pattern.length()) {
            return in;
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Pattern is the empty string");
        }
        if (pattern.equals(replacement)) {
            throw new IllegalArgumentException("Replacing pattern with itself: " + pattern);
        }
        int max = in.length();
        StringBuilder result = new StringBuilder(in.length() + replacement.length());
        int patternEnd = pattern.length() - 1;
        int testPos = pattern.length() - 1;
        int lastMatch = -1;
        for (int i = max - 1; i >= 0; --i) {
            char realChar = in.charAt(i);
            char testChar = pattern.charAt(testPos);
            if (ignoreCase) {
                realChar = Character.toLowerCase(realChar);
                testChar = Character.toLowerCase(testChar);
            }
            if (realChar == testChar) {
                --testPos;
                if (lastMatch == -1) {
                    lastMatch = i;
                }
                if (testPos >= 0) continue;
                result.insert(0, replacement);
                testPos = patternEnd;
                lastMatch = -1;
                continue;
            }
            if (lastMatch != -1) {
                CharSequence missed = in.subSequence(i, lastMatch + 1);
                result.insert(0, missed);
                lastMatch = -1;
            } else {
                result.insert(0, realChar);
            }
            testPos = patternEnd;
        }
        return result;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Iterable) {
            return Strings.join(',', (Iterable)o);
        }
        if (o.getClass().isArray()) {
            int max = Array.getLength(o);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < max; ++i) {
                Object item = Array.get(o, i);
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Strings.toString(item));
            }
            return sb.toString();
        }
        return o.toString();
    }

    public static boolean containsCaseInsensitive(char lookFor, CharSequence in) {
        char lookFor1 = Character.toLowerCase(lookFor);
        char lookFor2 = Character.toUpperCase(lookFor);
        return Strings.biIterate(in, (index, ch, len, remaining) -> {
            if (ch == lookFor1 || ch == lookFor2) {
                return BiIterateResult.YES;
            }
            return BiIterateResult.MAYBE;
        }).isSuccess();
    }

    public static boolean contains(char lookFor, CharSequence in) {
        if (in instanceof String) {
            return ((String)in).indexOf(lookFor) != -1;
        }
        return Strings.biIterate(in, (index, ch, len, rem) -> ch == lookFor ? BiIterateResult.YES : BiIterateResult.MAYBE).isSuccess();
    }

    public static String camelCaseToDashes(CharSequence s) {
        return Strings.camelCaseToDelimited(s, '-');
    }

    public static String camelCaseToDelimited(CharSequence s, char delimiter) {
        StringBuilder sb = new StringBuilder();
        int max = s.length();
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c) && sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String dashesToCamelCase(CharSequence s) {
        return Strings.delimitedToCamelCase(s, '-');
    }

    public static String delimitedToCamelCase(CharSequence s, char delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean upcase = true;
        int max = s.length();
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            if (c == delimiter) {
                upcase = true;
                continue;
            }
            if (upcase) {
                c = Character.toUpperCase(c);
                upcase = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String hash(String s) {
        try {
            return Strings.hash(s, "SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            return (String)Exceptions.chuck((Throwable)ex);
        }
    }

    public static String urlHash(String s) {
        try {
            return Strings.urlHash(s, "SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            return (String)Exceptions.chuck((Throwable)ex);
        }
    }

    public static String hash(String s, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        return Base64.getEncoder().encodeToString(digest.digest(s.getBytes(Charset.forName("UTF-8"))));
    }

    public static String urlHash(String s, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        return Base64.getUrlEncoder().encodeToString(digest.digest(s.getBytes(Charset.forName("UTF-8"))));
    }

    public static List<String> commaDelimitedToList(String commas, int lengthLimit) {
        if (commas == null || commas.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> tgs = new LinkedHashSet<String>();
        for (String t : commas.split(",")) {
            if ((t = t.trim()).length() > lengthLimit) {
                throw new IllegalArgumentException("Length limit is " + lengthLimit);
            }
            if (t.isEmpty()) continue;
            tgs.add(t);
        }
        ArrayList<String> result = new ArrayList<String>(tgs);
        Collections.sort(result);
        return result;
    }

    public static String shuffleAndExtract(Random rnd, String s, int targetLength) {
        targetLength = Math.min(targetLength, s.length());
        char[] c = s.toCharArray();
        Strings.shuffle(rnd, c);
        return new String(Arrays.copyOf(c, targetLength));
    }

    static void shuffle(Random rnd, char[] array) {
        for (int i = 0; i < array.length - 2; ++i) {
            int r = rnd.nextInt(array.length);
            if (i == r) continue;
            char hold = array[i];
            array[i] = array[r];
            array[r] = hold;
        }
    }

    public static StringBuilder appendPaddedHex(byte val, StringBuilder sb) {
        return Strings.appendPaddedHex(val, false, sb);
    }

    public static StringBuilder appendPaddedHex(byte val, boolean upperCase, StringBuilder sb) {
        int right = val & 0xF;
        int left = (val & 0xF0) >> 4;
        return sb.append(Strings.nybblChar(left, upperCase)).append(Strings.nybblChar(right, upperCase));
    }

    public static StringBuilder appendPaddedHex(short val, StringBuilder sb) {
        return Strings.appendPaddedHex(val, false, sb);
    }

    public static StringBuilder appendPaddedHex(short val, boolean upperCase, StringBuilder sb) {
        for (int shift = 12; shift >= 0; shift -= 4) {
            int curr = (int)(0xFL & (long)(val >> shift));
            sb.append(Strings.nybblChar(curr, upperCase));
        }
        return sb;
    }

    public static StringBuilder appendPaddedHex(int val, StringBuilder sb) {
        return Strings.appendPaddedHex(val, false, sb);
    }

    public static char nybblChar(int curr, boolean upperCase) {
        switch (curr) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return upperCase ? (char)'A' : 'a';
            }
            case 11: {
                return upperCase ? (char)'B' : 'b';
            }
            case 12: {
                return upperCase ? (char)'C' : 'c';
            }
            case 13: {
                return upperCase ? (char)'D' : 'd';
            }
            case 14: {
                return upperCase ? (char)'E' : 'e';
            }
            case 15: {
                return upperCase ? (char)'F' : 'f';
            }
        }
        throw new AssertionError(curr);
    }

    public static StringBuilder appendPaddedHex(int val, boolean upperCase, StringBuilder sb) {
        for (int shift = 28; shift >= 0; shift -= 4) {
            int curr = 0xF & val >> shift;
            sb.append(Strings.nybblChar(curr, upperCase));
        }
        return sb;
    }

    public static StringBuilder appendPaddedHex(long val, StringBuilder sb) {
        return Strings.appendPaddedHex(val, false, sb);
    }

    public static StringBuilder appendPaddedHex(long val, boolean upperCase, StringBuilder sb) {
        for (int shift = 60; shift >= 0; shift -= 4) {
            int curr = (int)(0xFL & val >> shift);
            sb.append(Strings.nybblChar(curr, upperCase));
        }
        return sb;
    }

    public static String toPaddedHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            Strings.appendPaddedHex(b, sb);
        }
        return sb.toString();
    }

    public static String toPaddedHex(byte[] bytes, String delimiter) {
        StringBuilder sb = new StringBuilder(bytes.length * 2 + delimiter.length() * (bytes.length - 1));
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            Strings.appendPaddedHex(b, sb);
            if (i == bytes.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toPaddedHex(short[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (short b : bytes) {
            Strings.appendPaddedHex(b, sb);
        }
        return sb.toString();
    }

    public static String toPaddedHex(short[] bytes, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            short b = bytes[i];
            Strings.appendPaddedHex(b, sb);
            if (i == bytes.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toHex(char c) {
        String result = Integer.toString(c, 16);
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static String toPaddedHex(int[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int b : bytes) {
            Strings.appendPaddedHex(b, sb);
        }
        return sb.toString();
    }

    public static String toPaddedHex(int[] bytes, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            Strings.appendPaddedHex(b, sb);
            if (i == bytes.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toPaddedHex(long[] longs, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < longs.length; ++i) {
            long b = longs[i];
            Strings.appendPaddedHex(b, sb);
            if (i == longs.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String toNonPaddedBase36(byte[] bytes) {
        if (bytes.length % 8 != 0) {
            throw new IllegalArgumentException("Byte count must be divisible by 8, but is " + bytes.length);
        }
        LongBuffer buf = ByteBuffer.wrap(bytes).asLongBuffer();
        StringBuilder sb = new StringBuilder();
        while (buf.remaining() > 0) {
            sb.append(Long.toString(buf.get(), 36));
        }
        return sb.toString();
    }

    public static String toDelimitedPaddedBase36(byte[] bytes) {
        if (bytes.length % 8 != 0) {
            throw new IllegalArgumentException("Byte count must be divisible by 8, but is " + bytes.length);
        }
        LongBuffer buf = ByteBuffer.wrap(bytes).asLongBuffer();
        StringBuilder sb = new StringBuilder();
        while (buf.remaining() > 0) {
            long val = buf.get();
            if (val >= 0L) {
                if (sb.length() > 0) {
                    sb.append('~');
                }
                sb.append(Long.toString(val, 36));
                continue;
            }
            sb.append(Long.toString(val, 36));
        }
        return sb.toString();
    }

    public static boolean timingSafeEquals(String first, String second) {
        char[] secondChars;
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (second.length() <= 0) {
            return first.length() <= 0;
        }
        char[] firstChars = first.toCharArray();
        char result = (char)(firstChars.length != (secondChars = second.toCharArray()).length ? 1 : 0);
        int j = 0;
        for (int i = 0; i < firstChars.length; ++i) {
            result = (char)(result | firstChars[i] ^ secondChars[j]);
            j = (j + 1) % secondChars.length;
        }
        return result == '\u0000';
    }

    public static boolean timingSafeEquals(CharSequence first, CharSequence second) {
        int secondLength;
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (second.length() <= 0) {
            return first.length() <= 0;
        }
        int firstLength = first.length();
        char result = (char)(firstLength != (secondLength = second.length()) ? 1 : 0);
        int j = 0;
        for (int i = 0; i < firstLength; ++i) {
            result = (char)(result | first.charAt(i) ^ second.charAt(j));
            j = (j + 1) % secondLength;
        }
        return result == '\u0000';
    }

    public static CharSequence replaceAll(char c, String replacement, CharSequence in) {
        if (Strings.indexOf(c, in) < 0) {
            return in;
        }
        StringBuilder sb = new StringBuilder(in.length() + 4);
        int max = in.length();
        for (int i = 0; i < max; ++i) {
            char cc = in.charAt(i);
            if (cc == c) {
                sb.append(replacement);
                continue;
            }
            sb.append(cc);
        }
        return sb;
    }

    public static CharSequence quickJson(Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of arguments: " + Strings.join(',', args));
        }
        AppendableCharSequence sb = new AppendableCharSequence('{');
        for (int i = 0; i < args.length; i += 2) {
            CharSequence key = Strings.jsonArgument(args[i]);
            CharSequence val = Strings.jsonArgument(args[i + 1]);
            sb.append(key).append(':').append(val);
            if (i == args.length - 2) continue;
            sb.append(',');
        }
        return sb.append('}');
    }

    private static CharSequence jsonArgument(Object o) {
        if (o instanceof Collection || o != null && o.getClass().isArray()) {
            if (o.getClass().isArray()) {
                int max = Array.getLength(o);
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = 0; i < max; ++i) {
                    l.add(Array.get(o, i));
                }
                o = l;
            }
            Collection c = o;
            AppendableCharSequence sq = new AppendableCharSequence(c.size() + 4);
            sq.append(Strings.singleChar('['));
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o1 = it.next();
                sq.append(Strings.jsonArgument(o1));
                if (!it.hasNext()) continue;
                sq.append(Strings.singleChar(','));
            }
            sq.append(Strings.singleChar(']'));
            return sq;
        }
        if (!(o == null || o instanceof Number || o instanceof CharSequence || o instanceof Boolean || o instanceof Date || o instanceof ZonedDateTime || o instanceof OffsetDateTime || o instanceof LocalDateTime || o instanceof Duration || o instanceof Instant || o instanceof Enum)) {
            throw new IllegalArgumentException("quickJson does not support " + o.getClass().getName());
        }
        return Strings.escapeJson(o);
    }

    private static CharSequence escapeJson(Object o) {
        if (o instanceof Date) {
            Date d = (Date)o;
            ZonedDateTime zdt = ZonedDateTime.ofInstant(d.toInstant(), GMT);
            return Strings.quote(zdt.format(ISO_INSTANT));
        }
        if (o instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)o;
            return Strings.quote(zdt.format(ISO_INSTANT));
        }
        if (o instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)o;
            return Strings.quote(odt.format(ISO_INSTANT));
        }
        if (o instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)o;
            return Strings.quote(ldt.format(ISO_INSTANT));
        }
        if (o instanceof Instant) {
            Instant ins = (Instant)o;
            return Strings.quote(ZonedDateTime.ofInstant(ins, GMT).format(ISO_INSTANT));
        }
        if (o instanceof Duration) {
            Duration dur = (Duration)o;
            return Strings.quote(dur.toString());
        }
        if (o instanceof Enum) {
            return Strings.quote(((Enum)o).name());
        }
        if (o instanceof Number || o instanceof Boolean) {
            return o.toString();
        }
        if (o == null) {
            return "null";
        }
        String stringRep = o.toString();
        CharSequence result = Strings.replaceAll('\"', "\\\"", stringRep);
        result = Strings.replaceAll('\n', "\\n", result);
        result = Strings.replaceAll('\t', "\\t", result);
        return '\"' + result.toString() + '\"';
    }

    private static String quote(String s) {
        return '\"' + s + '\"';
    }

    public static AppendingCharSequence newAppendingCharSequence() {
        return new AppendableCharSequence(5);
    }

    public static AppendingCharSequence newAppendingCharSequence(int components) {
        return new AppendableCharSequence(components);
    }

    public static AppendingCharSequence newAppendingCharSequence(CharSequence seqs) {
        return new AppendableCharSequence(seqs);
    }

    public static Predicate<CharSequence> matchPrefixes(CharSequence ... sequences) {
        return MatchWords.matchPrefixes(sequences);
    }

    public static Predicate<CharSequence> matchWords(CharSequence ... sequences) {
        return MatchWords.matchWords(sequences);
    }

    public static Function<CharSequence, CharSequence> findPrefixes(CharSequence ... prefixen) {
        return MatchWords.findPrefixes(prefixen);
    }

    public static String escapeControlCharactersAndQuotes(CharSequence seq) {
        int len = seq.length();
        StringBuilder sb = new StringBuilder(seq.length() + 1);
        Strings.escapeControlCharactersAndQuotes(seq, len, sb);
        return sb.toString();
    }

    public static void escapeControlCharactersAndQuotes(CharSequence seq, StringBuilder into) {
        Strings.escapeControlCharactersAndQuotes(seq, seq.length(), into);
    }

    public static String singleQuote(CharSequence what) {
        return Strings.quote('\'', what);
    }

    public static String quote(CharSequence what) {
        return Strings.quote('\"', what);
    }

    public static String quotedLines(Iterable<? extends CharSequence> items) {
        return Strings.quote("\n", items);
    }

    public static String quotedCommaDelimitedLines(Iterable<? extends CharSequence> items) {
        return Strings.quote(",\n", items);
    }

    public static String quote(String delimiter, Iterable<? extends CharSequence> items) {
        return Strings.quote('\"', delimiter, items);
    }

    public static String singleQuote(String delimiter, Iterable<? extends CharSequence> items) {
        return Strings.quote('\'', delimiter, items);
    }

    public static String quote(char quoteChar, String delimiter, Iterable<? extends CharSequence> items) {
        StringBuilder sb = new StringBuilder();
        boolean hasDelimiter = delimiter != null && !delimiter.isEmpty();
        Iterator it = ((Iterable)Checks.notNull((String)"items", items)).iterator();
        while (it.hasNext()) {
            CharSequence seq = (CharSequence)it.next();
            Strings.appendQuoted(quoteChar, seq, Escaper.CONTROL_CHARACTERS.escaping(quoteChar), sb);
            if (!hasDelimiter || !it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String quote(char quoteChar, CharSequence what) {
        StringBuilder sb = new StringBuilder(what.length() + 12);
        Strings.appendQuoted(quoteChar, what, Escaper.CONTROL_CHARACTERS.escaping(quoteChar), sb);
        return sb.toString();
    }

    private static StringBuilder appendQuoted(char quoteChar, CharSequence what, Escaper escaper, StringBuilder into) {
        into.append(quoteChar);
        Strings.escape(what, what.length(), escaper, into);
        into.append(quoteChar);
        return into;
    }

    public static String escape(CharSequence seq, Escaper escaper) {
        StringBuilder sb = new StringBuilder(seq.length() + 5);
        Strings.escape(seq, seq.length(), escaper, sb);
        return sb.toString();
    }

    public static void escape(CharSequence seq, int len, Escaper escaper, StringBuilder into) {
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = seq.charAt(i);
            CharSequence escaped = escaper.escape(c, i, len, prev);
            if (escaped != null) {
                into.append(escaped);
            } else {
                into.append(c);
            }
            prev = c;
        }
    }

    private static void escapeControlCharactersAndQuotes(CharSequence seq, int len, StringBuilder sb) {
        Strings.escape(seq, len, Escaper.CONTROL_CHARACTERS.escapeDoubleQuotes(), sb);
    }

    public static String zeroPrefix(int value, int length) {
        return new String(Strings.zeroPrefixChars(value, length));
    }

    public static String zeroPrefix(long value, int length) {
        return new String(Strings.zeroPrefixChars(value, length));
    }

    static char[] writeInto(int value, char[] target) {
        char[] nue;
        if (value == Integer.MIN_VALUE) {
            return Strings.writeInto((long)value, target);
        }
        if (value == 0) {
            if (target.length > 0) {
                Arrays.fill(target, '0');
                return target;
            }
            return new char[]{'0'};
        }
        int cursor = target.length - 1;
        boolean negative = value < 0;
        int curr = value;
        int pos = 0;
        while (curr != 0) {
            if (cursor < 0) {
                nue = new char[target.length + 1];
                System.arraycopy(target, 0, nue, 1, target.length);
                target = nue;
            }
            int n = ++cursor;
            --cursor;
            target[n] = (char)(48 + Math.abs(curr % 10));
            if ((curr /= 10) == 0) break;
            ++pos;
        }
        if (pos < target.length) {
            Arrays.fill(target, 0, target.length - (pos + 1), '0');
        }
        if (negative) {
            if (pos < target.length) {
                if (target[0] != '0') {
                    nue = new char[target.length + 1];
                    System.arraycopy(target, 0, nue, 1, target.length);
                    target = nue;
                }
                target[0] = 45;
            } else {
                nue = new char[target.length + 1];
                System.arraycopy(target, 0, nue, 1, target.length);
                target = nue;
                target[0] = 45;
            }
        }
        return target;
    }

    static char[] writeInto(long value, char[] target) {
        if (value == 0L) {
            if (target.length > 0) {
                Arrays.fill(target, '0');
                return target;
            }
            return new char[]{'0'};
        }
        int cursor = target.length - 1;
        boolean negative = value < 0L;
        long curr = value;
        int pos = 0;
        while (curr != 0L) {
            if (cursor < 0) {
                char[] nue = new char[target.length + 1];
                System.arraycopy(target, 0, nue, 1, target.length);
                target = nue;
                ++cursor;
            }
            char nextChar = (char)(48L + Math.abs(curr % 10L));
            assert (nextChar >= '0' && nextChar <= '9') : "@ " + pos + " '" + nextChar + "' " + cursor + " '" + new String(target) + "' " + value;
            target[cursor--] = nextChar;
            if ((curr /= 10L) == 0L) break;
            ++pos;
        }
        if (pos < target.length) {
            Arrays.fill(target, 0, target.length - (pos + 1), '0');
        }
        if (negative) {
            if (pos < target.length) {
                if (target[0] != '0') {
                    char[] nue = new char[target.length + 1];
                    System.arraycopy(target, 0, nue, 1, target.length);
                    target = nue;
                }
                target[0] = 45;
            } else {
                char[] nue = new char[target.length + 1];
                System.arraycopy(target, 0, nue, 1, target.length);
                target = nue;
                target[0] = 45;
            }
        }
        return target;
    }

    public static char[] zeroPrefixChars(int value, int length) {
        Checks.nonNegative((String)"length", (int)length);
        if (value >= 0 && value < 10 && length > 0) {
            char[] result = new char[length];
            Arrays.fill(result, 0, length - 1, '0');
            result[length - 1] = (char)(48 + value);
            return result;
        }
        return Strings.writeInto(value, new char[length]);
    }

    public static char[] zeroPrefixChars(long value, int length) {
        Checks.nonNegative((String)"length", (int)length);
        if (value >= 0L && value < 10L && length > 0) {
            char[] result = new char[length];
            Arrays.fill(result, 0, length - 1, '0');
            result[length - 1] = (char)(48L + value);
            return result;
        }
        return Strings.writeInto(value, new char[length]);
    }

    public static String unquote(String s) {
        char end;
        char start;
        if ((s = s.trim()).length() > 1 && ((start = s.charAt(0)) == '\"' || start == '\'') && (end = s.charAt(s.length() - 1)) == start) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static CharSequence unquoteCharSequence(CharSequence s) {
        char end;
        char start;
        int len = s.length();
        if (len > 1 && ((start = s.charAt(0)) == '\"' || start == '\'') && (end = s.charAt(len - 1)) == start) {
            return s.subSequence(1, s.length() - 1);
        }
        return s;
    }

    public static CharSequence elide(CharSequence orig) {
        return Strings.elide(orig, 40);
    }

    public static CharSequence elide(CharSequence orig, int thresholdLength) {
        return Strings.elide(orig, Checks.greaterThanOne((String)"maxLength", (int)thresholdLength), ELLIPSIS);
    }

    public static CharSequence elide(CharSequence orig, int targetLength, CharSequence ellipsis) {
        int i;
        int leftEnd;
        int halfLength;
        int len = orig.length();
        if (len <= targetLength) {
            return orig;
        }
        targetLength -= ellipsis.length();
        targetLength = Math.max(targetLength, 3);
        if (len <= 2 + ellipsis.length() + 1 || orig.length() <= targetLength) {
            return orig;
        }
        if (targetLength % 2 != 0) {
            --targetLength;
        }
        if (targetLength <= 3) {
            return new AppendableCharSequence(Strings.singleChar(orig.charAt(0)), ellipsis, Strings.singleChar(orig.charAt(orig.length() - 1)));
        }
        int rightStart = len - halfLength;
        int leftScanStop = Math.max(leftEnd - leftEnd / 3, leftEnd - 12);
        int rightScanStop = Math.min(rightStart + (len - rightStart) / 3, rightStart + 12);
        if (!Character.isWhitespace(orig.charAt(leftEnd))) {
            for (i = leftEnd - 1; i > leftScanStop; --i) {
                if (!Character.isWhitespace(orig.charAt(i))) continue;
                rightStart -= leftEnd - i;
                leftEnd = i;
                break;
            }
        } else {
            for (leftEnd = halfLength = targetLength / 2; leftEnd > leftScanStop && Character.isWhitespace(orig.charAt(leftEnd + 1)); --leftEnd) {
            }
        }
        if (!Character.isWhitespace(orig.charAt(rightStart))) {
            for (i = rightStart + 1; i < rightScanStop; ++i) {
                if (!Character.isWhitespace(orig.charAt(i))) continue;
                rightStart = i + 1;
                break;
            }
        } else {
            while (rightStart < orig.length() - 2 && Character.isWhitespace(orig.charAt(rightStart))) {
                ++rightStart;
            }
        }
        CharSequence left = orig.subSequence(0, leftEnd);
        CharSequence right = orig.subSequence(rightStart, len);
        return new AppendableCharSequence(left, ellipsis, right);
    }

    public static CharSequence truncate(CharSequence orig, int maxLength) {
        return Strings.truncate(orig, maxLength, ELLIPSIS);
    }

    public static CharSequence truncate(CharSequence orig, int maxLength, CharSequence ellipsis) {
        int end;
        int len = orig.length();
        if (len <= Checks.greaterThanZero((String)"maxLength", (int)maxLength)) {
            return orig;
        }
        int maxFudge = Math.max(2, Math.max(end - maxLength / 3, end - 12));
        for (end = Math.min(maxLength, len); end > maxFudge && Character.isWhitespace(orig.charAt(end - 1)); --end) {
        }
        if (end >= len - 1 || !Character.isWhitespace(orig.charAt(end + 1))) {
            for (int i = Math.min(len - 1, end); i >= maxFudge; --i) {
                if (!Character.isWhitespace(orig.charAt(i))) continue;
                end = i;
                break;
            }
        }
        if (ellipsis == null || ellipsis.length() == 0) {
            return orig.subSequence(0, end);
        }
        return new AppendableCharSequence(orig.subSequence(0, end), ellipsis);
    }

    public static Object lazy(Object stringify) {
        return new LazyToString(stringify);
    }

    public static Object wrappedSupplier(Supplier<String> s) {
        return new LazySupplierToString(s);
    }

    public static CharSequence lazyCharSequence(Supplier<String> s) {
        return new LazyCharSequence(s, true);
    }

    public static CharSequence lazyCharSequence(Supplier<String> s, boolean cache) {
        return new LazyCharSequence(s, cache);
    }

    public static String capitalize(CharSequence orig) {
        if (orig.length() == 0 || Character.isUpperCase(orig.charAt(0))) {
            return orig instanceof String ? (String)orig : orig.toString();
        }
        char[] chars = Strings.toCharArray(orig);
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static char[] toCharArray(CharSequence seq) {
        int len = seq.length();
        switch (len) {
            case 0: {
                return EMPTY_CHARS;
            }
            case 1: {
                return new char[]{seq.charAt(0)};
            }
            case 2: {
                return new char[]{seq.charAt(0), seq.charAt(1)};
            }
            case 3: {
                return new char[]{seq.charAt(0), seq.charAt(1), seq.charAt(2)};
            }
            case 4: {
                return new char[]{seq.charAt(0), seq.charAt(1), seq.charAt(2), seq.charAt(3)};
            }
            case 5: {
                return new char[]{seq.charAt(0), seq.charAt(1), seq.charAt(2), seq.charAt(3), seq.charAt(4)};
            }
        }
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            result[i] = seq.charAt(i);
        }
        return result;
    }

    public static boolean isDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        if (ch < '0') {
            return false;
        }
        if (ch > '9' && ch < '\u0080') {
            return false;
        }
        return Character.isDigit(ch);
    }

    public static boolean isDigits(CharSequence seq) {
        return Strings.is(seq, IS_DIGIT);
    }

    public static boolean isLetters(CharSequence seq) {
        return Strings.is(seq, IS_LETTERS);
    }

    public static boolean isPositiveDecimal(CharSequence seq) {
        PositiveDecimalCheck pdc = new PositiveDecimalCheck();
        return Strings.is(seq, pdc) && pdc.dotCount == 1 && seq.charAt(seq.length() - 1) != '.';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean is(CharSequence in, CharPred pred) {
        int max = in.length();
        switch (max) {
            case 0: {
                return false;
            }
            case 1: {
                return pred.test(in.charAt(0));
            }
            case 2: {
                if (!pred.test(in.charAt(0))) return false;
                if (!pred.test(in.charAt(1))) return false;
                return true;
            }
            case 3: {
                if (!pred.test(in.charAt(1))) return false;
                if (!pred.test(in.charAt(0))) return false;
                if (!pred.test(in.charAt(2))) return false;
                return true;
            }
            case 4: {
                if (!pred.test(in.charAt(1))) return false;
                if (!pred.test(in.charAt(3))) return false;
                if (!pred.test(in.charAt(0))) return false;
                if (!pred.test(in.charAt(2))) return false;
                return true;
            }
            case 5: {
                if (!pred.test(in.charAt(0))) return false;
                if (!pred.test(in.charAt(4))) return false;
                if (!pred.test(in.charAt(3))) return false;
                if (!pred.test(in.charAt(1))) return false;
                if (!pred.test(in.charAt(2))) return false;
                return true;
            }
        }
        boolean odd = max % 2 != 0;
        int mid = max / 2;
        if (odd) {
            if (!pred.test(in.charAt(mid))) return false;
            int i = 0;
            while (i < mid) {
                if (!pred.test(in.charAt(i))) {
                    return false;
                }
                if (!pred.test(in.charAt(max - (i + 1)))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < mid) {
            if (!pred.test(in.charAt(i))) {
                return false;
            }
            if (!pred.test(in.charAt(max - (i + 1)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BiIterateResult biIterate(CharSequence in, BiIterationReceiver func) {
        int max = ((CharSequence)Checks.notNull((String)"in", (Object)in)).length();
        switch (max) {
            case 0: {
                return BiIterateResult.MAYBE;
            }
            case 1: {
                return func.onChar(0, in.charAt(0), 1, 0);
            }
            case 2: {
                return func.onChar(0, in.charAt(0), 2, 1).or(func.onChar(1, in.charAt(1), 2, 0));
            }
            case 3: {
                return func.onChar(1, in.charAt(1), 3, 2).or(func.onChar(0, in.charAt(0), 3, 1).or(func.onChar(2, in.charAt(2), 3, 0)));
            }
        }
        boolean odd = max % 2 != 0;
        int mid = max / 2;
        int remaining = max;
        if (odd) {
            BiIterateResult res = func.onChar(mid, in.charAt(mid), max, --remaining);
            if (!res.isOk()) return res;
            block18: for (int i = 0; i < mid; ++i) {
                res = func.onChar(i, in.charAt(i), max, --remaining);
                switch (res) {
                    case MAYBE: {
                        break;
                    }
                    default: {
                        return res;
                    }
                }
                int op = max - (i + 1);
                res = func.onChar(op, in.charAt(op), max, --remaining);
                switch (res) {
                    case MAYBE: {
                        continue block18;
                    }
                    default: {
                        return res;
                    }
                }
            }
            return BiIterateResult.MAYBE;
        } else {
            block19: for (int i = 0; i < mid; ++i) {
                BiIterateResult res = func.onChar(i, in.charAt(i), max, --remaining);
                switch (res) {
                    case MAYBE: {
                        break;
                    }
                    default: {
                        return res;
                    }
                }
                int op = max - (i + 1);
                res = func.onChar(op, in.charAt(op), max, --remaining);
                switch (res) {
                    case MAYBE: {
                        continue block19;
                    }
                    default: {
                        return res;
                    }
                }
            }
        }
        return BiIterateResult.MAYBE;
    }

    public static <T extends Enum<T>> Function<CharSequence, T> literalMatcher(Class<T> enumType) {
        return MultiLiteralPattern.forEnums(enumType);
    }

    public static <T extends Enum<T>> Function<CharSequence, T> literalMatcher(Map<T, CharSequence> m) {
        return MultiLiteralPattern.forEnums(m);
    }

    public static Function<CharSequence, Integer> literalMatcher(CharSequence ... patterns) {
        return MultiLiteralPattern.forStrings(patterns);
    }

    public static <T extends Enum<T>> T findMatch(Map<T, CharSequence> map, CharSequence input) {
        return (T)((Enum)Strings.literalMatcher(map).apply(input));
    }

    public static Integer findMatch(CharSequence input, CharSequence ... literalPatterns) {
        return Strings.literalMatcher(literalPatterns).apply(input);
    }

    public static <T extends Enum<T>> T findMatch(Class<T> type, CharSequence input) {
        return (T)((Enum)Strings.literalMatcher(type).apply(input));
    }

    public static String variableSubstitution(String target, String prefix, String suffix, Function<String, Optional<CharSequence>> replacements) {
        if (target.contains(prefix)) {
            int endIx;
            StringBuilder result = null;
            int ix = target.indexOf("${");
            int lastEnd = 0;
            while (ix >= 0 && ix < target.length() - prefix.length() && (endIx = target.indexOf(suffix, ix + prefix.length())) >= ix) {
                String toResolve = target.substring(ix + prefix.length(), endIx);
                Optional<CharSequence> maybeResolved = replacements.apply(toResolve);
                if (maybeResolved.isPresent()) {
                    if (result == null) {
                        result = new StringBuilder();
                    }
                    result.append(target.substring(lastEnd, ix));
                    result.append(maybeResolved.get());
                }
                lastEnd = endIx + 1;
                ix = target.indexOf(prefix, endIx);
            }
            if (result != null) {
                if (lastEnd < target.length() - 1) {
                    result.append(target.substring(lastEnd));
                }
                return result.toString();
            }
        }
        return target;
    }

    public static void sortByJaccardSimilarity(int n, CharSequence to, List<? extends CharSequence> l) {
        l.sort((a, b) -> {
            double aval = Strings.jaccardSimilarity(n, to, a);
            double bval = Strings.jaccardSimilarity(n, to, b);
            return Double.compare(bval, aval);
        });
    }

    public static double jaccardSimilarity(int n, CharSequence a, CharSequence b) {
        HashSet<ComparableCharSequence> agrams = new HashSet<ComparableCharSequence>(Strings.toNGrams(true, n, a));
        HashSet<ComparableCharSequence> bgrams = new HashSet<ComparableCharSequence>(Strings.toNGrams(true, n, b));
        if (agrams.isEmpty() || bgrams.isEmpty()) {
            return 0.0;
        }
        HashSet<ComparableCharSequence> isect = new HashSet<ComparableCharSequence>(agrams);
        isect.retainAll(bgrams);
        HashSet<ComparableCharSequence> union = new HashSet<ComparableCharSequence>(agrams);
        union.addAll(bgrams);
        return (double)isect.size() / (double)union.size();
    }

    public static List<ComparableCharSequence> toNGrams(boolean fromHead, int n, CharSequence seq) {
        if (n == 0) {
            throw new IllegalArgumentException("0 n-gram size");
        }
        if (n == 1) {
            int len = ((CharSequence)Checks.notNull((String)"seq", (Object)seq)).length();
            ArrayList<ComparableCharSequence> result = new ArrayList<ComparableCharSequence>(len);
            for (int i = 0; i < len; ++i) {
                result.add(Strings.singleChar(seq.charAt(i)));
            }
            return result;
        }
        int len = ((CharSequence)Checks.notNull((String)"seq", (Object)seq)).length();
        if (len == 0) {
            return Collections.emptyList();
        }
        if (len < n) {
            return Collections.singletonList(Strings.wrap(seq));
        }
        ArrayList<ComparableCharSequence> list = new ArrayList<ComparableCharSequence>(len / n + (len % n == 0 ? 0 : 1));
        if (fromHead) {
            for (int i = 0; i < len; i += n) {
                int end = Math.min(len, i + n);
                list.add(new NoCopySubsequence(seq, i, end));
            }
        } else {
            for (int i = len; i >= 0; i -= n) {
                int start = Math.max(0, i - n);
                if (start >= i) continue;
                list.add(0, new NoCopySubsequence(seq, start, i));
            }
        }
        return list;
    }

    public static ComparableCharSequence trimmedSubsequence(CharSequence orig) {
        int start = 0;
        int len = orig.length();
        if (len == 0) {
            return ComparableCharSequence.EMPTY;
        }
        int end = len;
        boolean nonWhitespaceSeenAtStart = false;
        boolean nonWhitespaceSeenAtEnd = false;
        for (int i = 0; i < len; ++i) {
            if (!nonWhitespaceSeenAtStart) {
                char startChar = orig.charAt(i);
                if (Character.isWhitespace(startChar)) {
                    start = i + 1;
                } else {
                    nonWhitespaceSeenAtStart = true;
                }
            }
            if (!nonWhitespaceSeenAtEnd) {
                int pos = len - (i + 1);
                char endChar = orig.charAt(pos);
                if (Character.isWhitespace(endChar)) {
                    end = pos;
                } else {
                    nonWhitespaceSeenAtEnd = true;
                }
            }
            if (start >= end) {
                return ComparableCharSequence.EMPTY;
            }
            if (nonWhitespaceSeenAtEnd && nonWhitespaceSeenAtStart) break;
        }
        if (start == 0 && end == len) {
            return Strings.wrap(orig);
        }
        if (end == start + 1) {
            return Strings.singleChar(orig.charAt(start));
        }
        return Strings.wrap(orig.subSequence(start, end));
    }

    static ComparableCharSequence wrap(CharSequence what) {
        if (what instanceof ComparableCharSequence) {
            return (ComparableCharSequence)what;
        }
        switch (what.length()) {
            case 0: {
                return ComparableCharSequence.EMPTY;
            }
            case 1: {
                return Strings.singleChar(what.charAt(0));
            }
        }
        return new ComparableCharSequenceWrapper(what);
    }

    static {
        for (int i = 0; i < 128; ++i) {
            if (!Strings.isPunctuation((char)i)) continue;
            PUNC.set(i);
        }
        puncInitialized = true;
        EMPTY = new EmptyCharSequence();
        CR = new SingleCharSequence('\n');
        COMMA = new SingleCharSequence(',');
        DOT = new SingleCharSequence('.');
        COLON = new SingleCharSequence(':');
        OPEN_CURLY = new SingleCharSequence('{');
        CLOSE_CURLY = new SingleCharSequence('}');
        OPEN_PAREN = new SingleCharSequence('(');
        CLOSE_PAREN = new SingleCharSequence(')');
        OPEN_SQUARE = new SingleCharSequence('[');
        CLOSE_SQUARE = new SingleCharSequence(']');
        SLASH = new SingleCharSequence('/');
        ISO_INSTANT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant().toFormatter(Locale.US);
        GMT = ZoneId.of("GMT");
        EMPTY_CHARS = new char[0];
        IS_DIGIT = Strings::isDigit;
        IS_LETTERS = Character::isLetter;
    }

    static final class LazySupplierToString {
        private final Supplier<String> stringify;

        public LazySupplierToString(Supplier<String> stringify) {
            this.stringify = stringify;
        }

        public String toString() {
            String result = this.stringify.get();
            return result == null ? "null" : result;
        }
    }

    static final class LazyToString {
        private final Object stringify;

        public LazyToString(Object stringify) {
            this.stringify = stringify;
        }

        public String toString() {
            return Objects.toString(this.stringify);
        }
    }

    public static interface CharPred {
        public boolean test(char var1);

        default public CharPred or(CharPred other) {
            return ch -> this.test(ch) || other.test(ch);
        }

        default public CharPred and(CharPred other) {
            return ch -> this.test(ch) && other.test(ch);
        }
    }

    private static final class NoCopySubsequence
    implements ComparableCharSequence {
        private final CharSequence str;
        private final int start;
        private final int end;
        private int hc = 0;

        NoCopySubsequence(CharSequence orig, int start, int end) {
            this.start = start;
            this.end = end;
            this.str = orig;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return this.str.charAt(this.start + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start == end) {
                return "";
            }
            if (start > end) {
                throw new IllegalArgumentException("Start " + start + " is > end " + end);
            }
            int newStart = start + this.start;
            return new NoCopySubsequence(this.str, newStart, newStart + (end - start));
        }

        @Override
        public String toString() {
            return this.str.toString().substring(this.start, this.end);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharSequence)) {
                return false;
            }
            CharSequence seq = (CharSequence)o;
            return Strings.charSequencesEqual(this, seq);
        }

        public int hashCode() {
            return this.hc == 0 ? (this.hc = Strings.charSequenceHashCode(this)) : this.hc;
        }
    }

    private static final class ComparableCharSequenceWrapper
    implements ComparableCharSequence {
        private final CharSequence orig;

        ComparableCharSequenceWrapper(CharSequence orig) {
            this.orig = orig;
        }

        @Override
        public int length() {
            return this.orig.length();
        }

        @Override
        public char charAt(int index) {
            return this.orig.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.orig.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.orig.toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharSequence)) {
                return false;
            }
            CharSequence seq = (CharSequence)o;
            return Strings.charSequencesEqual(this.orig, seq);
        }

        public int hashCode() {
            return this.orig.hashCode();
        }
    }

    public static enum BiIterateResult {
        YES,
        MAYBE,
        NO;


        public BiIterateResult or(BiIterateResult res) {
            if (res == this) {
                return this;
            }
            if (res == NO || this == NO) {
                return NO;
            }
            return MAYBE;
        }

        public boolean isOk() {
            return this == YES || this == MAYBE;
        }

        public boolean isSuccess() {
            return this == YES;
        }

        public boolean isFinished() {
            return this == YES || this == null;
        }
    }

    @FunctionalInterface
    public static interface BiIterationReceiver {
        public BiIterateResult onChar(int var1, char var2, int var3, int var4);
    }

    static class PositiveDecimalCheck
    implements CharPred {
        private int dotCount;

        PositiveDecimalCheck() {
        }

        @Override
        public boolean test(char ch) {
            switch (ch) {
                case '.': {
                    ++this.dotCount;
                    return true;
                }
            }
            return Strings.isDigit(ch);
        }
    }

    private static final class EmptyCharSequence
    implements CharSequence {
        private EmptyCharSequence() {
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new StringIndexOutOfBoundsException(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start == 0 && end == 0) {
                return this;
            }
            throw new StringIndexOutOfBoundsException("Empty but requested subsequence from " + start + " to " + end);
        }

        @Override
        public String toString() {
            return "";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof CharSequence && ((CharSequence)o).length() == 0;
        }
    }

    private static final class CharSequenceComparator
    implements Comparator<CharSequence> {
        private static final Comparator<CharSequence> INSENSITIVE = new CharSequenceComparator(true);
        private static final Comparator<CharSequence> SENSITIVE = new CharSequenceComparator(false);
        private final boolean caseInsensitive;

        CharSequenceComparator(boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return Strings.compareCharSequences(o1, o2, this.caseInsensitive);
        }
    }
}

